package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OpsGenieConfigFluentImpl<A extends OpsGenieConfigFluent<A>> extends BaseFluent<A> implements OpsGenieConfigFluent<A>{
  public OpsGenieConfigFluentImpl() {
  }
  public OpsGenieConfigFluentImpl(OpsGenieConfig instance) {
    this.withApiKey(instance.getApiKey()); 
    this.withApiURL(instance.getApiURL()); 
    this.withDescription(instance.getDescription()); 
    this.withDetails(instance.getDetails()); 
    this.withHttpConfig(instance.getHttpConfig()); 
    this.withMessage(instance.getMessage()); 
    this.withNote(instance.getNote()); 
    this.withPriority(instance.getPriority()); 
    this.withResponders(instance.getResponders()); 
    this.withSendResolved(instance.getSendResolved()); 
    this.withSource(instance.getSource()); 
    this.withTags(instance.getTags()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SecretKeySelector apiKey;
  private String apiURL;
  private String description;
  private ArrayList<KeyValueBuilder> details = new ArrayList<KeyValueBuilder>();
  private HTTPConfigBuilder httpConfig;
  private String message;
  private String note;
  private String priority;
  private ArrayList<OpsGenieConfigResponderBuilder> responders = new ArrayList<OpsGenieConfigResponderBuilder>();
  private Boolean sendResolved;
  private String source;
  private String tags;
  private Map<String,Object> additionalProperties;
  public SecretKeySelector getApiKey() {
    return this.apiKey;
  }
  public A withApiKey(SecretKeySelector apiKey) {
    this.apiKey=apiKey; return (A) this;
  }
  public Boolean hasApiKey() {
    return this.apiKey != null;
  }
  public A withNewApiKey(String key,String name,Boolean optional) {
    return (A)withApiKey(new SecretKeySelector(key, name, optional));
  }
  public String getApiURL() {
    return this.apiURL;
  }
  public A withApiURL(String apiURL) {
    this.apiURL=apiURL; return (A) this;
  }
  public Boolean hasApiURL() {
    return this.apiURL != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public A addToDetails(Integer index,KeyValue item) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(index >= 0 ? index : _visitables.get("details").size(), builder);this.details.add(index >= 0 ? index : details.size(), builder); return (A)this;
  }
  public A setToDetails(Integer index,KeyValue item) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);
    if (index < 0 || index >= _visitables.get("details").size()) { _visitables.get("details").add(builder); } else { _visitables.get("details").set(index, builder);}
    if (index < 0 || index >= details.size()) { details.add(builder); } else { details.set(index, builder);}
     return (A)this;
  }
  public A addToDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  public A addAllToDetails(Collection<KeyValue> items) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  public A removeFromDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
  }
  public A removeAllFromDetails(Collection<KeyValue> items) {
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDetails(Predicate<KeyValueBuilder> predicate) {
    if (details == null) return (A) this;
    final Iterator<KeyValueBuilder> each = details.iterator();
    final List visitables = _visitables.get("details");
    while (each.hasNext()) {
      KeyValueBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDetails instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KeyValue> getDetails() {
    return details != null ? build(details) : null;
  }
  public List<KeyValue> buildDetails() {
    return details != null ? build(details) : null;
  }
  public KeyValue buildDetail(Integer index) {
    return this.details.get(index).build();
  }
  public KeyValue buildFirstDetail() {
    return this.details.get(0).build();
  }
  public KeyValue buildLastDetail() {
    return this.details.get(details.size() - 1).build();
  }
  public KeyValue buildMatchingDetail(Predicate<KeyValueBuilder> predicate) {
    for (KeyValueBuilder item: details) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDetail(Predicate<KeyValueBuilder> predicate) {
    for (KeyValueBuilder item: details) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDetails(List<KeyValue> details) {
    if (this.details != null) { _visitables.get("details").removeAll(this.details);}
    if (details != null) {this.details = new ArrayList(); for (KeyValue item : details){this.addToDetails(item);}} else { this.details = null;} return (A) this;
  }
  public A withDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... details) {
    if (this.details != null) {this.details.clear();}
    if (details != null) {for (KeyValue item :details){ this.addToDetails(item);}} return (A) this;
  }
  public Boolean hasDetails() {
    return details != null && !details.isEmpty();
  }
  public A addNewDetail(String key,String value) {
    return (A)addToDetails(new KeyValue(key, value));
  }
  public OpsGenieConfigFluent.DetailsNested<A> addNewDetail() {
    return new OpsGenieConfigFluentImpl.DetailsNestedImpl();
  }
  public OpsGenieConfigFluent.DetailsNested<A> addNewDetailLike(KeyValue item) {
    return new OpsGenieConfigFluentImpl.DetailsNestedImpl(-1, item);
  }
  public OpsGenieConfigFluent.DetailsNested<A> setNewDetailLike(Integer index,KeyValue item) {
    return new OpsGenieConfigFluentImpl.DetailsNestedImpl(index, item);
  }
  public OpsGenieConfigFluent.DetailsNested<A> editDetail(Integer index) {
    if (details.size() <= index) throw new RuntimeException("Can't edit details. Index exceeds size.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public OpsGenieConfigFluent.DetailsNested<A> editFirstDetail() {
    if (details.size() == 0) throw new RuntimeException("Can't edit first details. The list is empty.");
    return setNewDetailLike(0, buildDetail(0));
  }
  public OpsGenieConfigFluent.DetailsNested<A> editLastDetail() {
    int index = details.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last details. The list is empty.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public OpsGenieConfigFluent.DetailsNested<A> editMatchingDetail(Predicate<KeyValueBuilder> predicate) {
    int index = -1;
    for (int i=0;i<details.size();i++) { 
    if (predicate.test(details.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching details. No match found.");
    return setNewDetailLike(index, buildDetail(index));
  }
  
  /**
   * This method has been deprecated, please use method buildHttpConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPConfig getHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public A withHttpConfig(HTTPConfig httpConfig) {
    _visitables.get("httpConfig").remove(this.httpConfig);
    if (httpConfig!=null){ this.httpConfig= new HTTPConfigBuilder(httpConfig); _visitables.get("httpConfig").add(this.httpConfig);} else { this.httpConfig = null; _visitables.get("httpConfig").remove(this.httpConfig); } return (A) this;
  }
  public Boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  public OpsGenieConfigFluent.HttpConfigNested<A> withNewHttpConfig() {
    return new OpsGenieConfigFluentImpl.HttpConfigNestedImpl();
  }
  public OpsGenieConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new OpsGenieConfigFluentImpl.HttpConfigNestedImpl(item);
  }
  public OpsGenieConfigFluent.HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig());
  }
  public OpsGenieConfigFluent.HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): new HTTPConfigBuilder().build());
  }
  public OpsGenieConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): item);
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  public String getNote() {
    return this.note;
  }
  public A withNote(String note) {
    this.note=note; return (A) this;
  }
  public Boolean hasNote() {
    return this.note != null;
  }
  public String getPriority() {
    return this.priority;
  }
  public A withPriority(String priority) {
    this.priority=priority; return (A) this;
  }
  public Boolean hasPriority() {
    return this.priority != null;
  }
  public A addToResponders(Integer index,OpsGenieConfigResponder item) {
    if (this.responders == null) {this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();}
    OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);_visitables.get("responders").add(index >= 0 ? index : _visitables.get("responders").size(), builder);this.responders.add(index >= 0 ? index : responders.size(), builder); return (A)this;
  }
  public A setToResponders(Integer index,OpsGenieConfigResponder item) {
    if (this.responders == null) {this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();}
    OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
    if (index < 0 || index >= _visitables.get("responders").size()) { _visitables.get("responders").add(builder); } else { _visitables.get("responders").set(index, builder);}
    if (index < 0 || index >= responders.size()) { responders.add(builder); } else { responders.set(index, builder);}
     return (A)this;
  }
  public A addToResponders(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder... items) {
    if (this.responders == null) {this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();}
    for (OpsGenieConfigResponder item : items) {OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);_visitables.get("responders").add(builder);this.responders.add(builder);} return (A)this;
  }
  public A addAllToResponders(Collection<OpsGenieConfigResponder> items) {
    if (this.responders == null) {this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();}
    for (OpsGenieConfigResponder item : items) {OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);_visitables.get("responders").add(builder);this.responders.add(builder);} return (A)this;
  }
  public A removeFromResponders(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder... items) {
    for (OpsGenieConfigResponder item : items) {OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);_visitables.get("responders").remove(builder);if (this.responders != null) {this.responders.remove(builder);}} return (A)this;
  }
  public A removeAllFromResponders(Collection<OpsGenieConfigResponder> items) {
    for (OpsGenieConfigResponder item : items) {OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);_visitables.get("responders").remove(builder);if (this.responders != null) {this.responders.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResponders(Predicate<OpsGenieConfigResponderBuilder> predicate) {
    if (responders == null) return (A) this;
    final Iterator<OpsGenieConfigResponderBuilder> each = responders.iterator();
    final List visitables = _visitables.get("responders");
    while (each.hasNext()) {
      OpsGenieConfigResponderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResponders instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OpsGenieConfigResponder> getResponders() {
    return responders != null ? build(responders) : null;
  }
  public List<OpsGenieConfigResponder> buildResponders() {
    return responders != null ? build(responders) : null;
  }
  public OpsGenieConfigResponder buildResponder(Integer index) {
    return this.responders.get(index).build();
  }
  public OpsGenieConfigResponder buildFirstResponder() {
    return this.responders.get(0).build();
  }
  public OpsGenieConfigResponder buildLastResponder() {
    return this.responders.get(responders.size() - 1).build();
  }
  public OpsGenieConfigResponder buildMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
    for (OpsGenieConfigResponderBuilder item: responders) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
    for (OpsGenieConfigResponderBuilder item: responders) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResponders(List<OpsGenieConfigResponder> responders) {
    if (this.responders != null) { _visitables.get("responders").removeAll(this.responders);}
    if (responders != null) {this.responders = new ArrayList(); for (OpsGenieConfigResponder item : responders){this.addToResponders(item);}} else { this.responders = null;} return (A) this;
  }
  public A withResponders(io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder... responders) {
    if (this.responders != null) {this.responders.clear();}
    if (responders != null) {for (OpsGenieConfigResponder item :responders){ this.addToResponders(item);}} return (A) this;
  }
  public Boolean hasResponders() {
    return responders != null && !responders.isEmpty();
  }
  public A addNewResponder(String id,String name,String type,String username) {
    return (A)addToResponders(new OpsGenieConfigResponder(id, name, type, username));
  }
  public OpsGenieConfigFluent.RespondersNested<A> addNewResponder() {
    return new OpsGenieConfigFluentImpl.RespondersNestedImpl();
  }
  public OpsGenieConfigFluent.RespondersNested<A> addNewResponderLike(OpsGenieConfigResponder item) {
    return new OpsGenieConfigFluentImpl.RespondersNestedImpl(-1, item);
  }
  public OpsGenieConfigFluent.RespondersNested<A> setNewResponderLike(Integer index,OpsGenieConfigResponder item) {
    return new OpsGenieConfigFluentImpl.RespondersNestedImpl(index, item);
  }
  public OpsGenieConfigFluent.RespondersNested<A> editResponder(Integer index) {
    if (responders.size() <= index) throw new RuntimeException("Can't edit responders. Index exceeds size.");
    return setNewResponderLike(index, buildResponder(index));
  }
  public OpsGenieConfigFluent.RespondersNested<A> editFirstResponder() {
    if (responders.size() == 0) throw new RuntimeException("Can't edit first responders. The list is empty.");
    return setNewResponderLike(0, buildResponder(0));
  }
  public OpsGenieConfigFluent.RespondersNested<A> editLastResponder() {
    int index = responders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last responders. The list is empty.");
    return setNewResponderLike(index, buildResponder(index));
  }
  public OpsGenieConfigFluent.RespondersNested<A> editMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<responders.size();i++) { 
    if (predicate.test(responders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching responders. No match found.");
    return setNewResponderLike(index, buildResponder(index));
  }
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved=sendResolved; return (A) this;
  }
  public Boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  public String getSource() {
    return this.source;
  }
  public A withSource(String source) {
    this.source=source; return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public String getTags() {
    return this.tags;
  }
  public A withTags(String tags) {
    this.tags=tags; return (A) this;
  }
  public Boolean hasTags() {
    return this.tags != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpsGenieConfigFluentImpl that = (OpsGenieConfigFluentImpl) o;
    if (apiKey != null ? !apiKey.equals(that.apiKey) :that.apiKey != null) return false;
    if (apiURL != null ? !apiURL.equals(that.apiURL) :that.apiURL != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (details != null ? !details.equals(that.details) :that.details != null) return false;
    if (httpConfig != null ? !httpConfig.equals(that.httpConfig) :that.httpConfig != null) return false;
    if (message != null ? !message.equals(that.message) :that.message != null) return false;
    if (note != null ? !note.equals(that.note) :that.note != null) return false;
    if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
    if (responders != null ? !responders.equals(that.responders) :that.responders != null) return false;
    if (sendResolved != null ? !sendResolved.equals(that.sendResolved) :that.sendResolved != null) return false;
    if (source != null ? !source.equals(that.source) :that.source != null) return false;
    if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiKey,  apiURL,  description,  details,  httpConfig,  message,  note,  priority,  responders,  sendResolved,  source,  tags,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiKey != null) { sb.append("apiKey:"); sb.append(apiKey + ","); }
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (details != null && !details.isEmpty()) { sb.append("details:"); sb.append(details + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (note != null) { sb.append("note:"); sb.append(note + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (responders != null && !responders.isEmpty()) { sb.append("responders:"); sb.append(responders + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (tags != null) { sb.append("tags:"); sb.append(tags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSendResolved() {
    return withSendResolved(true);
  }
  class DetailsNestedImpl<N> extends KeyValueFluentImpl<OpsGenieConfigFluent.DetailsNested<N>> implements OpsGenieConfigFluent.DetailsNested<N>,Nested<N>{
    DetailsNestedImpl(Integer index,KeyValue item) {
      this.index = index;
      this.builder = new KeyValueBuilder(this, item);
    }
    DetailsNestedImpl() {
      this.index = -1;
      this.builder = new KeyValueBuilder(this);
    }
    KeyValueBuilder builder;
    Integer index;
    public N and() {
      return (N) OpsGenieConfigFluentImpl.this.setToDetails(index,builder.build());
    }
    public N endDetail() {
      return and();
    }
    
  }
  class HttpConfigNestedImpl<N> extends HTTPConfigFluentImpl<OpsGenieConfigFluent.HttpConfigNested<N>> implements OpsGenieConfigFluent.HttpConfigNested<N>,Nested<N>{
    HttpConfigNestedImpl(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HttpConfigNestedImpl() {
      this.builder = new HTTPConfigBuilder(this);
    }
    HTTPConfigBuilder builder;
    public N and() {
      return (N) OpsGenieConfigFluentImpl.this.withHttpConfig(builder.build());
    }
    public N endHttpConfig() {
      return and();
    }
    
  }
  class RespondersNestedImpl<N> extends OpsGenieConfigResponderFluentImpl<OpsGenieConfigFluent.RespondersNested<N>> implements OpsGenieConfigFluent.RespondersNested<N>,Nested<N>{
    RespondersNestedImpl(Integer index,OpsGenieConfigResponder item) {
      this.index = index;
      this.builder = new OpsGenieConfigResponderBuilder(this, item);
    }
    RespondersNestedImpl() {
      this.index = -1;
      this.builder = new OpsGenieConfigResponderBuilder(this);
    }
    OpsGenieConfigResponderBuilder builder;
    Integer index;
    public N and() {
      return (N) OpsGenieConfigFluentImpl.this.setToResponders(index,builder.build());
    }
    public N endResponder() {
      return and();
    }
    
  }
  
}