package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KeyValueBuilder extends KeyValueFluentImpl<KeyValueBuilder> implements VisitableBuilder<KeyValue,KeyValueBuilder>{
  public KeyValueBuilder() {
    this(false);
  }
  public KeyValueBuilder(Boolean validationEnabled) {
    this(new KeyValue(), validationEnabled);
  }
  public KeyValueBuilder(KeyValueFluent<?> fluent) {
    this(fluent, false);
  }
  public KeyValueBuilder(KeyValueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KeyValue(), validationEnabled);
  }
  public KeyValueBuilder(KeyValueFluent<?> fluent,KeyValue instance) {
    this(fluent, instance, false);
  }
  public KeyValueBuilder(KeyValueFluent<?> fluent,KeyValue instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKey(instance.getKey()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KeyValueBuilder(KeyValue instance) {
    this(instance,false);
  }
  public KeyValueBuilder(KeyValue instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withKey(instance.getKey()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KeyValueFluent<?> fluent;
  Boolean validationEnabled;
  public KeyValue build() {
    KeyValue buildable = new KeyValue(fluent.getKey(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}