package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InhibitRuleBuilder extends InhibitRuleFluentImpl<InhibitRuleBuilder> implements VisitableBuilder<InhibitRule,InhibitRuleBuilder>{
  public InhibitRuleBuilder() {
    this(false);
  }
  public InhibitRuleBuilder(Boolean validationEnabled) {
    this(new InhibitRule(), validationEnabled);
  }
  public InhibitRuleBuilder(InhibitRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public InhibitRuleBuilder(InhibitRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InhibitRule(), validationEnabled);
  }
  public InhibitRuleBuilder(InhibitRuleFluent<?> fluent,InhibitRule instance) {
    this(fluent, instance, false);
  }
  public InhibitRuleBuilder(InhibitRuleFluent<?> fluent,InhibitRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEqual(instance.getEqual()); 
    fluent.withSourceMatch(instance.getSourceMatch()); 
    fluent.withTargetMatch(instance.getTargetMatch()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public InhibitRuleBuilder(InhibitRule instance) {
    this(instance,false);
  }
  public InhibitRuleBuilder(InhibitRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEqual(instance.getEqual()); 
    this.withSourceMatch(instance.getSourceMatch()); 
    this.withTargetMatch(instance.getTargetMatch()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  InhibitRuleFluent<?> fluent;
  Boolean validationEnabled;
  public InhibitRule build() {
    InhibitRule buildable = new InhibitRule(fluent.getEqual(),fluent.getSourceMatch(),fluent.getTargetMatch());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}