package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluentImpl;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EmailConfigFluentImpl<A extends EmailConfigFluent<A>> extends BaseFluent<A> implements EmailConfigFluent<A>{
  public EmailConfigFluentImpl() {
  }
  public EmailConfigFluentImpl(EmailConfig instance) {
    this.withAuthIdentity(instance.getAuthIdentity()); 
    this.withAuthPassword(instance.getAuthPassword()); 
    this.withAuthSecret(instance.getAuthSecret()); 
    this.withAuthUsername(instance.getAuthUsername()); 
    this.withFrom(instance.getFrom()); 
    this.withHeaders(instance.getHeaders()); 
    this.withHello(instance.getHello()); 
    this.withHtml(instance.getHtml()); 
    this.withRequireTLS(instance.getRequireTLS()); 
    this.withSendResolved(instance.getSendResolved()); 
    this.withSmarthost(instance.getSmarthost()); 
    this.withText(instance.getText()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withTo(instance.getTo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String authIdentity;
  private SecretKeySelector authPassword;
  private SecretKeySelector authSecret;
  private String authUsername;
  private String from;
  private ArrayList<KeyValueBuilder> headers = new ArrayList<KeyValueBuilder>();
  private String hello;
  private String html;
  private Boolean requireTLS;
  private Boolean sendResolved;
  private String smarthost;
  private String text;
  private SafeTLSConfigBuilder tlsConfig;
  private String to;
  private Map<String,Object> additionalProperties;
  public String getAuthIdentity() {
    return this.authIdentity;
  }
  public A withAuthIdentity(String authIdentity) {
    this.authIdentity=authIdentity; return (A) this;
  }
  public Boolean hasAuthIdentity() {
    return this.authIdentity != null;
  }
  public SecretKeySelector getAuthPassword() {
    return this.authPassword;
  }
  public A withAuthPassword(SecretKeySelector authPassword) {
    this.authPassword=authPassword; return (A) this;
  }
  public Boolean hasAuthPassword() {
    return this.authPassword != null;
  }
  public A withNewAuthPassword(String key,String name,Boolean optional) {
    return (A)withAuthPassword(new SecretKeySelector(key, name, optional));
  }
  public SecretKeySelector getAuthSecret() {
    return this.authSecret;
  }
  public A withAuthSecret(SecretKeySelector authSecret) {
    this.authSecret=authSecret; return (A) this;
  }
  public Boolean hasAuthSecret() {
    return this.authSecret != null;
  }
  public A withNewAuthSecret(String key,String name,Boolean optional) {
    return (A)withAuthSecret(new SecretKeySelector(key, name, optional));
  }
  public String getAuthUsername() {
    return this.authUsername;
  }
  public A withAuthUsername(String authUsername) {
    this.authUsername=authUsername; return (A) this;
  }
  public Boolean hasAuthUsername() {
    return this.authUsername != null;
  }
  public String getFrom() {
    return this.from;
  }
  public A withFrom(String from) {
    this.from=from; return (A) this;
  }
  public Boolean hasFrom() {
    return this.from != null;
  }
  public A addToHeaders(Integer index,KeyValue item) {
    if (this.headers == null) {this.headers = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("headers").add(index >= 0 ? index : _visitables.get("headers").size(), builder);this.headers.add(index >= 0 ? index : headers.size(), builder); return (A)this;
  }
  public A setToHeaders(Integer index,KeyValue item) {
    if (this.headers == null) {this.headers = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);
    if (index < 0 || index >= _visitables.get("headers").size()) { _visitables.get("headers").add(builder); } else { _visitables.get("headers").set(index, builder);}
    if (index < 0 || index >= headers.size()) { headers.add(builder); } else { headers.set(index, builder);}
     return (A)this;
  }
  public A addToHeaders(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    if (this.headers == null) {this.headers = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  public A addAllToHeaders(Collection<KeyValue> items) {
    if (this.headers == null) {this.headers = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  public A removeFromHeaders(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
  }
  public A removeAllFromHeaders(Collection<KeyValue> items) {
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHeaders(Predicate<KeyValueBuilder> predicate) {
    if (headers == null) return (A) this;
    final Iterator<KeyValueBuilder> each = headers.iterator();
    final List visitables = _visitables.get("headers");
    while (each.hasNext()) {
      KeyValueBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KeyValue> getHeaders() {
    return headers != null ? build(headers) : null;
  }
  public List<KeyValue> buildHeaders() {
    return headers != null ? build(headers) : null;
  }
  public KeyValue buildHeader(Integer index) {
    return this.headers.get(index).build();
  }
  public KeyValue buildFirstHeader() {
    return this.headers.get(0).build();
  }
  public KeyValue buildLastHeader() {
    return this.headers.get(headers.size() - 1).build();
  }
  public KeyValue buildMatchingHeader(Predicate<KeyValueBuilder> predicate) {
    for (KeyValueBuilder item: headers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHeader(Predicate<KeyValueBuilder> predicate) {
    for (KeyValueBuilder item: headers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHeaders(List<KeyValue> headers) {
    if (this.headers != null) { _visitables.get("headers").removeAll(this.headers);}
    if (headers != null) {this.headers = new ArrayList(); for (KeyValue item : headers){this.addToHeaders(item);}} else { this.headers = null;} return (A) this;
  }
  public A withHeaders(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... headers) {
    if (this.headers != null) {this.headers.clear();}
    if (headers != null) {for (KeyValue item :headers){ this.addToHeaders(item);}} return (A) this;
  }
  public Boolean hasHeaders() {
    return headers != null && !headers.isEmpty();
  }
  public A addNewHeader(String key,String value) {
    return (A)addToHeaders(new KeyValue(key, value));
  }
  public EmailConfigFluent.HeadersNested<A> addNewHeader() {
    return new EmailConfigFluentImpl.HeadersNestedImpl();
  }
  public EmailConfigFluent.HeadersNested<A> addNewHeaderLike(KeyValue item) {
    return new EmailConfigFluentImpl.HeadersNestedImpl(-1, item);
  }
  public EmailConfigFluent.HeadersNested<A> setNewHeaderLike(Integer index,KeyValue item) {
    return new EmailConfigFluentImpl.HeadersNestedImpl(index, item);
  }
  public EmailConfigFluent.HeadersNested<A> editHeader(Integer index) {
    if (headers.size() <= index) throw new RuntimeException("Can't edit headers. Index exceeds size.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public EmailConfigFluent.HeadersNested<A> editFirstHeader() {
    if (headers.size() == 0) throw new RuntimeException("Can't edit first headers. The list is empty.");
    return setNewHeaderLike(0, buildHeader(0));
  }
  public EmailConfigFluent.HeadersNested<A> editLastHeader() {
    int index = headers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last headers. The list is empty.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public EmailConfigFluent.HeadersNested<A> editMatchingHeader(Predicate<KeyValueBuilder> predicate) {
    int index = -1;
    for (int i=0;i<headers.size();i++) { 
    if (predicate.test(headers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching headers. No match found.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public String getHello() {
    return this.hello;
  }
  public A withHello(String hello) {
    this.hello=hello; return (A) this;
  }
  public Boolean hasHello() {
    return this.hello != null;
  }
  public String getHtml() {
    return this.html;
  }
  public A withHtml(String html) {
    this.html=html; return (A) this;
  }
  public Boolean hasHtml() {
    return this.html != null;
  }
  public Boolean getRequireTLS() {
    return this.requireTLS;
  }
  public A withRequireTLS(Boolean requireTLS) {
    this.requireTLS=requireTLS; return (A) this;
  }
  public Boolean hasRequireTLS() {
    return this.requireTLS != null;
  }
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved=sendResolved; return (A) this;
  }
  public Boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  public String getSmarthost() {
    return this.smarthost;
  }
  public A withSmarthost(String smarthost) {
    this.smarthost=smarthost; return (A) this;
  }
  public Boolean hasSmarthost() {
    return this.smarthost != null;
  }
  public String getText() {
    return this.text;
  }
  public A withText(String text) {
    this.text=text; return (A) this;
  }
  public Boolean hasText() {
    return this.text != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public SafeTLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public SafeTLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(SafeTLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new SafeTLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} else { this.tlsConfig = null; _visitables.get("tlsConfig").remove(this.tlsConfig); } return (A) this;
  }
  public Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public EmailConfigFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new EmailConfigFluentImpl.TlsConfigNestedImpl();
  }
  public EmailConfigFluent.TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
    return new EmailConfigFluentImpl.TlsConfigNestedImpl(item);
  }
  public EmailConfigFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public EmailConfigFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new SafeTLSConfigBuilder().build());
  }
  public EmailConfigFluent.TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public String getTo() {
    return this.to;
  }
  public A withTo(String to) {
    this.to=to; return (A) this;
  }
  public Boolean hasTo() {
    return this.to != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EmailConfigFluentImpl that = (EmailConfigFluentImpl) o;
    if (authIdentity != null ? !authIdentity.equals(that.authIdentity) :that.authIdentity != null) return false;
    if (authPassword != null ? !authPassword.equals(that.authPassword) :that.authPassword != null) return false;
    if (authSecret != null ? !authSecret.equals(that.authSecret) :that.authSecret != null) return false;
    if (authUsername != null ? !authUsername.equals(that.authUsername) :that.authUsername != null) return false;
    if (from != null ? !from.equals(that.from) :that.from != null) return false;
    if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
    if (hello != null ? !hello.equals(that.hello) :that.hello != null) return false;
    if (html != null ? !html.equals(that.html) :that.html != null) return false;
    if (requireTLS != null ? !requireTLS.equals(that.requireTLS) :that.requireTLS != null) return false;
    if (sendResolved != null ? !sendResolved.equals(that.sendResolved) :that.sendResolved != null) return false;
    if (smarthost != null ? !smarthost.equals(that.smarthost) :that.smarthost != null) return false;
    if (text != null ? !text.equals(that.text) :that.text != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (to != null ? !to.equals(that.to) :that.to != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authIdentity,  authPassword,  authSecret,  authUsername,  from,  headers,  hello,  html,  requireTLS,  sendResolved,  smarthost,  text,  tlsConfig,  to,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authIdentity != null) { sb.append("authIdentity:"); sb.append(authIdentity + ","); }
    if (authPassword != null) { sb.append("authPassword:"); sb.append(authPassword + ","); }
    if (authSecret != null) { sb.append("authSecret:"); sb.append(authSecret + ","); }
    if (authUsername != null) { sb.append("authUsername:"); sb.append(authUsername + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (hello != null) { sb.append("hello:"); sb.append(hello + ","); }
    if (html != null) { sb.append("html:"); sb.append(html + ","); }
    if (requireTLS != null) { sb.append("requireTLS:"); sb.append(requireTLS + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (smarthost != null) { sb.append("smarthost:"); sb.append(smarthost + ","); }
    if (text != null) { sb.append("text:"); sb.append(text + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (to != null) { sb.append("to:"); sb.append(to + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withRequireTLS() {
    return withRequireTLS(true);
  }
  public A withSendResolved() {
    return withSendResolved(true);
  }
  class HeadersNestedImpl<N> extends KeyValueFluentImpl<EmailConfigFluent.HeadersNested<N>> implements EmailConfigFluent.HeadersNested<N>,Nested<N>{
    HeadersNestedImpl(Integer index,KeyValue item) {
      this.index = index;
      this.builder = new KeyValueBuilder(this, item);
    }
    HeadersNestedImpl() {
      this.index = -1;
      this.builder = new KeyValueBuilder(this);
    }
    KeyValueBuilder builder;
    Integer index;
    public N and() {
      return (N) EmailConfigFluentImpl.this.setToHeaders(index,builder.build());
    }
    public N endHeader() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends SafeTLSConfigFluentImpl<EmailConfigFluent.TlsConfigNested<N>> implements EmailConfigFluent.TlsConfigNested<N>,Nested<N>{
    TlsConfigNestedImpl(SafeTLSConfig item) {
      this.builder = new SafeTLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new SafeTLSConfigBuilder(this);
    }
    SafeTLSConfigBuilder builder;
    public N and() {
      return (N) EmailConfigFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}