package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceMonitorBuilder extends ServiceMonitorFluentImpl<ServiceMonitorBuilder> implements VisitableBuilder<ServiceMonitor,ServiceMonitorBuilder>{
  public ServiceMonitorBuilder() {
    this(false);
  }
  public ServiceMonitorBuilder(Boolean validationEnabled) {
    this(new ServiceMonitor(), validationEnabled);
  }
  public ServiceMonitorBuilder(ServiceMonitorFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceMonitorBuilder(ServiceMonitorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceMonitor(), validationEnabled);
  }
  public ServiceMonitorBuilder(ServiceMonitorFluent<?> fluent,ServiceMonitor instance) {
    this(fluent, instance, false);
  }
  public ServiceMonitorBuilder(ServiceMonitorFluent<?> fluent,ServiceMonitor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceMonitorBuilder(ServiceMonitor instance) {
    this(instance,false);
  }
  public ServiceMonitorBuilder(ServiceMonitor instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceMonitorFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceMonitor build() {
    ServiceMonitor buildable = new ServiceMonitor(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}