package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetadataConfigBuilder extends MetadataConfigFluentImpl<MetadataConfigBuilder> implements VisitableBuilder<MetadataConfig,MetadataConfigBuilder>{
  public MetadataConfigBuilder() {
    this(false);
  }
  public MetadataConfigBuilder(Boolean validationEnabled) {
    this(new MetadataConfig(), validationEnabled);
  }
  public MetadataConfigBuilder(MetadataConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public MetadataConfigBuilder(MetadataConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MetadataConfig(), validationEnabled);
  }
  public MetadataConfigBuilder(MetadataConfigFluent<?> fluent,MetadataConfig instance) {
    this(fluent, instance, false);
  }
  public MetadataConfigBuilder(MetadataConfigFluent<?> fluent,MetadataConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSend(instance.getSend()); 
    fluent.withSendInterval(instance.getSendInterval()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MetadataConfigBuilder(MetadataConfig instance) {
    this(instance,false);
  }
  public MetadataConfigBuilder(MetadataConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSend(instance.getSend()); 
    this.withSendInterval(instance.getSendInterval()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MetadataConfigFluent<?> fluent;
  Boolean validationEnabled;
  public MetadataConfig build() {
    MetadataConfig buildable = new MetadataConfig(fluent.getSend(),fluent.getSendInterval());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}