package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointFluentImpl<A extends EndpointFluent<A>> extends BaseFluent<A> implements EndpointFluent<A>{
  public EndpointFluentImpl() {
  }
  public EndpointFluentImpl(Endpoint instance) {
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withHonorLabels(instance.getHonorLabels()); 
    this.withHonorTimestamps(instance.getHonorTimestamps()); 
    this.withInterval(instance.getInterval()); 
    this.withMetricRelabelings(instance.getMetricRelabelings()); 
    this.withOauth2(instance.getOauth2()); 
    this.withParams(instance.getParams()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withRelabelings(instance.getRelabelings()); 
    this.withScheme(instance.getScheme()); 
    this.withScrapeTimeout(instance.getScrapeTimeout()); 
    this.withTargetPort(instance.getTargetPort()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SafeAuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private String bearerTokenFile;
  private SecretKeySelector bearerTokenSecret;
  private Boolean honorLabels;
  private Boolean honorTimestamps;
  private String interval;
  private ArrayList<RelabelConfigBuilder> metricRelabelings = new ArrayList<RelabelConfigBuilder>();
  private OAuth2Builder oauth2;
  private Map<String,ArrayList<String>> params;
  private String path;
  private String port;
  private String proxyUrl;
  private ArrayList<RelabelConfigBuilder> relabelings = new ArrayList<RelabelConfigBuilder>();
  private String scheme;
  private String scrapeTimeout;
  private IntOrStringBuilder targetPort;
  private TLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public SafeAuthorization getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public SafeAuthorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(SafeAuthorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new SafeAuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} else { this.authorization = null; _visitables.get("authorization").remove(this.authorization); } return (A) this;
  }
  public Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public EndpointFluent.AuthorizationNested<A> withNewAuthorization() {
    return new EndpointFluentImpl.AuthorizationNestedImpl();
  }
  public EndpointFluent.AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
    return new EndpointFluentImpl.AuthorizationNestedImpl(item);
  }
  public EndpointFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public EndpointFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new SafeAuthorizationBuilder().build());
  }
  public EndpointFluent.AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @Deprecated
  public BasicAuth getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public BasicAuth buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} else { this.basicAuth = null; _visitables.get("basicAuth").remove(this.basicAuth); } return (A) this;
  }
  public Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public EndpointFluent.BasicAuthNested<A> withNewBasicAuth() {
    return new EndpointFluentImpl.BasicAuthNestedImpl();
  }
  public EndpointFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new EndpointFluentImpl.BasicAuthNestedImpl(item);
  }
  public EndpointFluent.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public EndpointFluent.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthBuilder().build());
  }
  public EndpointFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  public String getBearerTokenFile() {
    return this.bearerTokenFile;
  }
  public A withBearerTokenFile(String bearerTokenFile) {
    this.bearerTokenFile=bearerTokenFile; return (A) this;
  }
  public Boolean hasBearerTokenFile() {
    return this.bearerTokenFile != null;
  }
  public SecretKeySelector getBearerTokenSecret() {
    return this.bearerTokenSecret;
  }
  public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret) {
    this.bearerTokenSecret=bearerTokenSecret; return (A) this;
  }
  public Boolean hasBearerTokenSecret() {
    return this.bearerTokenSecret != null;
  }
  public A withNewBearerTokenSecret(String key,String name,Boolean optional) {
    return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
  }
  public Boolean getHonorLabels() {
    return this.honorLabels;
  }
  public A withHonorLabels(Boolean honorLabels) {
    this.honorLabels=honorLabels; return (A) this;
  }
  public Boolean hasHonorLabels() {
    return this.honorLabels != null;
  }
  public Boolean getHonorTimestamps() {
    return this.honorTimestamps;
  }
  public A withHonorTimestamps(Boolean honorTimestamps) {
    this.honorTimestamps=honorTimestamps; return (A) this;
  }
  public Boolean hasHonorTimestamps() {
    return this.honorTimestamps != null;
  }
  public String getInterval() {
    return this.interval;
  }
  public A withInterval(String interval) {
    this.interval=interval; return (A) this;
  }
  public Boolean hasInterval() {
    return this.interval != null;
  }
  public A addToMetricRelabelings(Integer index,RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(index >= 0 ? index : _visitables.get("metricRelabelings").size(), builder);this.metricRelabelings.add(index >= 0 ? index : metricRelabelings.size(), builder); return (A)this;
  }
  public A setToMetricRelabelings(Integer index,RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("metricRelabelings").size()) { _visitables.get("metricRelabelings").add(builder); } else { _visitables.get("metricRelabelings").set(index, builder);}
    if (index < 0 || index >= metricRelabelings.size()) { metricRelabelings.add(builder); } else { metricRelabelings.set(index, builder);}
     return (A)this;
  }
  public A addToMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A addAllToMetricRelabelings(Collection<RelabelConfig> items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A removeFromMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
  }
  public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMetricRelabelings(Predicate<RelabelConfigBuilder> predicate) {
    if (metricRelabelings == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = metricRelabelings.iterator();
    final List visitables = _visitables.get("metricRelabelings");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMetricRelabelings instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RelabelConfig> getMetricRelabelings() {
    return metricRelabelings != null ? build(metricRelabelings) : null;
  }
  public List<RelabelConfig> buildMetricRelabelings() {
    return metricRelabelings != null ? build(metricRelabelings) : null;
  }
  public RelabelConfig buildMetricRelabeling(Integer index) {
    return this.metricRelabelings.get(index).build();
  }
  public RelabelConfig buildFirstMetricRelabeling() {
    return this.metricRelabelings.get(0).build();
  }
  public RelabelConfig buildLastMetricRelabeling() {
    return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
  }
  public RelabelConfig buildMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMetricRelabelings(List<RelabelConfig> metricRelabelings) {
    if (this.metricRelabelings != null) { _visitables.get("metricRelabelings").removeAll(this.metricRelabelings);}
    if (metricRelabelings != null) {this.metricRelabelings = new ArrayList(); for (RelabelConfig item : metricRelabelings){this.addToMetricRelabelings(item);}} else { this.metricRelabelings = null;} return (A) this;
  }
  public A withMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... metricRelabelings) {
    if (this.metricRelabelings != null) {this.metricRelabelings.clear();}
    if (metricRelabelings != null) {for (RelabelConfig item :metricRelabelings){ this.addToMetricRelabelings(item);}} return (A) this;
  }
  public Boolean hasMetricRelabelings() {
    return metricRelabelings != null && !metricRelabelings.isEmpty();
  }
  public EndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabeling() {
    return new EndpointFluentImpl.MetricRelabelingsNestedImpl();
  }
  public EndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item) {
    return new EndpointFluentImpl.MetricRelabelingsNestedImpl(-1, item);
  }
  public EndpointFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(Integer index,RelabelConfig item) {
    return new EndpointFluentImpl.MetricRelabelingsNestedImpl(index, item);
  }
  public EndpointFluent.MetricRelabelingsNested<A> editMetricRelabeling(Integer index) {
    if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public EndpointFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling() {
    if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
  }
  public EndpointFluent.MetricRelabelingsNested<A> editLastMetricRelabeling() {
    int index = metricRelabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public EndpointFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<metricRelabelings.size();i++) { 
    if (predicate.test(metricRelabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  
  /**
   * This method has been deprecated, please use method buildOauth2 instead.
   * @return The buildable object.
   */
  @Deprecated
  public OAuth2 getOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public OAuth2 buildOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public A withOauth2(OAuth2 oauth2) {
    _visitables.get("oauth2").remove(this.oauth2);
    if (oauth2!=null){ this.oauth2= new OAuth2Builder(oauth2); _visitables.get("oauth2").add(this.oauth2);} else { this.oauth2 = null; _visitables.get("oauth2").remove(this.oauth2); } return (A) this;
  }
  public Boolean hasOauth2() {
    return this.oauth2 != null;
  }
  public EndpointFluent.Oauth2Nested<A> withNewOauth2() {
    return new EndpointFluentImpl.Oauth2NestedImpl();
  }
  public EndpointFluent.Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
    return new EndpointFluentImpl.Oauth2NestedImpl(item);
  }
  public EndpointFluent.Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(getOauth2());
  }
  public EndpointFluent.Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): new OAuth2Builder().build());
  }
  public EndpointFluent.Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): item);
  }
  public A addToParams(String key,ArrayList<String> value) {
    if(this.params == null && key != null && value != null) { this.params = new LinkedHashMap(); }
    if(key != null && value != null) {this.params.put(key, value);} return (A)this;
  }
  public A addToParams(Map<String,ArrayList<String>> map) {
    if(this.params == null && map != null) { this.params = new LinkedHashMap(); }
    if(map != null) { this.params.putAll(map);} return (A)this;
  }
  public A removeFromParams(String key) {
    if(this.params == null) { return (A) this; }
    if(key != null && this.params != null) {this.params.remove(key);} return (A)this;
  }
  public A removeFromParams(Map<String,ArrayList<String>> map) {
    if(this.params == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.params != null){this.params.remove(key);}}} return (A)this;
  }
  public Map<String,ArrayList<String>> getParams() {
    return this.params;
  }
  public <K,V>A withParams(Map<String,ArrayList<String>> params) {
    if (params == null) { this.params =  null;} else {this.params = new LinkedHashMap(params);} return (A) this;
  }
  public Boolean hasParams() {
    return this.params != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public String getPort() {
    return this.port;
  }
  public A withPort(String port) {
    this.port=port; return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl=proxyUrl; return (A) this;
  }
  public Boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  public A addToRelabelings(Integer index,RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(index >= 0 ? index : _visitables.get("relabelings").size(), builder);this.relabelings.add(index >= 0 ? index : relabelings.size(), builder); return (A)this;
  }
  public A setToRelabelings(Integer index,RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("relabelings").size()) { _visitables.get("relabelings").add(builder); } else { _visitables.get("relabelings").set(index, builder);}
    if (index < 0 || index >= relabelings.size()) { relabelings.add(builder); } else { relabelings.set(index, builder);}
     return (A)this;
  }
  public A addToRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  public A addAllToRelabelings(Collection<RelabelConfig> items) {
    if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  public A removeFromRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelabelings(Collection<RelabelConfig> items) {
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelabelings(Predicate<RelabelConfigBuilder> predicate) {
    if (relabelings == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = relabelings.iterator();
    final List visitables = _visitables.get("relabelings");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelabelings instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RelabelConfig> getRelabelings() {
    return relabelings != null ? build(relabelings) : null;
  }
  public List<RelabelConfig> buildRelabelings() {
    return relabelings != null ? build(relabelings) : null;
  }
  public RelabelConfig buildRelabeling(Integer index) {
    return this.relabelings.get(index).build();
  }
  public RelabelConfig buildFirstRelabeling() {
    return this.relabelings.get(0).build();
  }
  public RelabelConfig buildLastRelabeling() {
    return this.relabelings.get(relabelings.size() - 1).build();
  }
  public RelabelConfig buildMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    for (RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelabelings(List<RelabelConfig> relabelings) {
    if (this.relabelings != null) { _visitables.get("relabelings").removeAll(this.relabelings);}
    if (relabelings != null) {this.relabelings = new ArrayList(); for (RelabelConfig item : relabelings){this.addToRelabelings(item);}} else { this.relabelings = null;} return (A) this;
  }
  public A withRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelings) {
    if (this.relabelings != null) {this.relabelings.clear();}
    if (relabelings != null) {for (RelabelConfig item :relabelings){ this.addToRelabelings(item);}} return (A) this;
  }
  public Boolean hasRelabelings() {
    return relabelings != null && !relabelings.isEmpty();
  }
  public EndpointFluent.RelabelingsNested<A> addNewRelabeling() {
    return new EndpointFluentImpl.RelabelingsNestedImpl();
  }
  public EndpointFluent.RelabelingsNested<A> addNewRelabelingLike(RelabelConfig item) {
    return new EndpointFluentImpl.RelabelingsNestedImpl(-1, item);
  }
  public EndpointFluent.RelabelingsNested<A> setNewRelabelingLike(Integer index,RelabelConfig item) {
    return new EndpointFluentImpl.RelabelingsNestedImpl(index, item);
  }
  public EndpointFluent.RelabelingsNested<A> editRelabeling(Integer index) {
    if (relabelings.size() <= index) throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public EndpointFluent.RelabelingsNested<A> editFirstRelabeling() {
    if (relabelings.size() == 0) throw new RuntimeException("Can't edit first relabelings. The list is empty.");
    return setNewRelabelingLike(0, buildRelabeling(0));
  }
  public EndpointFluent.RelabelingsNested<A> editLastRelabeling() {
    int index = relabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relabelings. The list is empty.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public EndpointFluent.RelabelingsNested<A> editMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relabelings.size();i++) { 
    if (predicate.test(relabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relabelings. No match found.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public String getScheme() {
    return this.scheme;
  }
  public A withScheme(String scheme) {
    this.scheme=scheme; return (A) this;
  }
  public Boolean hasScheme() {
    return this.scheme != null;
  }
  public String getScrapeTimeout() {
    return this.scrapeTimeout;
  }
  public A withScrapeTimeout(String scrapeTimeout) {
    this.scrapeTimeout=scrapeTimeout; return (A) this;
  }
  public Boolean hasScrapeTimeout() {
    return this.scrapeTimeout != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTargetPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getTargetPort() {
    return this.targetPort!=null ?this.targetPort.build():null;
  }
  public IntOrString buildTargetPort() {
    return this.targetPort!=null ?this.targetPort.build():null;
  }
  public A withTargetPort(IntOrString targetPort) {
    _visitables.get("targetPort").remove(this.targetPort);
    if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} else { this.targetPort = null; _visitables.get("targetPort").remove(this.targetPort); } return (A) this;
  }
  public Boolean hasTargetPort() {
    return this.targetPort != null;
  }
  public A withNewTargetPort(Object value) {
    return (A)withTargetPort(new IntOrString(value));
  }
  public EndpointFluent.TargetPortNested<A> withNewTargetPort() {
    return new EndpointFluentImpl.TargetPortNestedImpl();
  }
  public EndpointFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
    return new EndpointFluentImpl.TargetPortNestedImpl(item);
  }
  public EndpointFluent.TargetPortNested<A> editTargetPort() {
    return withNewTargetPortLike(getTargetPort());
  }
  public EndpointFluent.TargetPortNested<A> editOrNewTargetPort() {
    return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new IntOrStringBuilder().build());
  }
  public EndpointFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
    return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public TLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(TLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} else { this.tlsConfig = null; _visitables.get("tlsConfig").remove(this.tlsConfig); } return (A) this;
  }
  public Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public EndpointFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new EndpointFluentImpl.TlsConfigNestedImpl();
  }
  public EndpointFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
    return new EndpointFluentImpl.TlsConfigNestedImpl(item);
  }
  public EndpointFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public EndpointFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
  }
  public EndpointFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointFluentImpl that = (EndpointFluentImpl) o;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
    if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
    if (bearerTokenSecret != null ? !bearerTokenSecret.equals(that.bearerTokenSecret) :that.bearerTokenSecret != null) return false;
    if (honorLabels != null ? !honorLabels.equals(that.honorLabels) :that.honorLabels != null) return false;
    if (honorTimestamps != null ? !honorTimestamps.equals(that.honorTimestamps) :that.honorTimestamps != null) return false;
    if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
    if (metricRelabelings != null ? !metricRelabelings.equals(that.metricRelabelings) :that.metricRelabelings != null) return false;
    if (oauth2 != null ? !oauth2.equals(that.oauth2) :that.oauth2 != null) return false;
    if (params != null ? !params.equals(that.params) :that.params != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
    if (relabelings != null ? !relabelings.equals(that.relabelings) :that.relabelings != null) return false;
    if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
    if (scrapeTimeout != null ? !scrapeTimeout.equals(that.scrapeTimeout) :that.scrapeTimeout != null) return false;
    if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerTokenFile,  bearerTokenSecret,  honorLabels,  honorTimestamps,  interval,  metricRelabelings,  oauth2,  params,  path,  port,  proxyUrl,  relabelings,  scheme,  scrapeTimeout,  targetPort,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerTokenFile != null) { sb.append("bearerTokenFile:"); sb.append(bearerTokenFile + ","); }
    if (bearerTokenSecret != null) { sb.append("bearerTokenSecret:"); sb.append(bearerTokenSecret + ","); }
    if (honorLabels != null) { sb.append("honorLabels:"); sb.append(honorLabels + ","); }
    if (honorTimestamps != null) { sb.append("honorTimestamps:"); sb.append(honorTimestamps + ","); }
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    if (metricRelabelings != null && !metricRelabelings.isEmpty()) { sb.append("metricRelabelings:"); sb.append(metricRelabelings + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (params != null && !params.isEmpty()) { sb.append("params:"); sb.append(params + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (relabelings != null && !relabelings.isEmpty()) { sb.append("relabelings:"); sb.append(relabelings + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (scrapeTimeout != null) { sb.append("scrapeTimeout:"); sb.append(scrapeTimeout + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withHonorLabels() {
    return withHonorLabels(true);
  }
  public A withHonorTimestamps() {
    return withHonorTimestamps(true);
  }
  class AuthorizationNestedImpl<N> extends SafeAuthorizationFluentImpl<EndpointFluent.AuthorizationNested<N>> implements EndpointFluent.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(SafeAuthorization item) {
      this.builder = new SafeAuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new SafeAuthorizationBuilder(this);
    }
    SafeAuthorizationBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<EndpointFluent.BasicAuthNested<N>> implements EndpointFluent.BasicAuthNested<N>,Nested<N>{
    BasicAuthNestedImpl(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new BasicAuthBuilder(this);
    }
    BasicAuthBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class MetricRelabelingsNestedImpl<N> extends RelabelConfigFluentImpl<EndpointFluent.MetricRelabelingsNested<N>> implements EndpointFluent.MetricRelabelingsNested<N>,Nested<N>{
    MetricRelabelingsNestedImpl(Integer index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    MetricRelabelingsNestedImpl() {
      this.index = -1;
      this.builder = new RelabelConfigBuilder(this);
    }
    RelabelConfigBuilder builder;
    Integer index;
    public N and() {
      return (N) EndpointFluentImpl.this.setToMetricRelabelings(index,builder.build());
    }
    public N endMetricRelabeling() {
      return and();
    }
    
  }
  class Oauth2NestedImpl<N> extends OAuth2FluentImpl<EndpointFluent.Oauth2Nested<N>> implements EndpointFluent.Oauth2Nested<N>,Nested<N>{
    Oauth2NestedImpl(OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    Oauth2NestedImpl() {
      this.builder = new OAuth2Builder(this);
    }
    OAuth2Builder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withOauth2(builder.build());
    }
    public N endOauth2() {
      return and();
    }
    
  }
  class RelabelingsNestedImpl<N> extends RelabelConfigFluentImpl<EndpointFluent.RelabelingsNested<N>> implements EndpointFluent.RelabelingsNested<N>,Nested<N>{
    RelabelingsNestedImpl(Integer index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelingsNestedImpl() {
      this.index = -1;
      this.builder = new RelabelConfigBuilder(this);
    }
    RelabelConfigBuilder builder;
    Integer index;
    public N and() {
      return (N) EndpointFluentImpl.this.setToRelabelings(index,builder.build());
    }
    public N endRelabeling() {
      return and();
    }
    
  }
  class TargetPortNestedImpl<N> extends IntOrStringFluentImpl<EndpointFluent.TargetPortNested<N>> implements EndpointFluent.TargetPortNested<N>,Nested<N>{
    TargetPortNestedImpl(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    TargetPortNestedImpl() {
      this.builder = new IntOrStringBuilder(this);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withTargetPort(builder.build());
    }
    public N endTargetPort() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<EndpointFluent.TlsConfigNested<N>> implements EndpointFluent.TlsConfigNested<N>,Nested<N>{
    TlsConfigNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) EndpointFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}