package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EmbeddedPersistentVolumeClaimBuilder extends EmbeddedPersistentVolumeClaimFluentImpl<EmbeddedPersistentVolumeClaimBuilder> implements VisitableBuilder<EmbeddedPersistentVolumeClaim,EmbeddedPersistentVolumeClaimBuilder>{
  public EmbeddedPersistentVolumeClaimBuilder() {
    this(false);
  }
  public EmbeddedPersistentVolumeClaimBuilder(Boolean validationEnabled) {
    this(new EmbeddedPersistentVolumeClaim(), validationEnabled);
  }
  public EmbeddedPersistentVolumeClaimBuilder(EmbeddedPersistentVolumeClaimFluent<?> fluent) {
    this(fluent, false);
  }
  public EmbeddedPersistentVolumeClaimBuilder(EmbeddedPersistentVolumeClaimFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EmbeddedPersistentVolumeClaim(), validationEnabled);
  }
  public EmbeddedPersistentVolumeClaimBuilder(EmbeddedPersistentVolumeClaimFluent<?> fluent,EmbeddedPersistentVolumeClaim instance) {
    this(fluent, instance, false);
  }
  public EmbeddedPersistentVolumeClaimBuilder(EmbeddedPersistentVolumeClaimFluent<?> fluent,EmbeddedPersistentVolumeClaim instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EmbeddedPersistentVolumeClaimBuilder(EmbeddedPersistentVolumeClaim instance) {
    this(instance,false);
  }
  public EmbeddedPersistentVolumeClaimBuilder(EmbeddedPersistentVolumeClaim instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  EmbeddedPersistentVolumeClaimFluent<?> fluent;
  Boolean validationEnabled;
  public EmbeddedPersistentVolumeClaim build() {
    EmbeddedPersistentVolumeClaim buildable = new EmbeddedPersistentVolumeClaim(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}