package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AlertmanagerSpecFluentImpl<A extends AlertmanagerSpecFluent<A>> extends BaseFluent<A> implements AlertmanagerSpecFluent<A>{
  public AlertmanagerSpecFluentImpl() {
  }
  public AlertmanagerSpecFluentImpl(AlertmanagerSpec instance) {
    this.withAdditionalPeers(instance.getAdditionalPeers()); 
    this.withAffinity(instance.getAffinity()); 
    this.withAlertmanagerConfigNamespaceSelector(instance.getAlertmanagerConfigNamespaceSelector()); 
    this.withAlertmanagerConfigSelector(instance.getAlertmanagerConfigSelector()); 
    this.withBaseImage(instance.getBaseImage()); 
    this.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress()); 
    this.withClusterGossipInterval(instance.getClusterGossipInterval()); 
    this.withClusterPeerTimeout(instance.getClusterPeerTimeout()); 
    this.withClusterPushpullInterval(instance.getClusterPushpullInterval()); 
    this.withConfigMaps(instance.getConfigMaps()); 
    this.withConfigSecret(instance.getConfigSecret()); 
    this.withContainers(instance.getContainers()); 
    this.withExternalUrl(instance.getExternalUrl()); 
    this.withForceEnableClusterMode(instance.getForceEnableClusterMode()); 
    this.withImage(instance.getImage()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withListenLocal(instance.getListenLocal()); 
    this.withLogFormat(instance.getLogFormat()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withPaused(instance.getPaused()); 
    this.withPodMetadata(instance.getPodMetadata()); 
    this.withPortName(instance.getPortName()); 
    this.withPriorityClassName(instance.getPriorityClassName()); 
    this.withReplicas(instance.getReplicas()); 
    this.withResources(instance.getResources()); 
    this.withRetention(instance.getRetention()); 
    this.withRoutePrefix(instance.getRoutePrefix()); 
    this.withSecrets(instance.getSecrets()); 
    this.withSecurityContext(instance.getSecurityContext()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withSha(instance.getSha()); 
    this.withStorage(instance.getStorage()); 
    this.withTag(instance.getTag()); 
    this.withTolerations(instance.getTolerations()); 
    this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
    this.withVersion(instance.getVersion()); 
    this.withVolumeMounts(instance.getVolumeMounts()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> additionalPeers = new ArrayList<String>();
  private Affinity affinity;
  private LabelSelectorBuilder alertmanagerConfigNamespaceSelector;
  private LabelSelectorBuilder alertmanagerConfigSelector;
  private String baseImage;
  private String clusterAdvertiseAddress;
  private String clusterGossipInterval;
  private String clusterPeerTimeout;
  private String clusterPushpullInterval;
  private List<String> configMaps = new ArrayList<String>();
  private String configSecret;
  private ArrayList<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();
  private String externalUrl;
  private Boolean forceEnableClusterMode;
  private String image;
  private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
  private ArrayList<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
  private Boolean listenLocal;
  private String logFormat;
  private String logLevel;
  private Integer minReadySeconds;
  private Map<String,String> nodeSelector;
  private Boolean paused;
  private EmbeddedObjectMetadataBuilder podMetadata;
  private String portName;
  private String priorityClassName;
  private Integer replicas;
  private ResourceRequirementsBuilder resources;
  private String retention;
  private String routePrefix;
  private List<String> secrets = new ArrayList<String>();
  private PodSecurityContext securityContext;
  private String serviceAccountName;
  private String sha;
  private StorageSpecBuilder storage;
  private String tag;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
  private String version;
  private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
  private List<Volume> volumes = new ArrayList<Volume>();
  private Map<String,Object> additionalProperties;
  public A addToAdditionalPeers(Integer index,String item) {
    if (this.additionalPeers == null) {this.additionalPeers = new ArrayList<String>();}
    this.additionalPeers.add(index, item);
    return (A)this;
  }
  public A setToAdditionalPeers(Integer index,String item) {
    if (this.additionalPeers == null) {this.additionalPeers = new ArrayList<String>();}
    this.additionalPeers.set(index, item); return (A)this;
  }
  public A addToAdditionalPeers(java.lang.String... items) {
    if (this.additionalPeers == null) {this.additionalPeers = new ArrayList<String>();}
    for (String item : items) {this.additionalPeers.add(item);} return (A)this;
  }
  public A addAllToAdditionalPeers(Collection<String> items) {
    if (this.additionalPeers == null) {this.additionalPeers = new ArrayList<String>();}
    for (String item : items) {this.additionalPeers.add(item);} return (A)this;
  }
  public A removeFromAdditionalPeers(java.lang.String... items) {
    for (String item : items) {if (this.additionalPeers!= null){ this.additionalPeers.remove(item);}} return (A)this;
  }
  public A removeAllFromAdditionalPeers(Collection<String> items) {
    for (String item : items) {if (this.additionalPeers!= null){ this.additionalPeers.remove(item);}} return (A)this;
  }
  public List<String> getAdditionalPeers() {
    return this.additionalPeers;
  }
  public String getAdditionalPeer(Integer index) {
    return this.additionalPeers.get(index);
  }
  public String getFirstAdditionalPeer() {
    return this.additionalPeers.get(0);
  }
  public String getLastAdditionalPeer() {
    return this.additionalPeers.get(additionalPeers.size() - 1);
  }
  public String getMatchingAdditionalPeer(Predicate<String> predicate) {
    for (String item: additionalPeers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAdditionalPeer(Predicate<String> predicate) {
    for (String item: additionalPeers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalPeers(List<String> additionalPeers) {
    if (additionalPeers != null) {this.additionalPeers = new ArrayList(); for (String item : additionalPeers){this.addToAdditionalPeers(item);}} else { this.additionalPeers = null;} return (A) this;
  }
  public A withAdditionalPeers(java.lang.String... additionalPeers) {
    if (this.additionalPeers != null) {this.additionalPeers.clear();}
    if (additionalPeers != null) {for (String item :additionalPeers){ this.addToAdditionalPeers(item);}} return (A) this;
  }
  public Boolean hasAdditionalPeers() {
    return additionalPeers != null && !additionalPeers.isEmpty();
  }
  public Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public Boolean hasAffinity() {
    return this.affinity != null;
  }
  
  /**
   * This method has been deprecated, please use method buildAlertmanagerConfigNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getAlertmanagerConfigNamespaceSelector() {
    return this.alertmanagerConfigNamespaceSelector!=null ?this.alertmanagerConfigNamespaceSelector.build():null;
  }
  public LabelSelector buildAlertmanagerConfigNamespaceSelector() {
    return this.alertmanagerConfigNamespaceSelector!=null ?this.alertmanagerConfigNamespaceSelector.build():null;
  }
  public A withAlertmanagerConfigNamespaceSelector(LabelSelector alertmanagerConfigNamespaceSelector) {
    _visitables.get("alertmanagerConfigNamespaceSelector").remove(this.alertmanagerConfigNamespaceSelector);
    if (alertmanagerConfigNamespaceSelector!=null){ this.alertmanagerConfigNamespaceSelector= new LabelSelectorBuilder(alertmanagerConfigNamespaceSelector); _visitables.get("alertmanagerConfigNamespaceSelector").add(this.alertmanagerConfigNamespaceSelector);} else { this.alertmanagerConfigNamespaceSelector = null; _visitables.get("alertmanagerConfigNamespaceSelector").remove(this.alertmanagerConfigNamespaceSelector); } return (A) this;
  }
  public Boolean hasAlertmanagerConfigNamespaceSelector() {
    return this.alertmanagerConfigNamespaceSelector != null;
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> withNewAlertmanagerConfigNamespaceSelector() {
    return new AlertmanagerSpecFluentImpl.AlertmanagerConfigNamespaceSelectorNestedImpl();
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> withNewAlertmanagerConfigNamespaceSelectorLike(LabelSelector item) {
    return new AlertmanagerSpecFluentImpl.AlertmanagerConfigNamespaceSelectorNestedImpl(item);
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> editAlertmanagerConfigNamespaceSelector() {
    return withNewAlertmanagerConfigNamespaceSelectorLike(getAlertmanagerConfigNamespaceSelector());
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> editOrNewAlertmanagerConfigNamespaceSelector() {
    return withNewAlertmanagerConfigNamespaceSelectorLike(getAlertmanagerConfigNamespaceSelector() != null ? getAlertmanagerConfigNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<A> editOrNewAlertmanagerConfigNamespaceSelectorLike(LabelSelector item) {
    return withNewAlertmanagerConfigNamespaceSelectorLike(getAlertmanagerConfigNamespaceSelector() != null ? getAlertmanagerConfigNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAlertmanagerConfigSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getAlertmanagerConfigSelector() {
    return this.alertmanagerConfigSelector!=null ?this.alertmanagerConfigSelector.build():null;
  }
  public LabelSelector buildAlertmanagerConfigSelector() {
    return this.alertmanagerConfigSelector!=null ?this.alertmanagerConfigSelector.build():null;
  }
  public A withAlertmanagerConfigSelector(LabelSelector alertmanagerConfigSelector) {
    _visitables.get("alertmanagerConfigSelector").remove(this.alertmanagerConfigSelector);
    if (alertmanagerConfigSelector!=null){ this.alertmanagerConfigSelector= new LabelSelectorBuilder(alertmanagerConfigSelector); _visitables.get("alertmanagerConfigSelector").add(this.alertmanagerConfigSelector);} else { this.alertmanagerConfigSelector = null; _visitables.get("alertmanagerConfigSelector").remove(this.alertmanagerConfigSelector); } return (A) this;
  }
  public Boolean hasAlertmanagerConfigSelector() {
    return this.alertmanagerConfigSelector != null;
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> withNewAlertmanagerConfigSelector() {
    return new AlertmanagerSpecFluentImpl.AlertmanagerConfigSelectorNestedImpl();
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> withNewAlertmanagerConfigSelectorLike(LabelSelector item) {
    return new AlertmanagerSpecFluentImpl.AlertmanagerConfigSelectorNestedImpl(item);
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> editAlertmanagerConfigSelector() {
    return withNewAlertmanagerConfigSelectorLike(getAlertmanagerConfigSelector());
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> editOrNewAlertmanagerConfigSelector() {
    return withNewAlertmanagerConfigSelectorLike(getAlertmanagerConfigSelector() != null ? getAlertmanagerConfigSelector(): new LabelSelectorBuilder().build());
  }
  public AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<A> editOrNewAlertmanagerConfigSelectorLike(LabelSelector item) {
    return withNewAlertmanagerConfigSelectorLike(getAlertmanagerConfigSelector() != null ? getAlertmanagerConfigSelector(): item);
  }
  public String getBaseImage() {
    return this.baseImage;
  }
  public A withBaseImage(String baseImage) {
    this.baseImage=baseImage; return (A) this;
  }
  public Boolean hasBaseImage() {
    return this.baseImage != null;
  }
  public String getClusterAdvertiseAddress() {
    return this.clusterAdvertiseAddress;
  }
  public A withClusterAdvertiseAddress(String clusterAdvertiseAddress) {
    this.clusterAdvertiseAddress=clusterAdvertiseAddress; return (A) this;
  }
  public Boolean hasClusterAdvertiseAddress() {
    return this.clusterAdvertiseAddress != null;
  }
  public String getClusterGossipInterval() {
    return this.clusterGossipInterval;
  }
  public A withClusterGossipInterval(String clusterGossipInterval) {
    this.clusterGossipInterval=clusterGossipInterval; return (A) this;
  }
  public Boolean hasClusterGossipInterval() {
    return this.clusterGossipInterval != null;
  }
  public String getClusterPeerTimeout() {
    return this.clusterPeerTimeout;
  }
  public A withClusterPeerTimeout(String clusterPeerTimeout) {
    this.clusterPeerTimeout=clusterPeerTimeout; return (A) this;
  }
  public Boolean hasClusterPeerTimeout() {
    return this.clusterPeerTimeout != null;
  }
  public String getClusterPushpullInterval() {
    return this.clusterPushpullInterval;
  }
  public A withClusterPushpullInterval(String clusterPushpullInterval) {
    this.clusterPushpullInterval=clusterPushpullInterval; return (A) this;
  }
  public Boolean hasClusterPushpullInterval() {
    return this.clusterPushpullInterval != null;
  }
  public A addToConfigMaps(Integer index,String item) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
    this.configMaps.add(index, item);
    return (A)this;
  }
  public A setToConfigMaps(Integer index,String item) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
    this.configMaps.set(index, item); return (A)this;
  }
  public A addToConfigMaps(java.lang.String... items) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
    for (String item : items) {this.configMaps.add(item);} return (A)this;
  }
  public A addAllToConfigMaps(Collection<String> items) {
    if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
    for (String item : items) {this.configMaps.add(item);} return (A)this;
  }
  public A removeFromConfigMaps(java.lang.String... items) {
    for (String item : items) {if (this.configMaps!= null){ this.configMaps.remove(item);}} return (A)this;
  }
  public A removeAllFromConfigMaps(Collection<String> items) {
    for (String item : items) {if (this.configMaps!= null){ this.configMaps.remove(item);}} return (A)this;
  }
  public List<String> getConfigMaps() {
    return this.configMaps;
  }
  public String getConfigMap(Integer index) {
    return this.configMaps.get(index);
  }
  public String getFirstConfigMap() {
    return this.configMaps.get(0);
  }
  public String getLastConfigMap() {
    return this.configMaps.get(configMaps.size() - 1);
  }
  public String getMatchingConfigMap(Predicate<String> predicate) {
    for (String item: configMaps) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingConfigMap(Predicate<String> predicate) {
    for (String item: configMaps) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfigMaps(List<String> configMaps) {
    if (configMaps != null) {this.configMaps = new ArrayList(); for (String item : configMaps){this.addToConfigMaps(item);}} else { this.configMaps = null;} return (A) this;
  }
  public A withConfigMaps(java.lang.String... configMaps) {
    if (this.configMaps != null) {this.configMaps.clear();}
    if (configMaps != null) {for (String item :configMaps){ this.addToConfigMaps(item);}} return (A) this;
  }
  public Boolean hasConfigMaps() {
    return configMaps != null && !configMaps.isEmpty();
  }
  public String getConfigSecret() {
    return this.configSecret;
  }
  public A withConfigSecret(String configSecret) {
    this.configSecret=configSecret; return (A) this;
  }
  public Boolean hasConfigSecret() {
    return this.configSecret != null;
  }
  public A addToContainers(Integer index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
  }
  public A setToContainers(Integer index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
    if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
     return (A)this;
  }
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A addAllToContainers(Collection<Container> items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<ContainerBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers() {
    return containers != null ? build(containers) : null;
  }
  public List<Container> buildContainers() {
    return containers != null ? build(containers) : null;
  }
  public Container buildContainer(Integer index) {
    return this.containers.get(index).build();
  }
  public Container buildFirstContainer() {
    return this.containers.get(0).build();
  }
  public Container buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainers(List<Container> containers) {
    if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
    if (containers != null) {this.containers = new ArrayList(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
  }
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers) {
    if (this.containers != null) {this.containers.clear();}
    if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
  }
  public Boolean hasContainers() {
    return containers != null && !containers.isEmpty();
  }
  public AlertmanagerSpecFluent.ContainersNested<A> addNewContainer() {
    return new AlertmanagerSpecFluentImpl.ContainersNestedImpl();
  }
  public AlertmanagerSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
    return new AlertmanagerSpecFluentImpl.ContainersNestedImpl(-1, item);
  }
  public AlertmanagerSpecFluent.ContainersNested<A> setNewContainerLike(Integer index,Container item) {
    return new AlertmanagerSpecFluentImpl.ContainersNestedImpl(index, item);
  }
  public AlertmanagerSpecFluent.ContainersNested<A> editContainer(Integer index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public AlertmanagerSpecFluent.ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  public AlertmanagerSpecFluent.ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public AlertmanagerSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public String getExternalUrl() {
    return this.externalUrl;
  }
  public A withExternalUrl(String externalUrl) {
    this.externalUrl=externalUrl; return (A) this;
  }
  public Boolean hasExternalUrl() {
    return this.externalUrl != null;
  }
  public Boolean getForceEnableClusterMode() {
    return this.forceEnableClusterMode;
  }
  public A withForceEnableClusterMode(Boolean forceEnableClusterMode) {
    this.forceEnableClusterMode=forceEnableClusterMode; return (A) this;
  }
  public Boolean hasForceEnableClusterMode() {
    return this.forceEnableClusterMode != null;
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public A addToImagePullSecrets(Integer index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(index >= 0 ? index : _visitables.get("imagePullSecrets").size(), builder);this.imagePullSecrets.add(index >= 0 ? index : imagePullSecrets.size(), builder); return (A)this;
  }
  public A setToImagePullSecrets(Integer index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("imagePullSecrets").size()) { _visitables.get("imagePullSecrets").add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder);}
    if (index < 0 || index >= imagePullSecrets.size()) { imagePullSecrets.add(builder); } else { imagePullSecrets.set(index, builder);}
     return (A)this;
  }
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (imagePullSecrets == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
    final List visitables = _visitables.get("imagePullSecrets");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public List<LocalObjectReference> buildImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public LocalObjectReference buildImagePullSecret(Integer index) {
    return this.imagePullSecrets.get(index).build();
  }
  public LocalObjectReference buildFirstImagePullSecret() {
    return this.imagePullSecrets.get(0).build();
  }
  public LocalObjectReference buildLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
  }
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
    if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
    if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
    if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  public Boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  public A addNewImagePullSecret(String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
    return new AlertmanagerSpecFluentImpl.ImagePullSecretsNestedImpl();
  }
  public AlertmanagerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
    return new AlertmanagerSpecFluentImpl.ImagePullSecretsNestedImpl(-1, item);
  }
  public AlertmanagerSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(Integer index,LocalObjectReference item) {
    return new AlertmanagerSpecFluentImpl.ImagePullSecretsNestedImpl(index, item);
  }
  public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(Integer index) {
    if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
    if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(0, buildImagePullSecret(0));
  }
  public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
    int index = imagePullSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public AlertmanagerSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imagePullSecrets.size();i++) { 
    if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public A addToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
  }
  public A setToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
    if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(Collection<Container> items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public List<Container> buildInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public Container buildInitContainer(Integer index) {
    return this.initContainers.get(index).build();
  }
  public Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainers(List<Container> initContainers) {
    if (this.initContainers != null) { _visitables.get("initContainers").removeAll(this.initContainers);}
    if (initContainers != null) {this.initContainers = new ArrayList(); for (Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
  }
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear();}
    if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  public Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainer() {
    return new AlertmanagerSpecFluentImpl.InitContainersNestedImpl();
  }
  public AlertmanagerSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
    return new AlertmanagerSpecFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public AlertmanagerSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item) {
    return new AlertmanagerSpecFluentImpl.InitContainersNestedImpl(index, item);
  }
  public AlertmanagerSpecFluent.InitContainersNested<A> editInitContainer(Integer index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public AlertmanagerSpecFluent.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public AlertmanagerSpecFluent.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public AlertmanagerSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public Boolean getListenLocal() {
    return this.listenLocal;
  }
  public A withListenLocal(Boolean listenLocal) {
    this.listenLocal=listenLocal; return (A) this;
  }
  public Boolean hasListenLocal() {
    return this.listenLocal != null;
  }
  public String getLogFormat() {
    return this.logFormat;
  }
  public A withLogFormat(String logFormat) {
    this.logFormat=logFormat; return (A) this;
  }
  public Boolean hasLogFormat() {
    return this.logFormat != null;
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public Boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public Boolean getPaused() {
    return this.paused;
  }
  public A withPaused(Boolean paused) {
    this.paused=paused; return (A) this;
  }
  public Boolean hasPaused() {
    return this.paused != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPodMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public EmbeddedObjectMetadata getPodMetadata() {
    return this.podMetadata!=null ?this.podMetadata.build():null;
  }
  public EmbeddedObjectMetadata buildPodMetadata() {
    return this.podMetadata!=null ?this.podMetadata.build():null;
  }
  public A withPodMetadata(EmbeddedObjectMetadata podMetadata) {
    _visitables.get("podMetadata").remove(this.podMetadata);
    if (podMetadata!=null){ this.podMetadata= new EmbeddedObjectMetadataBuilder(podMetadata); _visitables.get("podMetadata").add(this.podMetadata);} else { this.podMetadata = null; _visitables.get("podMetadata").remove(this.podMetadata); } return (A) this;
  }
  public Boolean hasPodMetadata() {
    return this.podMetadata != null;
  }
  public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadata() {
    return new AlertmanagerSpecFluentImpl.PodMetadataNestedImpl();
  }
  public AlertmanagerSpecFluent.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item) {
    return new AlertmanagerSpecFluentImpl.PodMetadataNestedImpl(item);
  }
  public AlertmanagerSpecFluent.PodMetadataNested<A> editPodMetadata() {
    return withNewPodMetadataLike(getPodMetadata());
  }
  public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadata() {
    return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): new EmbeddedObjectMetadataBuilder().build());
  }
  public AlertmanagerSpecFluent.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item) {
    return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): item);
  }
  public String getPortName() {
    return this.portName;
  }
  public A withPortName(String portName) {
    this.portName=portName; return (A) this;
  }
  public Boolean hasPortName() {
    return this.portName != null;
  }
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName=priorityClassName; return (A) this;
  }
  public Boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public AlertmanagerSpecFluent.ResourcesNested<A> withNewResources() {
    return new AlertmanagerSpecFluentImpl.ResourcesNestedImpl();
  }
  public AlertmanagerSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new AlertmanagerSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public AlertmanagerSpecFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public AlertmanagerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public String getRetention() {
    return this.retention;
  }
  public A withRetention(String retention) {
    this.retention=retention; return (A) this;
  }
  public Boolean hasRetention() {
    return this.retention != null;
  }
  public String getRoutePrefix() {
    return this.routePrefix;
  }
  public A withRoutePrefix(String routePrefix) {
    this.routePrefix=routePrefix; return (A) this;
  }
  public Boolean hasRoutePrefix() {
    return this.routePrefix != null;
  }
  public A addToSecrets(Integer index,String item) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    this.secrets.add(index, item);
    return (A)this;
  }
  public A setToSecrets(Integer index,String item) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    this.secrets.set(index, item); return (A)this;
  }
  public A addToSecrets(java.lang.String... items) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    for (String item : items) {this.secrets.add(item);} return (A)this;
  }
  public A addAllToSecrets(Collection<String> items) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    for (String item : items) {this.secrets.add(item);} return (A)this;
  }
  public A removeFromSecrets(java.lang.String... items) {
    for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
  }
  public A removeAllFromSecrets(Collection<String> items) {
    for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
  }
  public List<String> getSecrets() {
    return this.secrets;
  }
  public String getSecret(Integer index) {
    return this.secrets.get(index);
  }
  public String getFirstSecret() {
    return this.secrets.get(0);
  }
  public String getLastSecret() {
    return this.secrets.get(secrets.size() - 1);
  }
  public String getMatchingSecret(Predicate<String> predicate) {
    for (String item: secrets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSecret(Predicate<String> predicate) {
    for (String item: secrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSecrets(List<String> secrets) {
    if (secrets != null) {this.secrets = new ArrayList(); for (String item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
  }
  public A withSecrets(java.lang.String... secrets) {
    if (this.secrets != null) {this.secrets.clear();}
    if (secrets != null) {for (String item :secrets){ this.addToSecrets(item);}} return (A) this;
  }
  public Boolean hasSecrets() {
    return secrets != null && !secrets.isEmpty();
  }
  public PodSecurityContext getSecurityContext() {
    return this.securityContext;
  }
  public A withSecurityContext(PodSecurityContext securityContext) {
    this.securityContext=securityContext; return (A) this;
  }
  public Boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  public String getSha() {
    return this.sha;
  }
  public A withSha(String sha) {
    this.sha=sha; return (A) this;
  }
  public Boolean hasSha() {
    return this.sha != null;
  }
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public StorageSpec getStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public StorageSpec buildStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public A withStorage(StorageSpec storage) {
    _visitables.get("storage").remove(this.storage);
    if (storage!=null){ this.storage= new StorageSpecBuilder(storage); _visitables.get("storage").add(this.storage);} else { this.storage = null; _visitables.get("storage").remove(this.storage); } return (A) this;
  }
  public Boolean hasStorage() {
    return this.storage != null;
  }
  public AlertmanagerSpecFluent.StorageNested<A> withNewStorage() {
    return new AlertmanagerSpecFluentImpl.StorageNestedImpl();
  }
  public AlertmanagerSpecFluent.StorageNested<A> withNewStorageLike(StorageSpec item) {
    return new AlertmanagerSpecFluentImpl.StorageNestedImpl(item);
  }
  public AlertmanagerSpecFluent.StorageNested<A> editStorage() {
    return withNewStorageLike(getStorage());
  }
  public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorage() {
    return withNewStorageLike(getStorage() != null ? getStorage(): new StorageSpecBuilder().build());
  }
  public AlertmanagerSpecFluent.StorageNested<A> editOrNewStorageLike(StorageSpec item) {
    return withNewStorageLike(getStorage() != null ? getStorage(): item);
  }
  public String getTag() {
    return this.tag;
  }
  public A withTag(String tag) {
    this.tag=tag; return (A) this;
  }
  public Boolean hasTag() {
    return this.tag != null;
  }
  public A addToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(Integer index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear();}
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.add(index, item);
    return (A)this;
  }
  public A setToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    this.topologySpreadConstraints.set(index, item); return (A)this;
  }
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
    for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
  }
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
  }
  public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
    return this.topologySpreadConstraints;
  }
  public TopologySpreadConstraint getTopologySpreadConstraint(Integer index) {
    return this.topologySpreadConstraints.get(index);
  }
  public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0);
  }
  public TopologySpreadConstraint getLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
  }
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
    for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
    if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new ArrayList(); for (TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
  }
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear();}
    if (topologySpreadConstraints != null) {for (TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
  }
  public Boolean hasTopologySpreadConstraints() {
    return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public A addToVolumeMounts(Integer index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    this.volumeMounts.add(index, item);
    return (A)this;
  }
  public A setToVolumeMounts(Integer index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    this.volumeMounts.set(index, item); return (A)this;
  }
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  public A addAllToVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
    for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
  }
  public List<VolumeMount> getVolumeMounts() {
    return this.volumeMounts;
  }
  public VolumeMount getVolumeMount(Integer index) {
    return this.volumeMounts.get(index);
  }
  public VolumeMount getFirstVolumeMount() {
    return this.volumeMounts.get(0);
  }
  public VolumeMount getLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1);
  }
  public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
    for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
    for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeMounts(List<VolumeMount> volumeMounts) {
    if (volumeMounts != null) {this.volumeMounts = new ArrayList(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
  }
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
    if (this.volumeMounts != null) {this.volumeMounts.clear();}
    if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
  }
  public Boolean hasVolumeMounts() {
    return volumeMounts != null && !volumeMounts.isEmpty();
  }
  public A addToVolumes(Integer index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    this.volumes.add(index, item);
    return (A)this;
  }
  public A setToVolumes(Integer index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    this.volumes.set(index, item); return (A)this;
  }
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    for (Volume item : items) {this.volumes.add(item);} return (A)this;
  }
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    for (Volume item : items) {this.volumes.add(item);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<Volume> items) {
    for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public List<Volume> getVolumes() {
    return this.volumes;
  }
  public Volume getVolume(Integer index) {
    return this.volumes.get(index);
  }
  public Volume getFirstVolume() {
    return this.volumes.get(0);
  }
  public Volume getLastVolume() {
    return this.volumes.get(volumes.size() - 1);
  }
  public Volume getMatchingVolume(Predicate<Volume> predicate) {
    for (Volume item: volumes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
    for (Volume item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<Volume> volumes) {
    if (volumes != null) {this.volumes = new ArrayList(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AlertmanagerSpecFluentImpl that = (AlertmanagerSpecFluentImpl) o;
    if (additionalPeers != null ? !additionalPeers.equals(that.additionalPeers) :that.additionalPeers != null) return false;
    if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
    if (alertmanagerConfigNamespaceSelector != null ? !alertmanagerConfigNamespaceSelector.equals(that.alertmanagerConfigNamespaceSelector) :that.alertmanagerConfigNamespaceSelector != null) return false;
    if (alertmanagerConfigSelector != null ? !alertmanagerConfigSelector.equals(that.alertmanagerConfigSelector) :that.alertmanagerConfigSelector != null) return false;
    if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
    if (clusterAdvertiseAddress != null ? !clusterAdvertiseAddress.equals(that.clusterAdvertiseAddress) :that.clusterAdvertiseAddress != null) return false;
    if (clusterGossipInterval != null ? !clusterGossipInterval.equals(that.clusterGossipInterval) :that.clusterGossipInterval != null) return false;
    if (clusterPeerTimeout != null ? !clusterPeerTimeout.equals(that.clusterPeerTimeout) :that.clusterPeerTimeout != null) return false;
    if (clusterPushpullInterval != null ? !clusterPushpullInterval.equals(that.clusterPushpullInterval) :that.clusterPushpullInterval != null) return false;
    if (configMaps != null ? !configMaps.equals(that.configMaps) :that.configMaps != null) return false;
    if (configSecret != null ? !configSecret.equals(that.configSecret) :that.configSecret != null) return false;
    if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
    if (externalUrl != null ? !externalUrl.equals(that.externalUrl) :that.externalUrl != null) return false;
    if (forceEnableClusterMode != null ? !forceEnableClusterMode.equals(that.forceEnableClusterMode) :that.forceEnableClusterMode != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (listenLocal != null ? !listenLocal.equals(that.listenLocal) :that.listenLocal != null) return false;
    if (logFormat != null ? !logFormat.equals(that.logFormat) :that.logFormat != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
    if (podMetadata != null ? !podMetadata.equals(that.podMetadata) :that.podMetadata != null) return false;
    if (portName != null ? !portName.equals(that.portName) :that.portName != null) return false;
    if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (retention != null ? !retention.equals(that.retention) :that.retention != null) return false;
    if (routePrefix != null ? !routePrefix.equals(that.routePrefix) :that.routePrefix != null) return false;
    if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
    if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
    if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
    if (sha != null ? !sha.equals(that.sha) :that.sha != null) return false;
    if (storage != null ? !storage.equals(that.storage) :that.storage != null) return false;
    if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
    if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
    if (topologySpreadConstraints != null ? !topologySpreadConstraints.equals(that.topologySpreadConstraints) :that.topologySpreadConstraints != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalPeers,  affinity,  alertmanagerConfigNamespaceSelector,  alertmanagerConfigSelector,  baseImage,  clusterAdvertiseAddress,  clusterGossipInterval,  clusterPeerTimeout,  clusterPushpullInterval,  configMaps,  configSecret,  containers,  externalUrl,  forceEnableClusterMode,  image,  imagePullSecrets,  initContainers,  listenLocal,  logFormat,  logLevel,  minReadySeconds,  nodeSelector,  paused,  podMetadata,  portName,  priorityClassName,  replicas,  resources,  retention,  routePrefix,  secrets,  securityContext,  serviceAccountName,  sha,  storage,  tag,  tolerations,  topologySpreadConstraints,  version,  volumeMounts,  volumes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalPeers != null && !additionalPeers.isEmpty()) { sb.append("additionalPeers:"); sb.append(additionalPeers + ","); }
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (alertmanagerConfigNamespaceSelector != null) { sb.append("alertmanagerConfigNamespaceSelector:"); sb.append(alertmanagerConfigNamespaceSelector + ","); }
    if (alertmanagerConfigSelector != null) { sb.append("alertmanagerConfigSelector:"); sb.append(alertmanagerConfigSelector + ","); }
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (clusterAdvertiseAddress != null) { sb.append("clusterAdvertiseAddress:"); sb.append(clusterAdvertiseAddress + ","); }
    if (clusterGossipInterval != null) { sb.append("clusterGossipInterval:"); sb.append(clusterGossipInterval + ","); }
    if (clusterPeerTimeout != null) { sb.append("clusterPeerTimeout:"); sb.append(clusterPeerTimeout + ","); }
    if (clusterPushpullInterval != null) { sb.append("clusterPushpullInterval:"); sb.append(clusterPushpullInterval + ","); }
    if (configMaps != null && !configMaps.isEmpty()) { sb.append("configMaps:"); sb.append(configMaps + ","); }
    if (configSecret != null) { sb.append("configSecret:"); sb.append(configSecret + ","); }
    if (containers != null && !containers.isEmpty()) { sb.append("containers:"); sb.append(containers + ","); }
    if (externalUrl != null) { sb.append("externalUrl:"); sb.append(externalUrl + ","); }
    if (forceEnableClusterMode != null) { sb.append("forceEnableClusterMode:"); sb.append(forceEnableClusterMode + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (listenLocal != null) { sb.append("listenLocal:"); sb.append(listenLocal + ","); }
    if (logFormat != null) { sb.append("logFormat:"); sb.append(logFormat + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (podMetadata != null) { sb.append("podMetadata:"); sb.append(podMetadata + ","); }
    if (portName != null) { sb.append("portName:"); sb.append(portName + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (retention != null) { sb.append("retention:"); sb.append(retention + ","); }
    if (routePrefix != null) { sb.append("routePrefix:"); sb.append(routePrefix + ","); }
    if (secrets != null && !secrets.isEmpty()) { sb.append("secrets:"); sb.append(secrets + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sha != null) { sb.append("sha:"); sb.append(sha + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty()) { sb.append("topologySpreadConstraints:"); sb.append(topologySpreadConstraints + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (volumeMounts != null && !volumeMounts.isEmpty()) { sb.append("volumeMounts:"); sb.append(volumeMounts + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withForceEnableClusterMode() {
    return withForceEnableClusterMode(true);
  }
  public A withListenLocal() {
    return withListenLocal(true);
  }
  public A withPaused() {
    return withPaused(true);
  }
  class AlertmanagerConfigNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<N>> implements AlertmanagerSpecFluent.AlertmanagerConfigNamespaceSelectorNested<N>,Nested<N>{
    AlertmanagerConfigNamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    AlertmanagerConfigNamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) AlertmanagerSpecFluentImpl.this.withAlertmanagerConfigNamespaceSelector(builder.build());
    }
    public N endAlertmanagerConfigNamespaceSelector() {
      return and();
    }
    
  }
  class AlertmanagerConfigSelectorNestedImpl<N> extends LabelSelectorFluentImpl<AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<N>> implements AlertmanagerSpecFluent.AlertmanagerConfigSelectorNested<N>,Nested<N>{
    AlertmanagerConfigSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    AlertmanagerConfigSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) AlertmanagerSpecFluentImpl.this.withAlertmanagerConfigSelector(builder.build());
    }
    public N endAlertmanagerConfigSelector() {
      return and();
    }
    
  }
  class ContainersNestedImpl<N> extends ContainerFluentImpl<AlertmanagerSpecFluent.ContainersNested<N>> implements AlertmanagerSpecFluent.ContainersNested<N>,Nested<N>{
    ContainersNestedImpl(Integer index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) AlertmanagerSpecFluentImpl.this.setToContainers(index,builder.build());
    }
    public N endContainer() {
      return and();
    }
    
  }
  class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<AlertmanagerSpecFluent.ImagePullSecretsNested<N>> implements AlertmanagerSpecFluent.ImagePullSecretsNested<N>,Nested<N>{
    ImagePullSecretsNestedImpl(Integer index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ImagePullSecretsNestedImpl() {
      this.index = -1;
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) AlertmanagerSpecFluentImpl.this.setToImagePullSecrets(index,builder.build());
    }
    public N endImagePullSecret() {
      return and();
    }
    
  }
  class InitContainersNestedImpl<N> extends ContainerFluentImpl<AlertmanagerSpecFluent.InitContainersNested<N>> implements AlertmanagerSpecFluent.InitContainersNested<N>,Nested<N>{
    InitContainersNestedImpl(Integer index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) AlertmanagerSpecFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  class PodMetadataNestedImpl<N> extends EmbeddedObjectMetadataFluentImpl<AlertmanagerSpecFluent.PodMetadataNested<N>> implements AlertmanagerSpecFluent.PodMetadataNested<N>,Nested<N>{
    PodMetadataNestedImpl(EmbeddedObjectMetadata item) {
      this.builder = new EmbeddedObjectMetadataBuilder(this, item);
    }
    PodMetadataNestedImpl() {
      this.builder = new EmbeddedObjectMetadataBuilder(this);
    }
    EmbeddedObjectMetadataBuilder builder;
    public N and() {
      return (N) AlertmanagerSpecFluentImpl.this.withPodMetadata(builder.build());
    }
    public N endPodMetadata() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<AlertmanagerSpecFluent.ResourcesNested<N>> implements AlertmanagerSpecFluent.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) AlertmanagerSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class StorageNestedImpl<N> extends StorageSpecFluentImpl<AlertmanagerSpecFluent.StorageNested<N>> implements AlertmanagerSpecFluent.StorageNested<N>,Nested<N>{
    StorageNestedImpl(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageNestedImpl() {
      this.builder = new StorageSpecBuilder(this);
    }
    StorageSpecBuilder builder;
    public N and() {
      return (N) AlertmanagerSpecFluentImpl.this.withStorage(builder.build());
    }
    public N endStorage() {
      return and();
    }
    
  }
  
}