package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class APIServerConfigFluentImpl<A extends APIServerConfigFluent<A>> extends BaseFluent<A> implements APIServerConfigFluent<A>{
  public APIServerConfigFluentImpl() {
  }
  public APIServerConfigFluentImpl(APIServerConfig instance) {
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerToken(instance.getBearerToken()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withHost(instance.getHost()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private AuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private String bearerToken;
  private String bearerTokenFile;
  private String host;
  private TLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public Authorization getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public Authorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(Authorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new AuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} else { this.authorization = null; _visitables.get("authorization").remove(this.authorization); } return (A) this;
  }
  public Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public APIServerConfigFluent.AuthorizationNested<A> withNewAuthorization() {
    return new APIServerConfigFluentImpl.AuthorizationNestedImpl();
  }
  public APIServerConfigFluent.AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
    return new APIServerConfigFluentImpl.AuthorizationNestedImpl(item);
  }
  public APIServerConfigFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public APIServerConfigFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new AuthorizationBuilder().build());
  }
  public APIServerConfigFluent.AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @Deprecated
  public BasicAuth getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public BasicAuth buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} else { this.basicAuth = null; _visitables.get("basicAuth").remove(this.basicAuth); } return (A) this;
  }
  public Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public APIServerConfigFluent.BasicAuthNested<A> withNewBasicAuth() {
    return new APIServerConfigFluentImpl.BasicAuthNestedImpl();
  }
  public APIServerConfigFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new APIServerConfigFluentImpl.BasicAuthNestedImpl(item);
  }
  public APIServerConfigFluent.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public APIServerConfigFluent.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthBuilder().build());
  }
  public APIServerConfigFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  public String getBearerToken() {
    return this.bearerToken;
  }
  public A withBearerToken(String bearerToken) {
    this.bearerToken=bearerToken; return (A) this;
  }
  public Boolean hasBearerToken() {
    return this.bearerToken != null;
  }
  public String getBearerTokenFile() {
    return this.bearerTokenFile;
  }
  public A withBearerTokenFile(String bearerTokenFile) {
    this.bearerTokenFile=bearerTokenFile; return (A) this;
  }
  public Boolean hasBearerTokenFile() {
    return this.bearerTokenFile != null;
  }
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public TLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(TLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} else { this.tlsConfig = null; _visitables.get("tlsConfig").remove(this.tlsConfig); } return (A) this;
  }
  public Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public APIServerConfigFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new APIServerConfigFluentImpl.TlsConfigNestedImpl();
  }
  public APIServerConfigFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
    return new APIServerConfigFluentImpl.TlsConfigNestedImpl(item);
  }
  public APIServerConfigFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public APIServerConfigFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
  }
  public APIServerConfigFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    APIServerConfigFluentImpl that = (APIServerConfigFluentImpl) o;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
    if (bearerToken != null ? !bearerToken.equals(that.bearerToken) :that.bearerToken != null) return false;
    if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerToken,  bearerTokenFile,  host,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerToken != null) { sb.append("bearerToken:"); sb.append(bearerToken + ","); }
    if (bearerTokenFile != null) { sb.append("bearerTokenFile:"); sb.append(bearerTokenFile + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationNestedImpl<N> extends AuthorizationFluentImpl<APIServerConfigFluent.AuthorizationNested<N>> implements APIServerConfigFluent.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(Authorization item) {
      this.builder = new AuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new AuthorizationBuilder(this);
    }
    AuthorizationBuilder builder;
    public N and() {
      return (N) APIServerConfigFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<APIServerConfigFluent.BasicAuthNested<N>> implements APIServerConfigFluent.BasicAuthNested<N>,Nested<N>{
    BasicAuthNestedImpl(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new BasicAuthBuilder(this);
    }
    BasicAuthBuilder builder;
    public N and() {
      return (N) APIServerConfigFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<APIServerConfigFluent.TlsConfigNested<N>> implements APIServerConfigFluent.TlsConfigNested<N>,Nested<N>{
    TlsConfigNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) APIServerConfigFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}