/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.Rule;
import io.fabric8.openshift.api.model.monitoring.v1.RuleFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class RuleFluentImpl<A extends RuleFluent<A>>
extends BaseFluent<A>
implements RuleFluent<A> {
    private String alert;
    private Map<String, String> annotations;
    private IntOrStringBuilder expr;
    private String _for;
    private Map<String, String> labels;
    private String record;

    public RuleFluentImpl() {
    }

    public RuleFluentImpl(Rule instance) {
        this.withAlert(instance.getAlert());
        this.withAnnotations(instance.getAnnotations());
        this.withExpr(instance.getExpr());
        this.withFor(instance.getFor());
        this.withLabels(instance.getLabels());
        this.withRecord(instance.getRecord());
    }

    @Override
    public String getAlert() {
        return this.alert;
    }

    @Override
    public A withAlert(String alert) {
        this.alert = alert;
        return (A)this;
    }

    @Override
    public Boolean hasAlert() {
        return this.alert != null;
    }

    @Override
    @Deprecated
    public A withNewAlert(String arg0) {
        return this.withAlert(new String(arg0));
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    @Deprecated
    public IntOrString getExpr() {
        return this.expr != null ? this.expr.build() : null;
    }

    @Override
    public IntOrString buildExpr() {
        return this.expr != null ? this.expr.build() : null;
    }

    @Override
    public A withExpr(IntOrString expr) {
        this._visitables.get((Object)"expr").remove(this.expr);
        if (expr != null) {
            this.expr = new IntOrStringBuilder(expr);
            this._visitables.get((Object)"expr").add(this.expr);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExpr() {
        return this.expr != null;
    }

    @Override
    public A withNewExpr(Integer intVal) {
        return this.withExpr(new IntOrString(intVal));
    }

    @Override
    public A withNewExpr(String strVal) {
        return this.withExpr(new IntOrString(strVal));
    }

    @Override
    public RuleFluent.ExprNested<A> withNewExpr() {
        return new ExprNestedImpl();
    }

    @Override
    public RuleFluent.ExprNested<A> withNewExprLike(IntOrString item) {
        return new ExprNestedImpl(item);
    }

    @Override
    public RuleFluent.ExprNested<A> editExpr() {
        return this.withNewExprLike(this.getExpr());
    }

    @Override
    public RuleFluent.ExprNested<A> editOrNewExpr() {
        return this.withNewExprLike(this.getExpr() != null ? this.getExpr() : new IntOrStringBuilder().build());
    }

    @Override
    public RuleFluent.ExprNested<A> editOrNewExprLike(IntOrString item) {
        return this.withNewExprLike(this.getExpr() != null ? this.getExpr() : item);
    }

    @Override
    public String getFor() {
        return this._for;
    }

    @Override
    public A withFor(String _for) {
        this._for = _for;
        return (A)this;
    }

    @Override
    public Boolean hasFor() {
        return this._for != null;
    }

    @Override
    @Deprecated
    public A withNewFor(String arg0) {
        return this.withFor(new String(arg0));
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public String getRecord() {
        return this.record;
    }

    @Override
    public A withRecord(String record) {
        this.record = record;
        return (A)this;
    }

    @Override
    public Boolean hasRecord() {
        return this.record != null;
    }

    @Override
    @Deprecated
    public A withNewRecord(String arg0) {
        return this.withRecord(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleFluentImpl that = (RuleFluentImpl)o;
        if (this.alert != null ? !this.alert.equals(that.alert) : that.alert != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.expr != null ? !this.expr.equals((Object)that.expr) : that.expr != null) {
            return false;
        }
        if (this._for != null ? !this._for.equals(that._for) : that._for != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        return !(this.record != null ? !this.record.equals(that.record) : that.record != null);
    }

    public int hashCode() {
        return Objects.hash(this.alert, this.annotations, this.expr, this._for, this.labels, this.record, super.hashCode());
    }

    public class ExprNestedImpl<N>
    extends IntOrStringFluentImpl<RuleFluent.ExprNested<N>>
    implements RuleFluent.ExprNested<N>,
    Nested<N> {
        private final IntOrStringBuilder builder;

        ExprNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this, item);
        }

        ExprNestedImpl() {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this);
        }

        @Override
        public N and() {
            return (N)RuleFluentImpl.this.withExpr(this.builder.build());
        }

        @Override
        public N endExpr() {
            return this.and();
        }
    }
}

