package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ThanosSpecBuilder extends io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.ThanosSpec,io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecBuilder>{
  public ThanosSpecBuilder() {
    this(false);
  }
  public ThanosSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ThanosSpec(), validationEnabled);
  }
  public ThanosSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ThanosSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ThanosSpec(), validationEnabled);
  }
  public ThanosSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ThanosSpec instance) {
    this(fluent, instance, false);
  }
  public ThanosSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ThanosSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBaseImage(instance.getBaseImage()); 
    fluent.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig()); 
    fluent.withImage(instance.getImage()); 
    fluent.withListenLocal(instance.getListenLocal()); 
    fluent.withLogFormat(instance.getLogFormat()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withMinTime(instance.getMinTime()); 
    fluent.withObjectStorageConfig(instance.getObjectStorageConfig()); 
    fluent.withObjectStorageConfigFile(instance.getObjectStorageConfigFile()); 
    fluent.withReadyTimeout(instance.getReadyTimeout()); 
    fluent.withResources(instance.getResources()); 
    fluent.withSha(instance.getSha()); 
    fluent.withTag(instance.getTag()); 
    fluent.withTracingConfig(instance.getTracingConfig()); 
    fluent.withTracingConfigFile(instance.getTracingConfigFile()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withVolumeMounts(instance.getVolumeMounts()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ThanosSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosSpec instance) {
    this(instance,false);
  }
  public ThanosSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBaseImage(instance.getBaseImage()); 
    this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig()); 
    this.withImage(instance.getImage()); 
    this.withListenLocal(instance.getListenLocal()); 
    this.withLogFormat(instance.getLogFormat()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withMinTime(instance.getMinTime()); 
    this.withObjectStorageConfig(instance.getObjectStorageConfig()); 
    this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile()); 
    this.withReadyTimeout(instance.getReadyTimeout()); 
    this.withResources(instance.getResources()); 
    this.withSha(instance.getSha()); 
    this.withTag(instance.getTag()); 
    this.withTracingConfig(instance.getTracingConfig()); 
    this.withTracingConfigFile(instance.getTracingConfigFile()); 
    this.withVersion(instance.getVersion()); 
    this.withVolumeMounts(instance.getVolumeMounts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.ThanosSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosSpec build() {
    ThanosSpec buildable = new ThanosSpec(fluent.getBaseImage(),fluent.getGrpcServerTlsConfig(),fluent.getImage(),fluent.getListenLocal(),fluent.getLogFormat(),fluent.getLogLevel(),fluent.getMinTime(),fluent.getObjectStorageConfig(),fluent.getObjectStorageConfigFile(),fluent.getReadyTimeout(),fluent.getResources(),fluent.getSha(),fluent.getTag(),fluent.getTracingConfig(),fluent.getTracingConfigFile(),fluent.getVersion(),fluent.getVolumeMounts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ThanosSpecBuilder that = (ThanosSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}