package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class APIServerConfigBuilder extends io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.APIServerConfig,io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigBuilder>{
  public APIServerConfigBuilder() {
    this(false);
  }
  public APIServerConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new APIServerConfig(), validationEnabled);
  }
  public APIServerConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIServerConfig(), validationEnabled);
  }
  public APIServerConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.APIServerConfig instance) {
    this(fluent, instance, false);
  }
  public APIServerConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.APIServerConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthorization(instance.getAuthorization()); 
    fluent.withBasicAuth(instance.getBasicAuth()); 
    fluent.withBearerToken(instance.getBearerToken()); 
    fluent.withBearerTokenFile(instance.getBearerTokenFile()); 
    fluent.withHost(instance.getHost()); 
    fluent.withTlsConfig(instance.getTlsConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServerConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.APIServerConfig instance) {
    this(instance,false);
  }
  public APIServerConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.APIServerConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerToken(instance.getBearerToken()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withHost(instance.getHost()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.APIServerConfig build() {
    APIServerConfig buildable = new APIServerConfig(fluent.getAuthorization(),fluent.getBasicAuth(),fluent.getBearerToken(),fluent.getBearerTokenFile(),fluent.getHost(),fluent.getTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServerConfigBuilder that = (APIServerConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}