package io.fabric8.openshift.api.model.miscellaneous.helm.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import java.lang.Object;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConnectionConfigNamespaceScopedFluent<A extends io.fabric8.openshift.api.model.miscellaneous.helm.v1beta1.ConnectionConfigNamespaceScopedFluent<A>> extends BaseFluent<A>{

  private Map<String,Object> additionalProperties;
  private SecretNameReference basicAuthConfig;
  private ConfigMapNameReference ca;
  private SecretNameReference tlsClientConfig;
  private String url;

  public ConnectionConfigNamespaceScopedFluent() {
  }
  
  public ConnectionConfigNamespaceScopedFluent(ConnectionConfigNamespaceScoped instance) {
    this.copyInstance(instance);
  }

  public A addToAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null && map != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (map != null) {
      this.additionalProperties.putAll(map);
    }
    return (A) this;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if (this.additionalProperties == null && key != null && value != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (key != null && value != null) {
      this.additionalProperties.put(key, value);
    }
    return (A) this;
  }
  
  protected void copyInstance(ConnectionConfigNamespaceScoped instance) {
    instance = instance != null ? instance : new ConnectionConfigNamespaceScoped();
    if (instance != null) {
        this.withBasicAuthConfig(instance.getBasicAuthConfig());
        this.withCa(instance.getCa());
        this.withTlsClientConfig(instance.getTlsClientConfig());
        this.withUrl(instance.getUrl());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }
    if (!(super.equals(o))) {
      return false;
    }
    ConnectionConfigNamespaceScopedFluent that = (ConnectionConfigNamespaceScopedFluent) o;
    if (!(Objects.equals(basicAuthConfig, that.basicAuthConfig))) {
      return false;
    }
    if (!(Objects.equals(ca, that.ca))) {
      return false;
    }
    if (!(Objects.equals(tlsClientConfig, that.tlsClientConfig))) {
      return false;
    }
    if (!(Objects.equals(url, that.url))) {
      return false;
    }
    if (!(Objects.equals(additionalProperties, that.additionalProperties))) {
      return false;
    }
    return true;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public SecretNameReference getBasicAuthConfig() {
    return this.basicAuthConfig;
  }
  
  public ConfigMapNameReference getCa() {
    return this.ca;
  }
  
  public SecretNameReference getTlsClientConfig() {
    return this.tlsClientConfig;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean hasBasicAuthConfig() {
    return this.basicAuthConfig != null;
  }
  
  public boolean hasCa() {
    return this.ca != null;
  }
  
  public boolean hasTlsClientConfig() {
    return this.tlsClientConfig != null;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public int hashCode() {
    return Objects.hash(basicAuthConfig, ca, tlsClientConfig, url, additionalProperties);
  }
  
  public A removeFromAdditionalProperties(String key) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (key != null && this.additionalProperties != null) {
      this.additionalProperties.remove(key);
    }
    return (A) this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (map != null) {
      for (Object key : map.keySet()) {
        if (this.additionalProperties != null) {
          this.additionalProperties.remove(key);
        }
      }
    }
    return (A) this;
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (!(basicAuthConfig == null)) {
        sb.append("basicAuthConfig:");
        sb.append(basicAuthConfig);
        sb.append(",");
    }
    if (!(ca == null)) {
        sb.append("ca:");
        sb.append(ca);
        sb.append(",");
    }
    if (!(tlsClientConfig == null)) {
        sb.append("tlsClientConfig:");
        sb.append(tlsClientConfig);
        sb.append(",");
    }
    if (!(url == null)) {
        sb.append("url:");
        sb.append(url);
        sb.append(",");
    }
    if (!(additionalProperties == null) && !(additionalProperties.isEmpty())) {
        sb.append("additionalProperties:");
        sb.append(additionalProperties);
    }
    sb.append("}");
    return sb.toString();
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public A withBasicAuthConfig(SecretNameReference basicAuthConfig) {
    this.basicAuthConfig = basicAuthConfig;
    return (A) this;
  }
  
  public A withCa(ConfigMapNameReference ca) {
    this.ca = ca;
    return (A) this;
  }
  
  public A withNewBasicAuthConfig(String name) {
    return (A) this.withBasicAuthConfig(new SecretNameReference(name));
  }
  
  public A withNewCa(String name) {
    return (A) this.withCa(new ConfigMapNameReference(name));
  }
  
  public A withNewTlsClientConfig(String name) {
    return (A) this.withTlsClientConfig(new SecretNameReference(name));
  }
  
  public A withTlsClientConfig(SecretNameReference tlsClientConfig) {
    this.tlsClientConfig = tlsClientConfig;
    return (A) this;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
}