/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedAddress;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedAddressBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedAddressFluent;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSNameResolverResolvedNameFluent<A extends DNSNameResolverResolvedNameFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String dnsName;
    private Integer resolutionFailures;
    private ArrayList<DNSNameResolverResolvedAddressBuilder> resolvedAddresses = new ArrayList();

    public DNSNameResolverResolvedNameFluent() {
    }

    public DNSNameResolverResolvedNameFluent(DNSNameResolverResolvedName instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResolvedAddresses(Collection<DNSNameResolverResolvedAddress> items) {
        if (this.resolvedAddresses == null) {
            this.resolvedAddresses = new ArrayList();
        }
        for (DNSNameResolverResolvedAddress item : items) {
            DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
            this._visitables.get((Object)"resolvedAddresses").add(builder);
            this.resolvedAddresses.add(builder);
        }
        return (A)((Object)this);
    }

    public ResolvedAddressesNested<A> addNewResolvedAddress() {
        return new ResolvedAddressesNested(-1, null);
    }

    public A addNewResolvedAddress(String ip, String lastLookupTime, Integer ttlSeconds) {
        return this.addToResolvedAddresses(new DNSNameResolverResolvedAddress(ip, lastLookupTime, ttlSeconds));
    }

    public ResolvedAddressesNested<A> addNewResolvedAddressLike(DNSNameResolverResolvedAddress item) {
        return new ResolvedAddressesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A addToResolvedAddresses(DNSNameResolverResolvedAddress ... items) {
        if (this.resolvedAddresses == null) {
            this.resolvedAddresses = new ArrayList();
        }
        for (DNSNameResolverResolvedAddress item : items) {
            DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
            this._visitables.get((Object)"resolvedAddresses").add(builder);
            this.resolvedAddresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToResolvedAddresses(int index, DNSNameResolverResolvedAddress item) {
        if (this.resolvedAddresses == null) {
            this.resolvedAddresses = new ArrayList();
        }
        DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
        if (index < 0 || index >= this.resolvedAddresses.size()) {
            this._visitables.get((Object)"resolvedAddresses").add(builder);
            this.resolvedAddresses.add(builder);
        } else {
            this._visitables.get((Object)"resolvedAddresses").add(builder);
            this.resolvedAddresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public DNSNameResolverResolvedAddress buildFirstResolvedAddress() {
        return this.resolvedAddresses.get(0).build();
    }

    public DNSNameResolverResolvedAddress buildLastResolvedAddress() {
        return this.resolvedAddresses.get(this.resolvedAddresses.size() - 1).build();
    }

    public DNSNameResolverResolvedAddress buildMatchingResolvedAddress(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
        for (DNSNameResolverResolvedAddressBuilder item : this.resolvedAddresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DNSNameResolverResolvedAddress buildResolvedAddress(int index) {
        return this.resolvedAddresses.get(index).build();
    }

    public List<DNSNameResolverResolvedAddress> buildResolvedAddresses() {
        return this.resolvedAddresses != null ? DNSNameResolverResolvedNameFluent.build(this.resolvedAddresses) : null;
    }

    protected void copyInstance(DNSNameResolverResolvedName instance) {
        DNSNameResolverResolvedName dNSNameResolverResolvedName = instance = instance != null ? instance : new DNSNameResolverResolvedName();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withDnsName(instance.getDnsName());
            this.withResolutionFailures(instance.getResolutionFailures());
            this.withResolvedAddresses(instance.getResolvedAddresses());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ResolvedAddressesNested<A> editFirstResolvedAddress() {
        if (this.resolvedAddresses.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "resolvedAddresses"));
        }
        return this.setNewResolvedAddressLike(0, this.buildResolvedAddress(0));
    }

    public ResolvedAddressesNested<A> editLastResolvedAddress() {
        int index = this.resolvedAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "resolvedAddresses"));
        }
        return this.setNewResolvedAddressLike(index, this.buildResolvedAddress(index));
    }

    public ResolvedAddressesNested<A> editMatchingResolvedAddress(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resolvedAddresses.size(); ++i) {
            if (!predicate.test(this.resolvedAddresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "resolvedAddresses"));
        }
        return this.setNewResolvedAddressLike(index, this.buildResolvedAddress(index));
    }

    public ResolvedAddressesNested<A> editResolvedAddress(int index) {
        if (this.resolvedAddresses.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "resolvedAddresses"));
        }
        return this.setNewResolvedAddressLike(index, this.buildResolvedAddress(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSNameResolverResolvedNameFluent that = (DNSNameResolverResolvedNameFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.dnsName, that.dnsName)) {
            return false;
        }
        if (!Objects.equals(this.resolutionFailures, that.resolutionFailures)) {
            return false;
        }
        if (!Objects.equals(this.resolvedAddresses, that.resolvedAddresses)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Integer getResolutionFailures() {
        return this.resolutionFailures;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasDnsName() {
        return this.dnsName != null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingResolvedAddress(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
        for (DNSNameResolverResolvedAddressBuilder item : this.resolvedAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResolutionFailures() {
        return this.resolutionFailures != null;
    }

    public boolean hasResolvedAddresses() {
        return this.resolvedAddresses != null && !this.resolvedAddresses.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.dnsName, this.resolutionFailures, this.resolvedAddresses, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResolvedAddresses(Collection<DNSNameResolverResolvedAddress> items) {
        if (this.resolvedAddresses == null) {
            return (A)((Object)this);
        }
        for (DNSNameResolverResolvedAddress item : items) {
            DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
            this._visitables.get((Object)"resolvedAddresses").remove((Object)builder);
            this.resolvedAddresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResolvedAddresses(DNSNameResolverResolvedAddress ... items) {
        if (this.resolvedAddresses == null) {
            return (A)((Object)this);
        }
        for (DNSNameResolverResolvedAddress item : items) {
            DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
            this._visitables.get((Object)"resolvedAddresses").remove((Object)builder);
            this.resolvedAddresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResolvedAddresses(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
        if (this.resolvedAddresses == null) {
            return (A)((Object)this);
        }
        Iterator<DNSNameResolverResolvedAddressBuilder> each = this.resolvedAddresses.iterator();
        List visitables = this._visitables.get((Object)"resolvedAddresses");
        while (each.hasNext()) {
            DNSNameResolverResolvedAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ResolvedAddressesNested<A> setNewResolvedAddressLike(int index, DNSNameResolverResolvedAddress item) {
        return new ResolvedAddressesNested(index, item);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A setToResolvedAddresses(int index, DNSNameResolverResolvedAddress item) {
        if (this.resolvedAddresses == null) {
            this.resolvedAddresses = new ArrayList();
        }
        DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
        if (index < 0 || index >= this.resolvedAddresses.size()) {
            this._visitables.get((Object)"resolvedAddresses").add(builder);
            this.resolvedAddresses.add(builder);
        } else {
            this._visitables.get((Object)"resolvedAddresses").add(builder);
            this.resolvedAddresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.dnsName != null) {
            sb.append("dnsName:");
            sb.append(this.dnsName);
            sb.append(",");
        }
        if (this.resolutionFailures != null) {
            sb.append("resolutionFailures:");
            sb.append(this.resolutionFailures);
            sb.append(",");
        }
        if (this.resolvedAddresses != null && !this.resolvedAddresses.isEmpty()) {
            sb.append("resolvedAddresses:");
            sb.append(this.resolvedAddresses);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withDnsName(String dnsName) {
        this.dnsName = dnsName;
        return (A)((Object)this);
    }

    public A withResolutionFailures(Integer resolutionFailures) {
        this.resolutionFailures = resolutionFailures;
        return (A)((Object)this);
    }

    public A withResolvedAddresses(List<DNSNameResolverResolvedAddress> resolvedAddresses) {
        if (this.resolvedAddresses != null) {
            this._visitables.get((Object)"resolvedAddresses").clear();
        }
        if (resolvedAddresses != null) {
            this.resolvedAddresses = new ArrayList();
            for (DNSNameResolverResolvedAddress item : resolvedAddresses) {
                this.addToResolvedAddresses(item);
            }
        } else {
            this.resolvedAddresses = null;
        }
        return (A)((Object)this);
    }

    public A withResolvedAddresses(DNSNameResolverResolvedAddress ... resolvedAddresses) {
        if (this.resolvedAddresses != null) {
            this.resolvedAddresses.clear();
            this._visitables.remove((Object)"resolvedAddresses");
        }
        if (resolvedAddresses != null) {
            for (DNSNameResolverResolvedAddress item : resolvedAddresses) {
                this.addToResolvedAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public class ResolvedAddressesNested<N>
    extends DNSNameResolverResolvedAddressFluent<ResolvedAddressesNested<N>>
    implements Nested<N> {
        DNSNameResolverResolvedAddressBuilder builder;
        int index;

        ResolvedAddressesNested(int index, DNSNameResolverResolvedAddress item) {
            this.index = index;
            this.builder = new DNSNameResolverResolvedAddressBuilder(this, item);
        }

        public N and() {
            return (N)DNSNameResolverResolvedNameFluent.this.setToResolvedAddresses(this.index, this.builder.build());
        }

        public N endResolvedAddress() {
            return this.and();
        }
    }
}

