/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev6;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataServicev6;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataServicev6Builder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataServicev6Fluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkGatewayv6;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkGatewayv6Builder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkGatewayv6Fluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkDataRoutev6Fluent<A extends NetworkDataRoutev6Fluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private NetworkGatewayv6Builder gateway;
    private String network;
    private Integer prefix;
    private NetworkDataServicev6Builder services;

    public NetworkDataRoutev6Fluent() {
    }

    public NetworkDataRoutev6Fluent(NetworkDataRoutev6 instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public NetworkGatewayv6 buildGateway() {
        return this.gateway != null ? this.gateway.build() : null;
    }

    public NetworkDataServicev6 buildServices() {
        return this.services != null ? this.services.build() : null;
    }

    protected void copyInstance(NetworkDataRoutev6 instance) {
        NetworkDataRoutev6 networkDataRoutev6 = instance = instance != null ? instance : new NetworkDataRoutev6();
        if (instance != null) {
            this.withGateway(instance.getGateway());
            this.withNetwork(instance.getNetwork());
            this.withPrefix(instance.getPrefix());
            this.withServices(instance.getServices());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public GatewayNested<A> editGateway() {
        return this.withNewGatewayLike(Optional.ofNullable(this.buildGateway()).orElse(null));
    }

    public GatewayNested<A> editOrNewGateway() {
        return this.withNewGatewayLike(Optional.ofNullable(this.buildGateway()).orElse(new NetworkGatewayv6Builder().build()));
    }

    public GatewayNested<A> editOrNewGatewayLike(NetworkGatewayv6 item) {
        return this.withNewGatewayLike(Optional.ofNullable(this.buildGateway()).orElse(item));
    }

    public ServicesNested<A> editOrNewServices() {
        return this.withNewServicesLike(Optional.ofNullable(this.buildServices()).orElse(new NetworkDataServicev6Builder().build()));
    }

    public ServicesNested<A> editOrNewServicesLike(NetworkDataServicev6 item) {
        return this.withNewServicesLike(Optional.ofNullable(this.buildServices()).orElse(item));
    }

    public ServicesNested<A> editServices() {
        return this.withNewServicesLike(Optional.ofNullable(this.buildServices()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDataRoutev6Fluent that = (NetworkDataRoutev6Fluent)((Object)o);
        if (!Objects.equals((Object)this.gateway, (Object)that.gateway)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        if (!Objects.equals((Object)this.services, (Object)that.services)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getNetwork() {
        return this.network;
    }

    public Integer getPrefix() {
        return this.prefix;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasGateway() {
        return this.gateway != null;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public boolean hasServices() {
        return this.services != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gateway, this.network, this.prefix, this.services, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gateway != null) {
            sb.append("gateway:");
            sb.append((Object)this.gateway);
            sb.append(",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network);
            sb.append(",");
        }
        if (this.prefix != null) {
            sb.append("prefix:");
            sb.append(this.prefix);
            sb.append(",");
        }
        if (this.services != null) {
            sb.append("services:");
            sb.append((Object)this.services);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withGateway(NetworkGatewayv6 gateway) {
        this._visitables.remove((Object)"gateway");
        if (gateway != null) {
            this.gateway = new NetworkGatewayv6Builder(gateway);
            this._visitables.get((Object)"gateway").add(this.gateway);
        } else {
            this.gateway = null;
            this._visitables.get((Object)"gateway").remove((Object)this.gateway);
        }
        return (A)((Object)this);
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)((Object)this);
    }

    public GatewayNested<A> withNewGateway() {
        return new GatewayNested(null);
    }

    public A withNewGateway(String fromIPPool, String string) {
        return this.withGateway(new NetworkGatewayv6(fromIPPool, string));
    }

    public GatewayNested<A> withNewGatewayLike(NetworkGatewayv6 item) {
        return new GatewayNested(item);
    }

    public ServicesNested<A> withNewServices() {
        return new ServicesNested(null);
    }

    public ServicesNested<A> withNewServicesLike(NetworkDataServicev6 item) {
        return new ServicesNested(item);
    }

    public A withPrefix(Integer prefix) {
        this.prefix = prefix;
        return (A)((Object)this);
    }

    public A withServices(NetworkDataServicev6 services) {
        this._visitables.remove((Object)"services");
        if (services != null) {
            this.services = new NetworkDataServicev6Builder(services);
            this._visitables.get((Object)"services").add(this.services);
        } else {
            this.services = null;
            this._visitables.get((Object)"services").remove((Object)this.services);
        }
        return (A)((Object)this);
    }

    public class ServicesNested<N>
    extends NetworkDataServicev6Fluent<ServicesNested<N>>
    implements Nested<N> {
        NetworkDataServicev6Builder builder;

        ServicesNested(NetworkDataServicev6 item) {
            this.builder = new NetworkDataServicev6Builder(this, item);
        }

        public N and() {
            return (N)NetworkDataRoutev6Fluent.this.withServices(this.builder.build());
        }

        public N endServices() {
            return this.and();
        }
    }

    public class GatewayNested<N>
    extends NetworkGatewayv6Fluent<GatewayNested<N>>
    implements Nested<N> {
        NetworkGatewayv6Builder builder;

        GatewayNested(NetworkGatewayv6 item) {
            this.builder = new NetworkGatewayv6Builder(this, item);
        }

        public N and() {
            return (N)NetworkDataRoutev6Fluent.this.withGateway(this.builder.build());
        }

        public N endGateway() {
            return this.and();
        }
    }
}

