/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestCondition;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestConditionBuilder;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestConditionFluent;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CredentialsRequestStatusFluent<A extends CredentialsRequestStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<CredentialsRequestConditionBuilder> conditions = new ArrayList();
    private String lastSyncCloudCredsSecretResourceVersion;
    private Long lastSyncGeneration;
    private String lastSyncInfrastructureResourceVersion;
    private String lastSyncTimestamp;
    private Object providerStatus;
    private Boolean provisioned;

    public CredentialsRequestStatusFluent() {
    }

    public CredentialsRequestStatusFluent(CredentialsRequestStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<CredentialsRequestCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (CredentialsRequestCondition item : items) {
            CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(CredentialsRequestCondition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(CredentialsRequestCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (CredentialsRequestCondition item : items) {
            CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, CredentialsRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public CredentialsRequestCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<CredentialsRequestCondition> buildConditions() {
        return this.conditions != null ? CredentialsRequestStatusFluent.build(this.conditions) : null;
    }

    public CredentialsRequestCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public CredentialsRequestCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public CredentialsRequestCondition buildMatchingCondition(Predicate<CredentialsRequestConditionBuilder> predicate) {
        for (CredentialsRequestConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(CredentialsRequestStatus instance) {
        CredentialsRequestStatus credentialsRequestStatus = instance = instance != null ? instance : new CredentialsRequestStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withLastSyncCloudCredsSecretResourceVersion(instance.getLastSyncCloudCredsSecretResourceVersion());
            this.withLastSyncGeneration(instance.getLastSyncGeneration());
            this.withLastSyncInfrastructureResourceVersion(instance.getLastSyncInfrastructureResourceVersion());
            this.withLastSyncTimestamp(instance.getLastSyncTimestamp());
            this.withProviderStatus(instance.getProviderStatus());
            this.withProvisioned(instance.getProvisioned());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<CredentialsRequestConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CredentialsRequestStatusFluent that = (CredentialsRequestStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.lastSyncCloudCredsSecretResourceVersion, that.lastSyncCloudCredsSecretResourceVersion)) {
            return false;
        }
        if (!Objects.equals(this.lastSyncGeneration, that.lastSyncGeneration)) {
            return false;
        }
        if (!Objects.equals(this.lastSyncInfrastructureResourceVersion, that.lastSyncInfrastructureResourceVersion)) {
            return false;
        }
        if (!Objects.equals(this.lastSyncTimestamp, that.lastSyncTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.providerStatus, that.providerStatus)) {
            return false;
        }
        if (!Objects.equals(this.provisioned, that.provisioned)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getLastSyncCloudCredsSecretResourceVersion() {
        return this.lastSyncCloudCredsSecretResourceVersion;
    }

    public Long getLastSyncGeneration() {
        return this.lastSyncGeneration;
    }

    public String getLastSyncInfrastructureResourceVersion() {
        return this.lastSyncInfrastructureResourceVersion;
    }

    public String getLastSyncTimestamp() {
        return this.lastSyncTimestamp;
    }

    public Object getProviderStatus() {
        return this.providerStatus;
    }

    public Boolean getProvisioned() {
        return this.provisioned;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasLastSyncCloudCredsSecretResourceVersion() {
        return this.lastSyncCloudCredsSecretResourceVersion != null;
    }

    public boolean hasLastSyncGeneration() {
        return this.lastSyncGeneration != null;
    }

    public boolean hasLastSyncInfrastructureResourceVersion() {
        return this.lastSyncInfrastructureResourceVersion != null;
    }

    public boolean hasLastSyncTimestamp() {
        return this.lastSyncTimestamp != null;
    }

    public boolean hasMatchingCondition(Predicate<CredentialsRequestConditionBuilder> predicate) {
        for (CredentialsRequestConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasProviderStatus() {
        return this.providerStatus != null;
    }

    public boolean hasProvisioned() {
        return this.provisioned != null;
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.lastSyncCloudCredsSecretResourceVersion, this.lastSyncGeneration, this.lastSyncInfrastructureResourceVersion, this.lastSyncTimestamp, this.providerStatus, this.provisioned, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<CredentialsRequestCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (CredentialsRequestCondition item : items) {
            CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(CredentialsRequestCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (CredentialsRequestCondition item : items) {
            CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<CredentialsRequestConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<CredentialsRequestConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            CredentialsRequestConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, CredentialsRequestCondition item) {
        return new ConditionsNested(index, item);
    }

    public A setToConditions(int index, CredentialsRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        CredentialsRequestConditionBuilder builder = new CredentialsRequestConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.lastSyncCloudCredsSecretResourceVersion != null) {
            sb.append("lastSyncCloudCredsSecretResourceVersion:");
            sb.append(this.lastSyncCloudCredsSecretResourceVersion);
            sb.append(",");
        }
        if (this.lastSyncGeneration != null) {
            sb.append("lastSyncGeneration:");
            sb.append(this.lastSyncGeneration);
            sb.append(",");
        }
        if (this.lastSyncInfrastructureResourceVersion != null) {
            sb.append("lastSyncInfrastructureResourceVersion:");
            sb.append(this.lastSyncInfrastructureResourceVersion);
            sb.append(",");
        }
        if (this.lastSyncTimestamp != null) {
            sb.append("lastSyncTimestamp:");
            sb.append(this.lastSyncTimestamp);
            sb.append(",");
        }
        if (this.providerStatus != null) {
            sb.append("providerStatus:");
            sb.append(this.providerStatus);
            sb.append(",");
        }
        if (this.provisioned != null) {
            sb.append("provisioned:");
            sb.append(this.provisioned);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConditions(List<CredentialsRequestCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (CredentialsRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(CredentialsRequestCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (CredentialsRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withLastSyncCloudCredsSecretResourceVersion(String lastSyncCloudCredsSecretResourceVersion) {
        this.lastSyncCloudCredsSecretResourceVersion = lastSyncCloudCredsSecretResourceVersion;
        return (A)((Object)this);
    }

    public A withLastSyncGeneration(Long lastSyncGeneration) {
        this.lastSyncGeneration = lastSyncGeneration;
        return (A)((Object)this);
    }

    public A withLastSyncInfrastructureResourceVersion(String lastSyncInfrastructureResourceVersion) {
        this.lastSyncInfrastructureResourceVersion = lastSyncInfrastructureResourceVersion;
        return (A)((Object)this);
    }

    public A withLastSyncTimestamp(String lastSyncTimestamp) {
        this.lastSyncTimestamp = lastSyncTimestamp;
        return (A)((Object)this);
    }

    public A withProviderStatus(Object providerStatus) {
        this.providerStatus = providerStatus;
        return (A)((Object)this);
    }

    public A withProvisioned() {
        return this.withProvisioned(true);
    }

    public A withProvisioned(Boolean provisioned) {
        this.provisioned = provisioned;
        return (A)((Object)this);
    }

    public class ConditionsNested<N>
    extends CredentialsRequestConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        CredentialsRequestConditionBuilder builder;
        int index;

        ConditionsNested(int index, CredentialsRequestCondition item) {
            this.index = index;
            this.builder = new CredentialsRequestConditionBuilder(this, item);
        }

        public N and() {
            return (N)CredentialsRequestStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

