/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.AWSProviderSpec;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.StatementEntry;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.StatementEntryBuilder;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.StatementEntryFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSProviderSpecFluent<A extends AWSProviderSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String kind;
    private ArrayList<StatementEntryBuilder> statementEntries = new ArrayList();
    private String stsIAMRoleARN;

    public AWSProviderSpecFluent() {
    }

    public AWSProviderSpecFluent(AWSProviderSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToStatementEntries(Collection<StatementEntry> items) {
        if (this.statementEntries == null) {
            this.statementEntries = new ArrayList();
        }
        for (StatementEntry item : items) {
            StatementEntryBuilder builder = new StatementEntryBuilder(item);
            this._visitables.get((Object)"statementEntries").add(builder);
            this.statementEntries.add(builder);
        }
        return (A)((Object)this);
    }

    public StatementEntriesNested<A> addNewStatementEntry() {
        return new StatementEntriesNested(-1, null);
    }

    public StatementEntriesNested<A> addNewStatementEntryLike(StatementEntry item) {
        return new StatementEntriesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToStatementEntries(StatementEntry ... items) {
        if (this.statementEntries == null) {
            this.statementEntries = new ArrayList();
        }
        for (StatementEntry item : items) {
            StatementEntryBuilder builder = new StatementEntryBuilder(item);
            this._visitables.get((Object)"statementEntries").add(builder);
            this.statementEntries.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToStatementEntries(int index, StatementEntry item) {
        if (this.statementEntries == null) {
            this.statementEntries = new ArrayList();
        }
        StatementEntryBuilder builder = new StatementEntryBuilder(item);
        if (index < 0 || index >= this.statementEntries.size()) {
            this._visitables.get((Object)"statementEntries").add(builder);
            this.statementEntries.add(builder);
        } else {
            this._visitables.get((Object)"statementEntries").add(builder);
            this.statementEntries.add(index, builder);
        }
        return (A)((Object)this);
    }

    public StatementEntry buildFirstStatementEntry() {
        return this.statementEntries.get(0).build();
    }

    public StatementEntry buildLastStatementEntry() {
        return this.statementEntries.get(this.statementEntries.size() - 1).build();
    }

    public StatementEntry buildMatchingStatementEntry(Predicate<StatementEntryBuilder> predicate) {
        for (StatementEntryBuilder item : this.statementEntries) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<StatementEntry> buildStatementEntries() {
        return this.statementEntries != null ? AWSProviderSpecFluent.build(this.statementEntries) : null;
    }

    public StatementEntry buildStatementEntry(int index) {
        return this.statementEntries.get(index).build();
    }

    protected void copyInstance(AWSProviderSpec instance) {
        AWSProviderSpec aWSProviderSpec = instance = instance != null ? instance : new AWSProviderSpec();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withStatementEntries(instance.getStatementEntries());
            this.withStsIAMRoleARN(instance.getStsIAMRoleARN());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public StatementEntriesNested<A> editFirstStatementEntry() {
        if (this.statementEntries.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "statementEntries"));
        }
        return this.setNewStatementEntryLike(0, this.buildStatementEntry(0));
    }

    public StatementEntriesNested<A> editLastStatementEntry() {
        int index = this.statementEntries.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "statementEntries"));
        }
        return this.setNewStatementEntryLike(index, this.buildStatementEntry(index));
    }

    public StatementEntriesNested<A> editMatchingStatementEntry(Predicate<StatementEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.statementEntries.size(); ++i) {
            if (!predicate.test(this.statementEntries.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "statementEntries"));
        }
        return this.setNewStatementEntryLike(index, this.buildStatementEntry(index));
    }

    public StatementEntriesNested<A> editStatementEntry(int index) {
        if (this.statementEntries.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "statementEntries"));
        }
        return this.setNewStatementEntryLike(index, this.buildStatementEntry(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSProviderSpecFluent that = (AWSProviderSpecFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.statementEntries, that.statementEntries)) {
            return false;
        }
        if (!Objects.equals(this.stsIAMRoleARN, that.stsIAMRoleARN)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public String getStsIAMRoleARN() {
        return this.stsIAMRoleARN;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingStatementEntry(Predicate<StatementEntryBuilder> predicate) {
        for (StatementEntryBuilder item : this.statementEntries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStatementEntries() {
        return this.statementEntries != null && !this.statementEntries.isEmpty();
    }

    public boolean hasStsIAMRoleARN() {
        return this.stsIAMRoleARN != null;
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.statementEntries, this.stsIAMRoleARN, this.additionalProperties);
    }

    public A removeAllFromStatementEntries(Collection<StatementEntry> items) {
        if (this.statementEntries == null) {
            return (A)((Object)this);
        }
        for (StatementEntry item : items) {
            StatementEntryBuilder builder = new StatementEntryBuilder(item);
            this._visitables.get((Object)"statementEntries").remove((Object)builder);
            this.statementEntries.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromStatementEntries(StatementEntry ... items) {
        if (this.statementEntries == null) {
            return (A)((Object)this);
        }
        for (StatementEntry item : items) {
            StatementEntryBuilder builder = new StatementEntryBuilder(item);
            this._visitables.get((Object)"statementEntries").remove((Object)builder);
            this.statementEntries.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromStatementEntries(Predicate<StatementEntryBuilder> predicate) {
        if (this.statementEntries == null) {
            return (A)((Object)this);
        }
        Iterator<StatementEntryBuilder> each = this.statementEntries.iterator();
        List visitables = this._visitables.get((Object)"statementEntries");
        while (each.hasNext()) {
            StatementEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public StatementEntriesNested<A> setNewStatementEntryLike(int index, StatementEntry item) {
        return new StatementEntriesNested(index, item);
    }

    public A setToStatementEntries(int index, StatementEntry item) {
        if (this.statementEntries == null) {
            this.statementEntries = new ArrayList();
        }
        StatementEntryBuilder builder = new StatementEntryBuilder(item);
        if (index < 0 || index >= this.statementEntries.size()) {
            this._visitables.get((Object)"statementEntries").add(builder);
            this.statementEntries.add(builder);
        } else {
            this._visitables.get((Object)"statementEntries").add(builder);
            this.statementEntries.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.statementEntries != null && !this.statementEntries.isEmpty()) {
            sb.append("statementEntries:");
            sb.append(this.statementEntries);
            sb.append(",");
        }
        if (this.stsIAMRoleARN != null) {
            sb.append("stsIAMRoleARN:");
            sb.append(this.stsIAMRoleARN);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withStatementEntries(List<StatementEntry> statementEntries) {
        if (this.statementEntries != null) {
            this._visitables.get((Object)"statementEntries").clear();
        }
        if (statementEntries != null) {
            this.statementEntries = new ArrayList();
            for (StatementEntry item : statementEntries) {
                this.addToStatementEntries(item);
            }
        } else {
            this.statementEntries = null;
        }
        return (A)((Object)this);
    }

    public A withStatementEntries(StatementEntry ... statementEntries) {
        if (this.statementEntries != null) {
            this.statementEntries.clear();
            this._visitables.remove((Object)"statementEntries");
        }
        if (statementEntries != null) {
            for (StatementEntry item : statementEntries) {
                this.addToStatementEntries(item);
            }
        }
        return (A)((Object)this);
    }

    public A withStsIAMRoleARN(String stsIAMRoleARN) {
        this.stsIAMRoleARN = stsIAMRoleARN;
        return (A)((Object)this);
    }

    public class StatementEntriesNested<N>
    extends StatementEntryFluent<StatementEntriesNested<N>>
    implements Nested<N> {
        StatementEntryBuilder builder;
        int index;

        StatementEntriesNested(int index, StatementEntry item) {
            this.index = index;
            this.builder = new StatementEntryBuilder(this, item);
        }

        public N and() {
            return (N)AWSProviderSpecFluent.this.setToStatementEntries(this.index, this.builder.build());
        }

        public N endStatementEntry() {
            return this.and();
        }
    }
}

