package io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DNSNameResolverResolvedNameFluent<A extends DNSNameResolverResolvedNameFluent<A>> extends BaseFluent<A>{
  public DNSNameResolverResolvedNameFluent() {
  }
  
  public DNSNameResolverResolvedNameFluent(DNSNameResolverResolvedName instance) {
    this.copyInstance(instance);
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private String dnsName;
  private Integer resolutionFailures;
  private ArrayList<DNSNameResolverResolvedAddressBuilder> resolvedAddresses = new ArrayList<DNSNameResolverResolvedAddressBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DNSNameResolverResolvedName instance) {
    instance = (instance != null ? instance : new DNSNameResolverResolvedName());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withDnsName(instance.getDnsName());
          this.withResolutionFailures(instance.getResolutionFailures());
          this.withResolvedAddresses(instance.getResolvedAddresses());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public String getDnsName() {
    return this.dnsName;
  }
  
  public A withDnsName(String dnsName) {
    this.dnsName = dnsName;
    return (A) this;
  }
  
  public boolean hasDnsName() {
    return this.dnsName != null;
  }
  
  public Integer getResolutionFailures() {
    return this.resolutionFailures;
  }
  
  public A withResolutionFailures(Integer resolutionFailures) {
    this.resolutionFailures = resolutionFailures;
    return (A) this;
  }
  
  public boolean hasResolutionFailures() {
    return this.resolutionFailures != null;
  }
  
  public A addToResolvedAddresses(int index,DNSNameResolverResolvedAddress item) {
    if (this.resolvedAddresses == null) {this.resolvedAddresses = new ArrayList<DNSNameResolverResolvedAddressBuilder>();}
    DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
    if (index < 0 || index >= resolvedAddresses.size()) { _visitables.get("resolvedAddresses").add(builder); resolvedAddresses.add(builder); } else { _visitables.get("resolvedAddresses").add(index, builder); resolvedAddresses.add(index, builder);}
    return (A)this;
  }
  
  public A setToResolvedAddresses(int index,DNSNameResolverResolvedAddress item) {
    if (this.resolvedAddresses == null) {this.resolvedAddresses = new ArrayList<DNSNameResolverResolvedAddressBuilder>();}
    DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
    if (index < 0 || index >= resolvedAddresses.size()) { _visitables.get("resolvedAddresses").add(builder); resolvedAddresses.add(builder); } else { _visitables.get("resolvedAddresses").set(index, builder); resolvedAddresses.set(index, builder);}
    return (A)this;
  }
  
  public A addToResolvedAddresses(io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedAddress... items) {
    if (this.resolvedAddresses == null) {this.resolvedAddresses = new ArrayList<DNSNameResolverResolvedAddressBuilder>();}
    for (DNSNameResolverResolvedAddress item : items) {DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);_visitables.get("resolvedAddresses").add(builder);this.resolvedAddresses.add(builder);} return (A)this;
  }
  
  public A addAllToResolvedAddresses(Collection<DNSNameResolverResolvedAddress> items) {
    if (this.resolvedAddresses == null) {this.resolvedAddresses = new ArrayList<DNSNameResolverResolvedAddressBuilder>();}
    for (DNSNameResolverResolvedAddress item : items) {DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);_visitables.get("resolvedAddresses").add(builder);this.resolvedAddresses.add(builder);} return (A)this;
  }
  
  public A removeFromResolvedAddresses(io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedAddress... items) {
    if (this.resolvedAddresses == null) return (A)this;
    for (DNSNameResolverResolvedAddress item : items) {DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);_visitables.get("resolvedAddresses").remove(builder); this.resolvedAddresses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResolvedAddresses(Collection<DNSNameResolverResolvedAddress> items) {
    if (this.resolvedAddresses == null) return (A)this;
    for (DNSNameResolverResolvedAddress item : items) {DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);_visitables.get("resolvedAddresses").remove(builder); this.resolvedAddresses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResolvedAddresses(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
    if (resolvedAddresses == null) return (A) this;
    final Iterator<DNSNameResolverResolvedAddressBuilder> each = resolvedAddresses.iterator();
    final List visitables = _visitables.get("resolvedAddresses");
    while (each.hasNext()) {
      DNSNameResolverResolvedAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DNSNameResolverResolvedAddress> buildResolvedAddresses() {
    return this.resolvedAddresses != null ? build(resolvedAddresses) : null;
  }
  
  public DNSNameResolverResolvedAddress buildResolvedAddress(int index) {
    return this.resolvedAddresses.get(index).build();
  }
  
  public DNSNameResolverResolvedAddress buildFirstResolvedAddress() {
    return this.resolvedAddresses.get(0).build();
  }
  
  public DNSNameResolverResolvedAddress buildLastResolvedAddress() {
    return this.resolvedAddresses.get(resolvedAddresses.size() - 1).build();
  }
  
  public DNSNameResolverResolvedAddress buildMatchingResolvedAddress(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
      for (DNSNameResolverResolvedAddressBuilder item : resolvedAddresses) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResolvedAddress(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
      for (DNSNameResolverResolvedAddressBuilder item : resolvedAddresses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResolvedAddresses(List<DNSNameResolverResolvedAddress> resolvedAddresses) {
    if (this.resolvedAddresses != null) {
      this._visitables.get("resolvedAddresses").clear();
    }
    if (resolvedAddresses != null) {
        this.resolvedAddresses = new ArrayList();
        for (DNSNameResolverResolvedAddress item : resolvedAddresses) {
          this.addToResolvedAddresses(item);
        }
    } else {
      this.resolvedAddresses = null;
    }
    return (A) this;
  }
  
  public A withResolvedAddresses(io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedAddress... resolvedAddresses) {
    if (this.resolvedAddresses != null) {
        this.resolvedAddresses.clear();
        _visitables.remove("resolvedAddresses");
    }
    if (resolvedAddresses != null) {
      for (DNSNameResolverResolvedAddress item : resolvedAddresses) {
        this.addToResolvedAddresses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResolvedAddresses() {
    return this.resolvedAddresses != null && !this.resolvedAddresses.isEmpty();
  }
  
  public A addNewResolvedAddress(String ip,String lastLookupTime,Integer ttlSeconds) {
    return (A)addToResolvedAddresses(new DNSNameResolverResolvedAddress(ip, lastLookupTime, ttlSeconds));
  }
  
  public ResolvedAddressesNested<A> addNewResolvedAddress() {
    return new ResolvedAddressesNested(-1, null);
  }
  
  public ResolvedAddressesNested<A> addNewResolvedAddressLike(DNSNameResolverResolvedAddress item) {
    return new ResolvedAddressesNested(-1, item);
  }
  
  public ResolvedAddressesNested<A> setNewResolvedAddressLike(int index,DNSNameResolverResolvedAddress item) {
    return new ResolvedAddressesNested(index, item);
  }
  
  public ResolvedAddressesNested<A> editResolvedAddress(int index) {
    if (resolvedAddresses.size() <= index) throw new RuntimeException("Can't edit resolvedAddresses. Index exceeds size.");
    return setNewResolvedAddressLike(index, buildResolvedAddress(index));
  }
  
  public ResolvedAddressesNested<A> editFirstResolvedAddress() {
    if (resolvedAddresses.size() == 0) throw new RuntimeException("Can't edit first resolvedAddresses. The list is empty.");
    return setNewResolvedAddressLike(0, buildResolvedAddress(0));
  }
  
  public ResolvedAddressesNested<A> editLastResolvedAddress() {
    int index = resolvedAddresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resolvedAddresses. The list is empty.");
    return setNewResolvedAddressLike(index, buildResolvedAddress(index));
  }
  
  public ResolvedAddressesNested<A> editMatchingResolvedAddress(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resolvedAddresses.size();i++) { 
    if (predicate.test(resolvedAddresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resolvedAddresses. No match found.");
    return setNewResolvedAddressLike(index, buildResolvedAddress(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSNameResolverResolvedNameFluent that = (DNSNameResolverResolvedNameFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(dnsName, that.dnsName)) return false;
    if (!java.util.Objects.equals(resolutionFailures, that.resolutionFailures)) return false;
    if (!java.util.Objects.equals(resolvedAddresses, that.resolvedAddresses)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  dnsName,  resolutionFailures,  resolvedAddresses,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (dnsName != null) { sb.append("dnsName:"); sb.append(dnsName + ","); }
    if (resolutionFailures != null) { sb.append("resolutionFailures:"); sb.append(resolutionFailures + ","); }
    if (resolvedAddresses != null && !resolvedAddresses.isEmpty()) { sb.append("resolvedAddresses:"); sb.append(resolvedAddresses + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResolvedAddressesNested<N> extends DNSNameResolverResolvedAddressFluent<ResolvedAddressesNested<N>> implements Nested<N>{
    ResolvedAddressesNested(int index,DNSNameResolverResolvedAddress item) {
      this.index = index;
      this.builder = new DNSNameResolverResolvedAddressBuilder(this, item);
    }
    DNSNameResolverResolvedAddressBuilder builder;
    int index;
    
    public N and() {
      return (N) DNSNameResolverResolvedNameFluent.this.setToResolvedAddresses(index,builder.build());
    }
    
    public N endResolvedAddress() {
      return and();
    }
    
  
  }

}