package io.fabric8.openshift.api.model.miscellaneous.network.cloud.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CloudPrivateIPConfigBuilder extends CloudPrivateIPConfigFluent<CloudPrivateIPConfigBuilder> implements VisitableBuilder<CloudPrivateIPConfig,CloudPrivateIPConfigBuilder>{
  public CloudPrivateIPConfigBuilder() {
    this(new CloudPrivateIPConfig());
  }
  
  public CloudPrivateIPConfigBuilder(CloudPrivateIPConfigFluent<?> fluent) {
    this(fluent, new CloudPrivateIPConfig());
  }
  
  public CloudPrivateIPConfigBuilder(CloudPrivateIPConfigFluent<?> fluent,CloudPrivateIPConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CloudPrivateIPConfigBuilder(CloudPrivateIPConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CloudPrivateIPConfigFluent<?> fluent;
  
  public CloudPrivateIPConfig build() {
    CloudPrivateIPConfig buildable = new CloudPrivateIPConfig(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}