package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class Metal3ClusterSpecFluent<A extends Metal3ClusterSpecFluent<A>> extends BaseFluent<A>{
  public Metal3ClusterSpecFluent() {
  }
  
  public Metal3ClusterSpecFluent(Metal3ClusterSpec instance) {
    this.copyInstance(instance);
  }
  private APIEndpointBuilder controlPlaneEndpoint;
  private Boolean noCloudProvider;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Metal3ClusterSpec instance) {
    instance = (instance != null ? instance : new Metal3ClusterSpec());
    if (instance != null) {
          this.withControlPlaneEndpoint(instance.getControlPlaneEndpoint());
          this.withNoCloudProvider(instance.getNoCloudProvider());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public APIEndpoint buildControlPlaneEndpoint() {
    return this.controlPlaneEndpoint != null ? this.controlPlaneEndpoint.build() : null;
  }
  
  public A withControlPlaneEndpoint(APIEndpoint controlPlaneEndpoint) {
    this._visitables.remove("controlPlaneEndpoint");
    if (controlPlaneEndpoint != null) {
        this.controlPlaneEndpoint = new APIEndpointBuilder(controlPlaneEndpoint);
        this._visitables.get("controlPlaneEndpoint").add(this.controlPlaneEndpoint);
    } else {
        this.controlPlaneEndpoint = null;
        this._visitables.get("controlPlaneEndpoint").remove(this.controlPlaneEndpoint);
    }
    return (A) this;
  }
  
  public boolean hasControlPlaneEndpoint() {
    return this.controlPlaneEndpoint != null;
  }
  
  public A withNewControlPlaneEndpoint(String host,Integer port) {
    return (A)withControlPlaneEndpoint(new APIEndpoint(host, port));
  }
  
  public ControlPlaneEndpointNested<A> withNewControlPlaneEndpoint() {
    return new ControlPlaneEndpointNested(null);
  }
  
  public ControlPlaneEndpointNested<A> withNewControlPlaneEndpointLike(APIEndpoint item) {
    return new ControlPlaneEndpointNested(item);
  }
  
  public ControlPlaneEndpointNested<A> editControlPlaneEndpoint() {
    return withNewControlPlaneEndpointLike(java.util.Optional.ofNullable(buildControlPlaneEndpoint()).orElse(null));
  }
  
  public ControlPlaneEndpointNested<A> editOrNewControlPlaneEndpoint() {
    return withNewControlPlaneEndpointLike(java.util.Optional.ofNullable(buildControlPlaneEndpoint()).orElse(new APIEndpointBuilder().build()));
  }
  
  public ControlPlaneEndpointNested<A> editOrNewControlPlaneEndpointLike(APIEndpoint item) {
    return withNewControlPlaneEndpointLike(java.util.Optional.ofNullable(buildControlPlaneEndpoint()).orElse(item));
  }
  
  public Boolean getNoCloudProvider() {
    return this.noCloudProvider;
  }
  
  public A withNoCloudProvider(Boolean noCloudProvider) {
    this.noCloudProvider = noCloudProvider;
    return (A) this;
  }
  
  public boolean hasNoCloudProvider() {
    return this.noCloudProvider != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Metal3ClusterSpecFluent that = (Metal3ClusterSpecFluent) o;
    if (!java.util.Objects.equals(controlPlaneEndpoint, that.controlPlaneEndpoint)) return false;
    if (!java.util.Objects.equals(noCloudProvider, that.noCloudProvider)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(controlPlaneEndpoint,  noCloudProvider,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (controlPlaneEndpoint != null) { sb.append("controlPlaneEndpoint:"); sb.append(controlPlaneEndpoint + ","); }
    if (noCloudProvider != null) { sb.append("noCloudProvider:"); sb.append(noCloudProvider + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withNoCloudProvider() {
    return withNoCloudProvider(true);
  }
  public class ControlPlaneEndpointNested<N> extends APIEndpointFluent<ControlPlaneEndpointNested<N>> implements Nested<N>{
    ControlPlaneEndpointNested(APIEndpoint item) {
      this.builder = new APIEndpointBuilder(this, item);
    }
    APIEndpointBuilder builder;
    
    public N and() {
      return (N) Metal3ClusterSpecFluent.this.withControlPlaneEndpoint(builder.build());
    }
    
    public N endControlPlaneEndpoint() {
      return and();
    }
    
  
  }

}