package io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkStatusFluent<A extends NetworkStatusFluent<A>> extends BaseFluent<A>{
  public NetworkStatusFluent() {
  }
  
  public NetworkStatusFluent(NetworkStatus instance) {
    this.copyInstance(instance);
  }
  private Boolean _default;
  private DeviceInfoBuilder deviceInfo;
  private DNSBuilder dns;
  private List<String> gateway = new ArrayList<String>();
  private String _interface;
  private List<String> ips = new ArrayList<String>();
  private String mac;
  private Integer mtu;
  private String name;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkStatus instance) {
    instance = (instance != null ? instance : new NetworkStatus());
    if (instance != null) {
          this.withDefault(instance.getDefault());
          this.withDeviceInfo(instance.getDeviceInfo());
          this.withDns(instance.getDns());
          this.withGateway(instance.getGateway());
          this.withInterface(instance.getInterface());
          this.withIps(instance.getIps());
          this.withMac(instance.getMac());
          this.withMtu(instance.getMtu());
          this.withName(instance.getName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getDefault() {
    return this._default;
  }
  
  public A withDefault(Boolean _default) {
    this._default = _default;
    return (A) this;
  }
  
  public boolean hasDefault() {
    return this._default != null;
  }
  
  public DeviceInfo buildDeviceInfo() {
    return this.deviceInfo != null ? this.deviceInfo.build() : null;
  }
  
  public A withDeviceInfo(DeviceInfo deviceInfo) {
    this._visitables.remove("deviceInfo");
    if (deviceInfo != null) {
        this.deviceInfo = new DeviceInfoBuilder(deviceInfo);
        this._visitables.get("deviceInfo").add(this.deviceInfo);
    } else {
        this.deviceInfo = null;
        this._visitables.get("deviceInfo").remove(this.deviceInfo);
    }
    return (A) this;
  }
  
  public boolean hasDeviceInfo() {
    return this.deviceInfo != null;
  }
  
  public DeviceInfoNested<A> withNewDeviceInfo() {
    return new DeviceInfoNested(null);
  }
  
  public DeviceInfoNested<A> withNewDeviceInfoLike(DeviceInfo item) {
    return new DeviceInfoNested(item);
  }
  
  public DeviceInfoNested<A> editDeviceInfo() {
    return withNewDeviceInfoLike(java.util.Optional.ofNullable(buildDeviceInfo()).orElse(null));
  }
  
  public DeviceInfoNested<A> editOrNewDeviceInfo() {
    return withNewDeviceInfoLike(java.util.Optional.ofNullable(buildDeviceInfo()).orElse(new DeviceInfoBuilder().build()));
  }
  
  public DeviceInfoNested<A> editOrNewDeviceInfoLike(DeviceInfo item) {
    return withNewDeviceInfoLike(java.util.Optional.ofNullable(buildDeviceInfo()).orElse(item));
  }
  
  public DNS buildDns() {
    return this.dns != null ? this.dns.build() : null;
  }
  
  public A withDns(DNS dns) {
    this._visitables.remove("dns");
    if (dns != null) {
        this.dns = new DNSBuilder(dns);
        this._visitables.get("dns").add(this.dns);
    } else {
        this.dns = null;
        this._visitables.get("dns").remove(this.dns);
    }
    return (A) this;
  }
  
  public boolean hasDns() {
    return this.dns != null;
  }
  
  public DnsNested<A> withNewDns() {
    return new DnsNested(null);
  }
  
  public DnsNested<A> withNewDnsLike(DNS item) {
    return new DnsNested(item);
  }
  
  public DnsNested<A> editDns() {
    return withNewDnsLike(java.util.Optional.ofNullable(buildDns()).orElse(null));
  }
  
  public DnsNested<A> editOrNewDns() {
    return withNewDnsLike(java.util.Optional.ofNullable(buildDns()).orElse(new DNSBuilder().build()));
  }
  
  public DnsNested<A> editOrNewDnsLike(DNS item) {
    return withNewDnsLike(java.util.Optional.ofNullable(buildDns()).orElse(item));
  }
  
  public A addToGateway(int index,String item) {
    if (this.gateway == null) {this.gateway = new ArrayList<String>();}
    this.gateway.add(index, item);
    return (A)this;
  }
  
  public A setToGateway(int index,String item) {
    if (this.gateway == null) {this.gateway = new ArrayList<String>();}
    this.gateway.set(index, item); return (A)this;
  }
  
  public A addToGateway(java.lang.String... items) {
    if (this.gateway == null) {this.gateway = new ArrayList<String>();}
    for (String item : items) {this.gateway.add(item);} return (A)this;
  }
  
  public A addAllToGateway(Collection<String> items) {
    if (this.gateway == null) {this.gateway = new ArrayList<String>();}
    for (String item : items) {this.gateway.add(item);} return (A)this;
  }
  
  public A removeFromGateway(java.lang.String... items) {
    if (this.gateway == null) return (A)this;
    for (String item : items) { this.gateway.remove(item);} return (A)this;
  }
  
  public A removeAllFromGateway(Collection<String> items) {
    if (this.gateway == null) return (A)this;
    for (String item : items) { this.gateway.remove(item);} return (A)this;
  }
  
  public List<String> getGateway() {
    return this.gateway;
  }
  
  public String getGateway(int index) {
    return this.gateway.get(index);
  }
  
  public String getFirstGateway() {
    return this.gateway.get(0);
  }
  
  public String getLastGateway() {
    return this.gateway.get(gateway.size() - 1);
  }
  
  public String getMatchingGateway(Predicate<String> predicate) {
      for (String item : gateway) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingGateway(Predicate<String> predicate) {
      for (String item : gateway) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGateway(List<String> gateway) {
    if (gateway != null) {
        this.gateway = new ArrayList();
        for (String item : gateway) {
          this.addToGateway(item);
        }
    } else {
      this.gateway = null;
    }
    return (A) this;
  }
  
  public A withGateway(java.lang.String... gateway) {
    if (this.gateway != null) {
        this.gateway.clear();
        _visitables.remove("gateway");
    }
    if (gateway != null) {
      for (String item : gateway) {
        this.addToGateway(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGateway() {
    return this.gateway != null && !this.gateway.isEmpty();
  }
  
  public String getInterface() {
    return this._interface;
  }
  
  public A withInterface(String _interface) {
    this._interface = _interface;
    return (A) this;
  }
  
  public boolean hasInterface() {
    return this._interface != null;
  }
  
  public A addToIps(int index,String item) {
    if (this.ips == null) {this.ips = new ArrayList<String>();}
    this.ips.add(index, item);
    return (A)this;
  }
  
  public A setToIps(int index,String item) {
    if (this.ips == null) {this.ips = new ArrayList<String>();}
    this.ips.set(index, item); return (A)this;
  }
  
  public A addToIps(java.lang.String... items) {
    if (this.ips == null) {this.ips = new ArrayList<String>();}
    for (String item : items) {this.ips.add(item);} return (A)this;
  }
  
  public A addAllToIps(Collection<String> items) {
    if (this.ips == null) {this.ips = new ArrayList<String>();}
    for (String item : items) {this.ips.add(item);} return (A)this;
  }
  
  public A removeFromIps(java.lang.String... items) {
    if (this.ips == null) return (A)this;
    for (String item : items) { this.ips.remove(item);} return (A)this;
  }
  
  public A removeAllFromIps(Collection<String> items) {
    if (this.ips == null) return (A)this;
    for (String item : items) { this.ips.remove(item);} return (A)this;
  }
  
  public List<String> getIps() {
    return this.ips;
  }
  
  public String getIp(int index) {
    return this.ips.get(index);
  }
  
  public String getFirstIp() {
    return this.ips.get(0);
  }
  
  public String getLastIp() {
    return this.ips.get(ips.size() - 1);
  }
  
  public String getMatchingIp(Predicate<String> predicate) {
      for (String item : ips) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingIp(Predicate<String> predicate) {
      for (String item : ips) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIps(List<String> ips) {
    if (ips != null) {
        this.ips = new ArrayList();
        for (String item : ips) {
          this.addToIps(item);
        }
    } else {
      this.ips = null;
    }
    return (A) this;
  }
  
  public A withIps(java.lang.String... ips) {
    if (this.ips != null) {
        this.ips.clear();
        _visitables.remove("ips");
    }
    if (ips != null) {
      for (String item : ips) {
        this.addToIps(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIps() {
    return this.ips != null && !this.ips.isEmpty();
  }
  
  public String getMac() {
    return this.mac;
  }
  
  public A withMac(String mac) {
    this.mac = mac;
    return (A) this;
  }
  
  public boolean hasMac() {
    return this.mac != null;
  }
  
  public Integer getMtu() {
    return this.mtu;
  }
  
  public A withMtu(Integer mtu) {
    this.mtu = mtu;
    return (A) this;
  }
  
  public boolean hasMtu() {
    return this.mtu != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkStatusFluent that = (NetworkStatusFluent) o;
    if (!java.util.Objects.equals(_default, that._default)) return false;
    if (!java.util.Objects.equals(deviceInfo, that.deviceInfo)) return false;
    if (!java.util.Objects.equals(dns, that.dns)) return false;
    if (!java.util.Objects.equals(gateway, that.gateway)) return false;
    if (!java.util.Objects.equals(_interface, that._interface)) return false;
    if (!java.util.Objects.equals(ips, that.ips)) return false;
    if (!java.util.Objects.equals(mac, that.mac)) return false;
    if (!java.util.Objects.equals(mtu, that.mtu)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(_default,  deviceInfo,  dns,  gateway,  _interface,  ips,  mac,  mtu,  name,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (_default != null) { sb.append("_default:"); sb.append(_default + ","); }
    if (deviceInfo != null) { sb.append("deviceInfo:"); sb.append(deviceInfo + ","); }
    if (dns != null) { sb.append("dns:"); sb.append(dns + ","); }
    if (gateway != null && !gateway.isEmpty()) { sb.append("gateway:"); sb.append(gateway + ","); }
    if (_interface != null) { sb.append("_interface:"); sb.append(_interface + ","); }
    if (ips != null && !ips.isEmpty()) { sb.append("ips:"); sb.append(ips + ","); }
    if (mac != null) { sb.append("mac:"); sb.append(mac + ","); }
    if (mtu != null) { sb.append("mtu:"); sb.append(mtu + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDefault() {
    return withDefault(true);
  }
  public class DeviceInfoNested<N> extends DeviceInfoFluent<DeviceInfoNested<N>> implements Nested<N>{
    DeviceInfoNested(DeviceInfo item) {
      this.builder = new DeviceInfoBuilder(this, item);
    }
    DeviceInfoBuilder builder;
    
    public N and() {
      return (N) NetworkStatusFluent.this.withDeviceInfo(builder.build());
    }
    
    public N endDeviceInfo() {
      return and();
    }
    
  
  }
  public class DnsNested<N> extends DNSFluent<DnsNested<N>> implements Nested<N>{
    DnsNested(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSBuilder builder;
    
    public N and() {
      return (N) NetworkStatusFluent.this.withDns(builder.build());
    }
    
    public N endDns() {
      return and();
    }
    
  
  }

}