package io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DeviceInfoFluent<A extends DeviceInfoFluent<A>> extends BaseFluent<A>{
  public DeviceInfoFluent() {
  }
  
  public DeviceInfoFluent(DeviceInfo instance) {
    this.copyInstance(instance);
  }
  private MemifDeviceBuilder memif;
  private PciDeviceBuilder pci;
  private String type;
  private VdpaDeviceBuilder vdpa;
  private String version;
  private VhostDeviceBuilder vhostUser;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DeviceInfo instance) {
    instance = (instance != null ? instance : new DeviceInfo());
    if (instance != null) {
          this.withMemif(instance.getMemif());
          this.withPci(instance.getPci());
          this.withType(instance.getType());
          this.withVdpa(instance.getVdpa());
          this.withVersion(instance.getVersion());
          this.withVhostUser(instance.getVhostUser());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public MemifDevice buildMemif() {
    return this.memif != null ? this.memif.build() : null;
  }
  
  public A withMemif(MemifDevice memif) {
    this._visitables.remove("memif");
    if (memif != null) {
        this.memif = new MemifDeviceBuilder(memif);
        this._visitables.get("memif").add(this.memif);
    } else {
        this.memif = null;
        this._visitables.get("memif").remove(this.memif);
    }
    return (A) this;
  }
  
  public boolean hasMemif() {
    return this.memif != null;
  }
  
  public A withNewMemif(String mode,String path,String role) {
    return (A)withMemif(new MemifDevice(mode, path, role));
  }
  
  public MemifNested<A> withNewMemif() {
    return new MemifNested(null);
  }
  
  public MemifNested<A> withNewMemifLike(MemifDevice item) {
    return new MemifNested(item);
  }
  
  public MemifNested<A> editMemif() {
    return withNewMemifLike(java.util.Optional.ofNullable(buildMemif()).orElse(null));
  }
  
  public MemifNested<A> editOrNewMemif() {
    return withNewMemifLike(java.util.Optional.ofNullable(buildMemif()).orElse(new MemifDeviceBuilder().build()));
  }
  
  public MemifNested<A> editOrNewMemifLike(MemifDevice item) {
    return withNewMemifLike(java.util.Optional.ofNullable(buildMemif()).orElse(item));
  }
  
  public PciDevice buildPci() {
    return this.pci != null ? this.pci.build() : null;
  }
  
  public A withPci(PciDevice pci) {
    this._visitables.remove("pci");
    if (pci != null) {
        this.pci = new PciDeviceBuilder(pci);
        this._visitables.get("pci").add(this.pci);
    } else {
        this.pci = null;
        this._visitables.get("pci").remove(this.pci);
    }
    return (A) this;
  }
  
  public boolean hasPci() {
    return this.pci != null;
  }
  
  public A withNewPci(String pciAddress,String pfPciAddress,String rdmaDevice,String representorDevice,String vhostNet) {
    return (A)withPci(new PciDevice(pciAddress, pfPciAddress, rdmaDevice, representorDevice, vhostNet));
  }
  
  public PciNested<A> withNewPci() {
    return new PciNested(null);
  }
  
  public PciNested<A> withNewPciLike(PciDevice item) {
    return new PciNested(item);
  }
  
  public PciNested<A> editPci() {
    return withNewPciLike(java.util.Optional.ofNullable(buildPci()).orElse(null));
  }
  
  public PciNested<A> editOrNewPci() {
    return withNewPciLike(java.util.Optional.ofNullable(buildPci()).orElse(new PciDeviceBuilder().build()));
  }
  
  public PciNested<A> editOrNewPciLike(PciDevice item) {
    return withNewPciLike(java.util.Optional.ofNullable(buildPci()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public VdpaDevice buildVdpa() {
    return this.vdpa != null ? this.vdpa.build() : null;
  }
  
  public A withVdpa(VdpaDevice vdpa) {
    this._visitables.remove("vdpa");
    if (vdpa != null) {
        this.vdpa = new VdpaDeviceBuilder(vdpa);
        this._visitables.get("vdpa").add(this.vdpa);
    } else {
        this.vdpa = null;
        this._visitables.get("vdpa").remove(this.vdpa);
    }
    return (A) this;
  }
  
  public boolean hasVdpa() {
    return this.vdpa != null;
  }
  
  public VdpaNested<A> withNewVdpa() {
    return new VdpaNested(null);
  }
  
  public VdpaNested<A> withNewVdpaLike(VdpaDevice item) {
    return new VdpaNested(item);
  }
  
  public VdpaNested<A> editVdpa() {
    return withNewVdpaLike(java.util.Optional.ofNullable(buildVdpa()).orElse(null));
  }
  
  public VdpaNested<A> editOrNewVdpa() {
    return withNewVdpaLike(java.util.Optional.ofNullable(buildVdpa()).orElse(new VdpaDeviceBuilder().build()));
  }
  
  public VdpaNested<A> editOrNewVdpaLike(VdpaDevice item) {
    return withNewVdpaLike(java.util.Optional.ofNullable(buildVdpa()).orElse(item));
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public VhostDevice buildVhostUser() {
    return this.vhostUser != null ? this.vhostUser.build() : null;
  }
  
  public A withVhostUser(VhostDevice vhostUser) {
    this._visitables.remove("vhostUser");
    if (vhostUser != null) {
        this.vhostUser = new VhostDeviceBuilder(vhostUser);
        this._visitables.get("vhostUser").add(this.vhostUser);
    } else {
        this.vhostUser = null;
        this._visitables.get("vhostUser").remove(this.vhostUser);
    }
    return (A) this;
  }
  
  public boolean hasVhostUser() {
    return this.vhostUser != null;
  }
  
  public A withNewVhostUser(String mode,String path) {
    return (A)withVhostUser(new VhostDevice(mode, path));
  }
  
  public VhostUserNested<A> withNewVhostUser() {
    return new VhostUserNested(null);
  }
  
  public VhostUserNested<A> withNewVhostUserLike(VhostDevice item) {
    return new VhostUserNested(item);
  }
  
  public VhostUserNested<A> editVhostUser() {
    return withNewVhostUserLike(java.util.Optional.ofNullable(buildVhostUser()).orElse(null));
  }
  
  public VhostUserNested<A> editOrNewVhostUser() {
    return withNewVhostUserLike(java.util.Optional.ofNullable(buildVhostUser()).orElse(new VhostDeviceBuilder().build()));
  }
  
  public VhostUserNested<A> editOrNewVhostUserLike(VhostDevice item) {
    return withNewVhostUserLike(java.util.Optional.ofNullable(buildVhostUser()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeviceInfoFluent that = (DeviceInfoFluent) o;
    if (!java.util.Objects.equals(memif, that.memif)) return false;
    if (!java.util.Objects.equals(pci, that.pci)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(vdpa, that.vdpa)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(vhostUser, that.vhostUser)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(memif,  pci,  type,  vdpa,  version,  vhostUser,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (memif != null) { sb.append("memif:"); sb.append(memif + ","); }
    if (pci != null) { sb.append("pci:"); sb.append(pci + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (vdpa != null) { sb.append("vdpa:"); sb.append(vdpa + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (vhostUser != null) { sb.append("vhostUser:"); sb.append(vhostUser + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MemifNested<N> extends MemifDeviceFluent<MemifNested<N>> implements Nested<N>{
    MemifNested(MemifDevice item) {
      this.builder = new MemifDeviceBuilder(this, item);
    }
    MemifDeviceBuilder builder;
    
    public N and() {
      return (N) DeviceInfoFluent.this.withMemif(builder.build());
    }
    
    public N endMemif() {
      return and();
    }
    
  
  }
  public class PciNested<N> extends PciDeviceFluent<PciNested<N>> implements Nested<N>{
    PciNested(PciDevice item) {
      this.builder = new PciDeviceBuilder(this, item);
    }
    PciDeviceBuilder builder;
    
    public N and() {
      return (N) DeviceInfoFluent.this.withPci(builder.build());
    }
    
    public N endPci() {
      return and();
    }
    
  
  }
  public class VdpaNested<N> extends VdpaDeviceFluent<VdpaNested<N>> implements Nested<N>{
    VdpaNested(VdpaDevice item) {
      this.builder = new VdpaDeviceBuilder(this, item);
    }
    VdpaDeviceBuilder builder;
    
    public N and() {
      return (N) DeviceInfoFluent.this.withVdpa(builder.build());
    }
    
    public N endVdpa() {
      return and();
    }
    
  
  }
  public class VhostUserNested<N> extends VhostDeviceFluent<VhostUserNested<N>> implements Nested<N>{
    VhostUserNested(VhostDevice item) {
      this.builder = new VhostDeviceBuilder(this, item);
    }
    VhostDeviceBuilder builder;
    
    public N and() {
      return (N) DeviceInfoFluent.this.withVhostUser(builder.build());
    }
    
    public N endVhostUser() {
      return and();
    }
    
  
  }

}