package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KubevirtProviderSpecBuilder extends KubevirtProviderSpecFluent<KubevirtProviderSpecBuilder> implements VisitableBuilder<KubevirtProviderSpec,KubevirtProviderSpecBuilder>{
  public KubevirtProviderSpecBuilder() {
    this(new KubevirtProviderSpec());
  }
  
  public KubevirtProviderSpecBuilder(KubevirtProviderSpecFluent<?> fluent) {
    this(fluent, new KubevirtProviderSpec());
  }
  
  public KubevirtProviderSpecBuilder(KubevirtProviderSpecFluent<?> fluent,KubevirtProviderSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KubevirtProviderSpecBuilder(KubevirtProviderSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KubevirtProviderSpecFluent<?> fluent;
  
  public KubevirtProviderSpec build() {
    KubevirtProviderSpec buildable = new KubevirtProviderSpec(fluent.getApiVersion(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}