package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GCPProviderSpecFluent<A extends GCPProviderSpecFluent<A>> extends BaseFluent<A>{
  public GCPProviderSpecFluent() {
  }
  
  public GCPProviderSpecFluent(GCPProviderSpec instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String audience;
  private String kind;
  private List<String> permissions = new ArrayList<String>();
  private List<String> predefinedRoles = new ArrayList<String>();
  private String serviceAccountEmail;
  private Boolean skipServiceCheck;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GCPProviderSpec instance) {
    instance = (instance != null ? instance : new GCPProviderSpec());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withAudience(instance.getAudience());
          this.withKind(instance.getKind());
          this.withPermissions(instance.getPermissions());
          this.withPredefinedRoles(instance.getPredefinedRoles());
          this.withServiceAccountEmail(instance.getServiceAccountEmail());
          this.withSkipServiceCheck(instance.getSkipServiceCheck());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getAudience() {
    return this.audience;
  }
  
  public A withAudience(String audience) {
    this.audience = audience;
    return (A) this;
  }
  
  public boolean hasAudience() {
    return this.audience != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public A addToPermissions(int index,String item) {
    if (this.permissions == null) {this.permissions = new ArrayList<String>();}
    this.permissions.add(index, item);
    return (A)this;
  }
  
  public A setToPermissions(int index,String item) {
    if (this.permissions == null) {this.permissions = new ArrayList<String>();}
    this.permissions.set(index, item); return (A)this;
  }
  
  public A addToPermissions(java.lang.String... items) {
    if (this.permissions == null) {this.permissions = new ArrayList<String>();}
    for (String item : items) {this.permissions.add(item);} return (A)this;
  }
  
  public A addAllToPermissions(Collection<String> items) {
    if (this.permissions == null) {this.permissions = new ArrayList<String>();}
    for (String item : items) {this.permissions.add(item);} return (A)this;
  }
  
  public A removeFromPermissions(java.lang.String... items) {
    if (this.permissions == null) return (A)this;
    for (String item : items) { this.permissions.remove(item);} return (A)this;
  }
  
  public A removeAllFromPermissions(Collection<String> items) {
    if (this.permissions == null) return (A)this;
    for (String item : items) { this.permissions.remove(item);} return (A)this;
  }
  
  public List<String> getPermissions() {
    return this.permissions;
  }
  
  public String getPermission(int index) {
    return this.permissions.get(index);
  }
  
  public String getFirstPermission() {
    return this.permissions.get(0);
  }
  
  public String getLastPermission() {
    return this.permissions.get(permissions.size() - 1);
  }
  
  public String getMatchingPermission(Predicate<String> predicate) {
      for (String item : permissions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingPermission(Predicate<String> predicate) {
      for (String item : permissions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPermissions(List<String> permissions) {
    if (permissions != null) {
        this.permissions = new ArrayList();
        for (String item : permissions) {
          this.addToPermissions(item);
        }
    } else {
      this.permissions = null;
    }
    return (A) this;
  }
  
  public A withPermissions(java.lang.String... permissions) {
    if (this.permissions != null) {
        this.permissions.clear();
        _visitables.remove("permissions");
    }
    if (permissions != null) {
      for (String item : permissions) {
        this.addToPermissions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPermissions() {
    return this.permissions != null && !this.permissions.isEmpty();
  }
  
  public A addToPredefinedRoles(int index,String item) {
    if (this.predefinedRoles == null) {this.predefinedRoles = new ArrayList<String>();}
    this.predefinedRoles.add(index, item);
    return (A)this;
  }
  
  public A setToPredefinedRoles(int index,String item) {
    if (this.predefinedRoles == null) {this.predefinedRoles = new ArrayList<String>();}
    this.predefinedRoles.set(index, item); return (A)this;
  }
  
  public A addToPredefinedRoles(java.lang.String... items) {
    if (this.predefinedRoles == null) {this.predefinedRoles = new ArrayList<String>();}
    for (String item : items) {this.predefinedRoles.add(item);} return (A)this;
  }
  
  public A addAllToPredefinedRoles(Collection<String> items) {
    if (this.predefinedRoles == null) {this.predefinedRoles = new ArrayList<String>();}
    for (String item : items) {this.predefinedRoles.add(item);} return (A)this;
  }
  
  public A removeFromPredefinedRoles(java.lang.String... items) {
    if (this.predefinedRoles == null) return (A)this;
    for (String item : items) { this.predefinedRoles.remove(item);} return (A)this;
  }
  
  public A removeAllFromPredefinedRoles(Collection<String> items) {
    if (this.predefinedRoles == null) return (A)this;
    for (String item : items) { this.predefinedRoles.remove(item);} return (A)this;
  }
  
  public List<String> getPredefinedRoles() {
    return this.predefinedRoles;
  }
  
  public String getPredefinedRole(int index) {
    return this.predefinedRoles.get(index);
  }
  
  public String getFirstPredefinedRole() {
    return this.predefinedRoles.get(0);
  }
  
  public String getLastPredefinedRole() {
    return this.predefinedRoles.get(predefinedRoles.size() - 1);
  }
  
  public String getMatchingPredefinedRole(Predicate<String> predicate) {
      for (String item : predefinedRoles) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingPredefinedRole(Predicate<String> predicate) {
      for (String item : predefinedRoles) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPredefinedRoles(List<String> predefinedRoles) {
    if (predefinedRoles != null) {
        this.predefinedRoles = new ArrayList();
        for (String item : predefinedRoles) {
          this.addToPredefinedRoles(item);
        }
    } else {
      this.predefinedRoles = null;
    }
    return (A) this;
  }
  
  public A withPredefinedRoles(java.lang.String... predefinedRoles) {
    if (this.predefinedRoles != null) {
        this.predefinedRoles.clear();
        _visitables.remove("predefinedRoles");
    }
    if (predefinedRoles != null) {
      for (String item : predefinedRoles) {
        this.addToPredefinedRoles(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPredefinedRoles() {
    return this.predefinedRoles != null && !this.predefinedRoles.isEmpty();
  }
  
  public String getServiceAccountEmail() {
    return this.serviceAccountEmail;
  }
  
  public A withServiceAccountEmail(String serviceAccountEmail) {
    this.serviceAccountEmail = serviceAccountEmail;
    return (A) this;
  }
  
  public boolean hasServiceAccountEmail() {
    return this.serviceAccountEmail != null;
  }
  
  public Boolean getSkipServiceCheck() {
    return this.skipServiceCheck;
  }
  
  public A withSkipServiceCheck(Boolean skipServiceCheck) {
    this.skipServiceCheck = skipServiceCheck;
    return (A) this;
  }
  
  public boolean hasSkipServiceCheck() {
    return this.skipServiceCheck != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GCPProviderSpecFluent that = (GCPProviderSpecFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(audience, that.audience)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(permissions, that.permissions)) return false;
    if (!java.util.Objects.equals(predefinedRoles, that.predefinedRoles)) return false;
    if (!java.util.Objects.equals(serviceAccountEmail, that.serviceAccountEmail)) return false;
    if (!java.util.Objects.equals(skipServiceCheck, that.skipServiceCheck)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  audience,  kind,  permissions,  predefinedRoles,  serviceAccountEmail,  skipServiceCheck,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (audience != null) { sb.append("audience:"); sb.append(audience + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (permissions != null && !permissions.isEmpty()) { sb.append("permissions:"); sb.append(permissions + ","); }
    if (predefinedRoles != null && !predefinedRoles.isEmpty()) { sb.append("predefinedRoles:"); sb.append(predefinedRoles + ","); }
    if (serviceAccountEmail != null) { sb.append("serviceAccountEmail:"); sb.append(serviceAccountEmail + ","); }
    if (skipServiceCheck != null) { sb.append("skipServiceCheck:"); sb.append(skipServiceCheck + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSkipServiceCheck() {
    return withSkipServiceCheck(true);
  }
  

}