package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CredentialsRequestStatusBuilder extends CredentialsRequestStatusFluent<CredentialsRequestStatusBuilder> implements VisitableBuilder<CredentialsRequestStatus,CredentialsRequestStatusBuilder>{
  public CredentialsRequestStatusBuilder() {
    this(new CredentialsRequestStatus());
  }
  
  public CredentialsRequestStatusBuilder(CredentialsRequestStatusFluent<?> fluent) {
    this(fluent, new CredentialsRequestStatus());
  }
  
  public CredentialsRequestStatusBuilder(CredentialsRequestStatusFluent<?> fluent,CredentialsRequestStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CredentialsRequestStatusBuilder(CredentialsRequestStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CredentialsRequestStatusFluent<?> fluent;
  
  public CredentialsRequestStatus build() {
    CredentialsRequestStatus buildable = new CredentialsRequestStatus(fluent.buildConditions(),fluent.getLastSyncCloudCredsSecretResourceVersion(),fluent.getLastSyncGeneration(),fluent.getLastSyncTimestamp(),fluent.getProviderStatus(),fluent.getProvisioned());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}