/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkData;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLink;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataNetwork;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataNetworkBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataNetworkFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataService;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataServiceBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataServiceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkDataFluent<A extends NetworkDataFluent<A>>
extends BaseFluent<A> {
    private NetworkDataLinkBuilder links;
    private NetworkDataNetworkBuilder networks;
    private NetworkDataServiceBuilder services;
    private Map<String, Object> additionalProperties;

    public NetworkDataFluent() {
    }

    public NetworkDataFluent(NetworkData instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkData instance) {
        NetworkData networkData = instance = instance != null ? instance : new NetworkData();
        if (instance != null) {
            this.withLinks(instance.getLinks());
            this.withNetworks(instance.getNetworks());
            this.withServices(instance.getServices());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NetworkDataLink buildLinks() {
        return this.links != null ? this.links.build() : null;
    }

    public A withLinks(NetworkDataLink links) {
        this._visitables.remove((Object)"links");
        if (links != null) {
            this.links = new NetworkDataLinkBuilder(links);
            this._visitables.get((Object)"links").add(this.links);
        } else {
            this.links = null;
            this._visitables.get((Object)"links").remove((Object)this.links);
        }
        return (A)((Object)this);
    }

    public boolean hasLinks() {
        return this.links != null;
    }

    public LinksNested<A> withNewLinks() {
        return new LinksNested(null);
    }

    public LinksNested<A> withNewLinksLike(NetworkDataLink item) {
        return new LinksNested(item);
    }

    public LinksNested<A> editLinks() {
        return this.withNewLinksLike(Optional.ofNullable(this.buildLinks()).orElse(null));
    }

    public LinksNested<A> editOrNewLinks() {
        return this.withNewLinksLike(Optional.ofNullable(this.buildLinks()).orElse(new NetworkDataLinkBuilder().build()));
    }

    public LinksNested<A> editOrNewLinksLike(NetworkDataLink item) {
        return this.withNewLinksLike(Optional.ofNullable(this.buildLinks()).orElse(item));
    }

    public NetworkDataNetwork buildNetworks() {
        return this.networks != null ? this.networks.build() : null;
    }

    public A withNetworks(NetworkDataNetwork networks) {
        this._visitables.remove((Object)"networks");
        if (networks != null) {
            this.networks = new NetworkDataNetworkBuilder(networks);
            this._visitables.get((Object)"networks").add(this.networks);
        } else {
            this.networks = null;
            this._visitables.get((Object)"networks").remove((Object)this.networks);
        }
        return (A)((Object)this);
    }

    public boolean hasNetworks() {
        return this.networks != null;
    }

    public NetworksNested<A> withNewNetworks() {
        return new NetworksNested(null);
    }

    public NetworksNested<A> withNewNetworksLike(NetworkDataNetwork item) {
        return new NetworksNested(item);
    }

    public NetworksNested<A> editNetworks() {
        return this.withNewNetworksLike(Optional.ofNullable(this.buildNetworks()).orElse(null));
    }

    public NetworksNested<A> editOrNewNetworks() {
        return this.withNewNetworksLike(Optional.ofNullable(this.buildNetworks()).orElse(new NetworkDataNetworkBuilder().build()));
    }

    public NetworksNested<A> editOrNewNetworksLike(NetworkDataNetwork item) {
        return this.withNewNetworksLike(Optional.ofNullable(this.buildNetworks()).orElse(item));
    }

    public NetworkDataService buildServices() {
        return this.services != null ? this.services.build() : null;
    }

    public A withServices(NetworkDataService services) {
        this._visitables.remove((Object)"services");
        if (services != null) {
            this.services = new NetworkDataServiceBuilder(services);
            this._visitables.get((Object)"services").add(this.services);
        } else {
            this.services = null;
            this._visitables.get((Object)"services").remove((Object)this.services);
        }
        return (A)((Object)this);
    }

    public boolean hasServices() {
        return this.services != null;
    }

    public ServicesNested<A> withNewServices() {
        return new ServicesNested(null);
    }

    public ServicesNested<A> withNewServicesLike(NetworkDataService item) {
        return new ServicesNested(item);
    }

    public ServicesNested<A> editServices() {
        return this.withNewServicesLike(Optional.ofNullable(this.buildServices()).orElse(null));
    }

    public ServicesNested<A> editOrNewServices() {
        return this.withNewServicesLike(Optional.ofNullable(this.buildServices()).orElse(new NetworkDataServiceBuilder().build()));
    }

    public ServicesNested<A> editOrNewServicesLike(NetworkDataService item) {
        return this.withNewServicesLike(Optional.ofNullable(this.buildServices()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDataFluent that = (NetworkDataFluent)((Object)o);
        if (!Objects.equals((Object)this.links, (Object)that.links)) {
            return false;
        }
        if (!Objects.equals((Object)this.networks, (Object)that.networks)) {
            return false;
        }
        if (!Objects.equals((Object)this.services, (Object)that.services)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.links, this.networks, this.services, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.links != null) {
            sb.append("links:");
            sb.append(this.links + ",");
        }
        if (this.networks != null) {
            sb.append("networks:");
            sb.append(this.networks + ",");
        }
        if (this.services != null) {
            sb.append("services:");
            sb.append(this.services + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServicesNested<N>
    extends NetworkDataServiceFluent<ServicesNested<N>>
    implements Nested<N> {
        NetworkDataServiceBuilder builder;

        ServicesNested(NetworkDataService item) {
            this.builder = new NetworkDataServiceBuilder(this, item);
        }

        public N and() {
            return (N)NetworkDataFluent.this.withServices(this.builder.build());
        }

        public N endServices() {
            return this.and();
        }
    }

    public class NetworksNested<N>
    extends NetworkDataNetworkFluent<NetworksNested<N>>
    implements Nested<N> {
        NetworkDataNetworkBuilder builder;

        NetworksNested(NetworkDataNetwork item) {
            this.builder = new NetworkDataNetworkBuilder(this, item);
        }

        public N and() {
            return (N)NetworkDataFluent.this.withNetworks(this.builder.build());
        }

        public N endNetworks() {
            return this.and();
        }
    }

    public class LinksNested<N>
    extends NetworkDataLinkFluent<LinksNested<N>>
    implements Nested<N> {
        NetworkDataLinkBuilder builder;

        LinksNested(NetworkDataLink item) {
            this.builder = new NetworkDataLinkBuilder(this, item);
        }

        public N and() {
            return (N)NetworkDataFluent.this.withLinks(this.builder.build());
        }

        public N endLinks() {
            return this.and();
        }
    }
}

