/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.VSpherePermission;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.VSpherePermissionBuilder;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.VSpherePermissionFluent;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.VSphereProviderSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class VSphereProviderSpecFluent<A extends VSphereProviderSpecFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ArrayList<VSpherePermissionBuilder> permissions = new ArrayList();
    private Map<String, Object> additionalProperties;

    public VSphereProviderSpecFluent() {
    }

    public VSphereProviderSpecFluent(VSphereProviderSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VSphereProviderSpec instance) {
        VSphereProviderSpec vSphereProviderSpec = instance = instance != null ? instance : new VSphereProviderSpec();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withPermissions(instance.getPermissions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToPermissions(int index, VSpherePermission item) {
        if (this.permissions == null) {
            this.permissions = new ArrayList();
        }
        VSpherePermissionBuilder builder = new VSpherePermissionBuilder(item);
        if (index < 0 || index >= this.permissions.size()) {
            this._visitables.get((Object)"permissions").add(builder);
            this.permissions.add(builder);
        } else {
            this._visitables.get((Object)"permissions").add(index, builder);
            this.permissions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPermissions(int index, VSpherePermission item) {
        if (this.permissions == null) {
            this.permissions = new ArrayList();
        }
        VSpherePermissionBuilder builder = new VSpherePermissionBuilder(item);
        if (index < 0 || index >= this.permissions.size()) {
            this._visitables.get((Object)"permissions").add(builder);
            this.permissions.add(builder);
        } else {
            this._visitables.get((Object)"permissions").set(index, builder);
            this.permissions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPermissions(VSpherePermission ... items) {
        if (this.permissions == null) {
            this.permissions = new ArrayList();
        }
        for (VSpherePermission item : items) {
            VSpherePermissionBuilder builder = new VSpherePermissionBuilder(item);
            this._visitables.get((Object)"permissions").add(builder);
            this.permissions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPermissions(Collection<VSpherePermission> items) {
        if (this.permissions == null) {
            this.permissions = new ArrayList();
        }
        for (VSpherePermission item : items) {
            VSpherePermissionBuilder builder = new VSpherePermissionBuilder(item);
            this._visitables.get((Object)"permissions").add(builder);
            this.permissions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPermissions(VSpherePermission ... items) {
        if (this.permissions == null) {
            return (A)((Object)this);
        }
        for (VSpherePermission item : items) {
            VSpherePermissionBuilder builder = new VSpherePermissionBuilder(item);
            this._visitables.get((Object)"permissions").remove((Object)builder);
            this.permissions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPermissions(Collection<VSpherePermission> items) {
        if (this.permissions == null) {
            return (A)((Object)this);
        }
        for (VSpherePermission item : items) {
            VSpherePermissionBuilder builder = new VSpherePermissionBuilder(item);
            this._visitables.get((Object)"permissions").remove((Object)builder);
            this.permissions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPermissions(Predicate<VSpherePermissionBuilder> predicate) {
        if (this.permissions == null) {
            return (A)((Object)this);
        }
        Iterator<VSpherePermissionBuilder> each = this.permissions.iterator();
        List visitables = this._visitables.get((Object)"permissions");
        while (each.hasNext()) {
            VSpherePermissionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<VSpherePermission> buildPermissions() {
        return this.permissions != null ? VSphereProviderSpecFluent.build(this.permissions) : null;
    }

    public VSpherePermission buildPermission(int index) {
        return this.permissions.get(index).build();
    }

    public VSpherePermission buildFirstPermission() {
        return this.permissions.get(0).build();
    }

    public VSpherePermission buildLastPermission() {
        return this.permissions.get(this.permissions.size() - 1).build();
    }

    public VSpherePermission buildMatchingPermission(Predicate<VSpherePermissionBuilder> predicate) {
        for (VSpherePermissionBuilder item : this.permissions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPermission(Predicate<VSpherePermissionBuilder> predicate) {
        for (VSpherePermissionBuilder item : this.permissions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPermissions(List<VSpherePermission> permissions) {
        if (this.permissions != null) {
            this._visitables.get((Object)"permissions").clear();
        }
        if (permissions != null) {
            this.permissions = new ArrayList();
            for (VSpherePermission item : permissions) {
                this.addToPermissions(item);
            }
        } else {
            this.permissions = null;
        }
        return (A)((Object)this);
    }

    public A withPermissions(VSpherePermission ... permissions) {
        if (this.permissions != null) {
            this.permissions.clear();
            this._visitables.remove((Object)"permissions");
        }
        if (permissions != null) {
            for (VSpherePermission item : permissions) {
                this.addToPermissions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPermissions() {
        return this.permissions != null && !this.permissions.isEmpty();
    }

    public PermissionsNested<A> addNewPermission() {
        return new PermissionsNested(-1, null);
    }

    public PermissionsNested<A> addNewPermissionLike(VSpherePermission item) {
        return new PermissionsNested(-1, item);
    }

    public PermissionsNested<A> setNewPermissionLike(int index, VSpherePermission item) {
        return new PermissionsNested(index, item);
    }

    public PermissionsNested<A> editPermission(int index) {
        if (this.permissions.size() <= index) {
            throw new RuntimeException("Can't edit permissions. Index exceeds size.");
        }
        return this.setNewPermissionLike(index, this.buildPermission(index));
    }

    public PermissionsNested<A> editFirstPermission() {
        if (this.permissions.size() == 0) {
            throw new RuntimeException("Can't edit first permissions. The list is empty.");
        }
        return this.setNewPermissionLike(0, this.buildPermission(0));
    }

    public PermissionsNested<A> editLastPermission() {
        int index = this.permissions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last permissions. The list is empty.");
        }
        return this.setNewPermissionLike(index, this.buildPermission(index));
    }

    public PermissionsNested<A> editMatchingPermission(Predicate<VSpherePermissionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.permissions.size(); ++i) {
            if (!predicate.test(this.permissions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching permissions. No match found.");
        }
        return this.setNewPermissionLike(index, this.buildPermission(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VSphereProviderSpecFluent that = (VSphereProviderSpecFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.permissions, that.permissions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.permissions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.permissions != null && !this.permissions.isEmpty()) {
            sb.append("permissions:");
            sb.append(this.permissions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PermissionsNested<N>
    extends VSpherePermissionFluent<PermissionsNested<N>>
    implements Nested<N> {
        VSpherePermissionBuilder builder;
        int index;

        PermissionsNested(int index, VSpherePermission item) {
            this.index = index;
            this.builder = new VSpherePermissionBuilder(this, item);
        }

        public N and() {
            return (N)VSphereProviderSpecFluent.this.setToPermissions(this.index, this.builder.build());
        }

        public N endPermission() {
            return this.and();
        }
    }
}

