/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataLinkVlan;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkLinkEthernetMac;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkLinkEthernetMacBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkLinkEthernetMacFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkDataLinkVlanFluent<A extends NetworkDataLinkVlanFluent<A>>
extends BaseFluent<A> {
    private String id;
    private NetworkLinkEthernetMacBuilder macAddress;
    private Integer mtu;
    private Integer vlanID;
    private String vlanLink;
    private Map<String, Object> additionalProperties;

    public NetworkDataLinkVlanFluent() {
    }

    public NetworkDataLinkVlanFluent(NetworkDataLinkVlan instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkDataLinkVlan instance) {
        NetworkDataLinkVlan networkDataLinkVlan = instance = instance != null ? instance : new NetworkDataLinkVlan();
        if (instance != null) {
            this.withId(instance.getId());
            this.withMacAddress(instance.getMacAddress());
            this.withMtu(instance.getMtu());
            this.withVlanID(instance.getVlanID());
            this.withVlanLink(instance.getVlanLink());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)((Object)this);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public NetworkLinkEthernetMac buildMacAddress() {
        return this.macAddress != null ? this.macAddress.build() : null;
    }

    public A withMacAddress(NetworkLinkEthernetMac macAddress) {
        this._visitables.remove((Object)"macAddress");
        if (macAddress != null) {
            this.macAddress = new NetworkLinkEthernetMacBuilder(macAddress);
            this._visitables.get((Object)"macAddress").add(this.macAddress);
        } else {
            this.macAddress = null;
            this._visitables.get((Object)"macAddress").remove((Object)this.macAddress);
        }
        return (A)((Object)this);
    }

    public boolean hasMacAddress() {
        return this.macAddress != null;
    }

    public MacAddressNested<A> withNewMacAddress() {
        return new MacAddressNested(null);
    }

    public MacAddressNested<A> withNewMacAddressLike(NetworkLinkEthernetMac item) {
        return new MacAddressNested(item);
    }

    public MacAddressNested<A> editMacAddress() {
        return this.withNewMacAddressLike(Optional.ofNullable(this.buildMacAddress()).orElse(null));
    }

    public MacAddressNested<A> editOrNewMacAddress() {
        return this.withNewMacAddressLike(Optional.ofNullable(this.buildMacAddress()).orElse(new NetworkLinkEthernetMacBuilder().build()));
    }

    public MacAddressNested<A> editOrNewMacAddressLike(NetworkLinkEthernetMac item) {
        return this.withNewMacAddressLike(Optional.ofNullable(this.buildMacAddress()).orElse(item));
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public A withMtu(Integer mtu) {
        this.mtu = mtu;
        return (A)((Object)this);
    }

    public boolean hasMtu() {
        return this.mtu != null;
    }

    public Integer getVlanID() {
        return this.vlanID;
    }

    public A withVlanID(Integer vlanID) {
        this.vlanID = vlanID;
        return (A)((Object)this);
    }

    public boolean hasVlanID() {
        return this.vlanID != null;
    }

    public String getVlanLink() {
        return this.vlanLink;
    }

    public A withVlanLink(String vlanLink) {
        this.vlanLink = vlanLink;
        return (A)((Object)this);
    }

    public boolean hasVlanLink() {
        return this.vlanLink != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDataLinkVlanFluent that = (NetworkDataLinkVlanFluent)((Object)o);
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals((Object)this.macAddress, (Object)that.macAddress)) {
            return false;
        }
        if (!Objects.equals(this.mtu, that.mtu)) {
            return false;
        }
        if (!Objects.equals(this.vlanID, that.vlanID)) {
            return false;
        }
        if (!Objects.equals(this.vlanLink, that.vlanLink)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.macAddress, this.mtu, this.vlanID, this.vlanLink, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.macAddress != null) {
            sb.append("macAddress:");
            sb.append(this.macAddress + ",");
        }
        if (this.mtu != null) {
            sb.append("mtu:");
            sb.append(this.mtu + ",");
        }
        if (this.vlanID != null) {
            sb.append("vlanID:");
            sb.append(this.vlanID + ",");
        }
        if (this.vlanLink != null) {
            sb.append("vlanLink:");
            sb.append(this.vlanLink + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MacAddressNested<N>
    extends NetworkLinkEthernetMacFluent<MacAddressNested<N>>
    implements Nested<N> {
        NetworkLinkEthernetMacBuilder builder;

        MacAddressNested(NetworkLinkEthernetMac item) {
            this.builder = new NetworkLinkEthernetMacBuilder(this, item);
        }

        public N and() {
            return (N)NetworkDataLinkVlanFluent.this.withMacAddress(this.builder.build());
        }

        public N endMacAddress() {
            return this.and();
        }
    }
}

