/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CredentialsRequestSpecFluent<A extends CredentialsRequestSpecFluent<A>>
extends BaseFluent<A> {
    private String cloudTokenPath;
    private Object providerSpec;
    private ObjectReferenceBuilder secretRef;
    private List<String> serviceAccountNames = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public CredentialsRequestSpecFluent() {
    }

    public CredentialsRequestSpecFluent(CredentialsRequestSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CredentialsRequestSpec instance) {
        CredentialsRequestSpec credentialsRequestSpec = instance = instance != null ? instance : new CredentialsRequestSpec();
        if (instance != null) {
            this.withCloudTokenPath(instance.getCloudTokenPath());
            this.withProviderSpec(instance.getProviderSpec());
            this.withSecretRef(instance.getSecretRef());
            this.withServiceAccountNames(instance.getServiceAccountNames());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCloudTokenPath() {
        return this.cloudTokenPath;
    }

    public A withCloudTokenPath(String cloudTokenPath) {
        this.cloudTokenPath = cloudTokenPath;
        return (A)((Object)this);
    }

    public boolean hasCloudTokenPath() {
        return this.cloudTokenPath != null;
    }

    public Object getProviderSpec() {
        return this.providerSpec;
    }

    public A withProviderSpec(Object providerSpec) {
        this.providerSpec = providerSpec;
        return (A)((Object)this);
    }

    public boolean hasProviderSpec() {
        return this.providerSpec != null;
    }

    public ObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(ObjectReference secretRef) {
        this._visitables.remove((Object)"secretRef");
        if (secretRef != null) {
            this.secretRef = new ObjectReferenceBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove(this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public A addToServiceAccountNames(int index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToServiceAccountNames(int index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToServiceAccountNames(String ... items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToServiceAccountNames(Collection<String> items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromServiceAccountNames(String ... items) {
        if (this.serviceAccountNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.serviceAccountNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServiceAccountNames(Collection<String> items) {
        if (this.serviceAccountNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.serviceAccountNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getServiceAccountNames() {
        return this.serviceAccountNames;
    }

    public String getServiceAccountName(int index) {
        return this.serviceAccountNames.get(index);
    }

    public String getFirstServiceAccountName() {
        return this.serviceAccountNames.get(0);
    }

    public String getLastServiceAccountName() {
        return this.serviceAccountNames.get(this.serviceAccountNames.size() - 1);
    }

    public String getMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceAccountNames(List<String> serviceAccountNames) {
        if (serviceAccountNames != null) {
            this.serviceAccountNames = new ArrayList<String>();
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        } else {
            this.serviceAccountNames = null;
        }
        return (A)((Object)this);
    }

    public A withServiceAccountNames(String ... serviceAccountNames) {
        if (this.serviceAccountNames != null) {
            this.serviceAccountNames.clear();
            this._visitables.remove((Object)"serviceAccountNames");
        }
        if (serviceAccountNames != null) {
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccountNames() {
        return this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CredentialsRequestSpecFluent that = (CredentialsRequestSpecFluent)((Object)o);
        if (!Objects.equals(this.cloudTokenPath, that.cloudTokenPath)) {
            return false;
        }
        if (!Objects.equals(this.providerSpec, that.providerSpec)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountNames, that.serviceAccountNames)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cloudTokenPath, this.providerSpec, this.secretRef, this.serviceAccountNames, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cloudTokenPath != null) {
            sb.append("cloudTokenPath:");
            sb.append(this.cloudTokenPath + ",");
        }
        if (this.providerSpec != null) {
            sb.append("providerSpec:");
            sb.append(this.providerSpec + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty()) {
            sb.append("serviceAccountNames:");
            sb.append(this.serviceAccountNames + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretRefNested<N>
    extends ObjectReferenceFluent<SecretRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        SecretRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)CredentialsRequestSpecFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

