package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RedirectConfigFluentImpl<A extends RedirectConfigFluent<A>> extends BaseFluent<A> implements RedirectConfigFluent<A>{
  public RedirectConfigFluentImpl() {
  }
  public RedirectConfigFluentImpl(RedirectConfig instance) {
    if (instance != null) {
      this.withFallbackIP(instance.getFallbackIP());
      this.withRedirectRules(instance.getRedirectRules());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String fallbackIP;
  private ArrayList<L4RedirectRuleBuilder> redirectRules = new ArrayList<L4RedirectRuleBuilder>();
  private Map<String,Object> additionalProperties;
  public String getFallbackIP() {
    return this.fallbackIP;
  }
  public A withFallbackIP(String fallbackIP) {
    this.fallbackIP=fallbackIP; return (A) this;
  }
  public Boolean hasFallbackIP() {
    return this.fallbackIP != null;
  }
  public A addToRedirectRules(int index,L4RedirectRule item) {
    if (this.redirectRules == null) {this.redirectRules = new ArrayList<L4RedirectRuleBuilder>();}
    L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
    if (index < 0 || index >= redirectRules.size()) { _visitables.get("redirectRules").add(builder); redirectRules.add(builder); } else { _visitables.get("redirectRules").add(index, builder); redirectRules.add(index, builder);}
    return (A)this;
  }
  public A setToRedirectRules(int index,L4RedirectRule item) {
    if (this.redirectRules == null) {this.redirectRules = new ArrayList<L4RedirectRuleBuilder>();}
    L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);
    if (index < 0 || index >= redirectRules.size()) { _visitables.get("redirectRules").add(builder); redirectRules.add(builder); } else { _visitables.get("redirectRules").set(index, builder); redirectRules.set(index, builder);}
    return (A)this;
  }
  public A addToRedirectRules(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.L4RedirectRule... items) {
    if (this.redirectRules == null) {this.redirectRules = new ArrayList<L4RedirectRuleBuilder>();}
    for (L4RedirectRule item : items) {L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);_visitables.get("redirectRules").add(builder);this.redirectRules.add(builder);} return (A)this;
  }
  public A addAllToRedirectRules(Collection<L4RedirectRule> items) {
    if (this.redirectRules == null) {this.redirectRules = new ArrayList<L4RedirectRuleBuilder>();}
    for (L4RedirectRule item : items) {L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);_visitables.get("redirectRules").add(builder);this.redirectRules.add(builder);} return (A)this;
  }
  public A removeFromRedirectRules(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.L4RedirectRule... items) {
    for (L4RedirectRule item : items) {L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);_visitables.get("redirectRules").remove(builder);if (this.redirectRules != null) {this.redirectRules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRedirectRules(Collection<L4RedirectRule> items) {
    for (L4RedirectRule item : items) {L4RedirectRuleBuilder builder = new L4RedirectRuleBuilder(item);_visitables.get("redirectRules").remove(builder);if (this.redirectRules != null) {this.redirectRules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRedirectRules(Predicate<L4RedirectRuleBuilder> predicate) {
    if (redirectRules == null) return (A) this;
    final Iterator<L4RedirectRuleBuilder> each = redirectRules.iterator();
    final List visitables = _visitables.get("redirectRules");
    while (each.hasNext()) {
      L4RedirectRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRedirectRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<L4RedirectRule> getRedirectRules() {
    return redirectRules != null ? build(redirectRules) : null;
  }
  public List<L4RedirectRule> buildRedirectRules() {
    return redirectRules != null ? build(redirectRules) : null;
  }
  public L4RedirectRule buildRedirectRule(int index) {
    return this.redirectRules.get(index).build();
  }
  public L4RedirectRule buildFirstRedirectRule() {
    return this.redirectRules.get(0).build();
  }
  public L4RedirectRule buildLastRedirectRule() {
    return this.redirectRules.get(redirectRules.size() - 1).build();
  }
  public L4RedirectRule buildMatchingRedirectRule(Predicate<L4RedirectRuleBuilder> predicate) {
    for (L4RedirectRuleBuilder item: redirectRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRedirectRule(Predicate<L4RedirectRuleBuilder> predicate) {
    for (L4RedirectRuleBuilder item: redirectRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRedirectRules(List<L4RedirectRule> redirectRules) {
    if (this.redirectRules != null) { _visitables.get("redirectRules").clear();}
    if (redirectRules != null) {this.redirectRules = new ArrayList(); for (L4RedirectRule item : redirectRules){this.addToRedirectRules(item);}} else { this.redirectRules = null;} return (A) this;
  }
  public A withRedirectRules(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.L4RedirectRule... redirectRules) {
    if (this.redirectRules != null) {this.redirectRules.clear(); _visitables.remove("redirectRules"); }
    if (redirectRules != null) {for (L4RedirectRule item :redirectRules){ this.addToRedirectRules(item);}} return (A) this;
  }
  public Boolean hasRedirectRules() {
    return redirectRules != null && !redirectRules.isEmpty();
  }
  public A addNewRedirectRule(String destinationIP,Integer port,String protocol,Integer targetPort) {
    return (A)addToRedirectRules(new L4RedirectRule(destinationIP, port, protocol, targetPort));
  }
  public RedirectConfigFluentImpl.RedirectRulesNested<A> addNewRedirectRule() {
    return new RedirectConfigFluentImpl.RedirectRulesNestedImpl();
  }
  public RedirectConfigFluentImpl.RedirectRulesNested<A> addNewRedirectRuleLike(L4RedirectRule item) {
    return new RedirectConfigFluentImpl.RedirectRulesNestedImpl(-1, item);
  }
  public RedirectConfigFluentImpl.RedirectRulesNested<A> setNewRedirectRuleLike(int index,L4RedirectRule item) {
    return new RedirectConfigFluentImpl.RedirectRulesNestedImpl(index, item);
  }
  public RedirectConfigFluentImpl.RedirectRulesNested<A> editRedirectRule(int index) {
    if (redirectRules.size() <= index) throw new RuntimeException("Can't edit redirectRules. Index exceeds size.");
    return setNewRedirectRuleLike(index, buildRedirectRule(index));
  }
  public RedirectConfigFluentImpl.RedirectRulesNested<A> editFirstRedirectRule() {
    if (redirectRules.size() == 0) throw new RuntimeException("Can't edit first redirectRules. The list is empty.");
    return setNewRedirectRuleLike(0, buildRedirectRule(0));
  }
  public RedirectConfigFluentImpl.RedirectRulesNested<A> editLastRedirectRule() {
    int index = redirectRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last redirectRules. The list is empty.");
    return setNewRedirectRuleLike(index, buildRedirectRule(index));
  }
  public RedirectConfigFluentImpl.RedirectRulesNested<A> editMatchingRedirectRule(Predicate<L4RedirectRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<redirectRules.size();i++) { 
    if (predicate.test(redirectRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching redirectRules. No match found.");
    return setNewRedirectRuleLike(index, buildRedirectRule(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RedirectConfigFluentImpl that = (RedirectConfigFluentImpl) o;
    if (!java.util.Objects.equals(fallbackIP, that.fallbackIP)) return false;

    if (!java.util.Objects.equals(redirectRules, that.redirectRules)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fallbackIP,  redirectRules,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fallbackIP != null) { sb.append("fallbackIP:"); sb.append(fallbackIP + ","); }
    if (redirectRules != null) { sb.append("redirectRules:"); sb.append(redirectRules + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RedirectRulesNestedImpl<N> extends L4RedirectRuleFluentImpl<RedirectConfigFluentImpl.RedirectRulesNested<N>> implements RedirectConfigFluentImpl.RedirectRulesNested<N>,Nested<N>{
    RedirectRulesNestedImpl(int index,L4RedirectRule item) {
      this.index = index;
      this.builder = new L4RedirectRuleBuilder(this, item);
    }
    RedirectRulesNestedImpl() {
      this.index = -1;
      this.builder = new L4RedirectRuleBuilder(this);
    }
    L4RedirectRuleBuilder builder;
    int index;
    public N and() {
      return (N) RedirectConfigFluentImpl.this.setToRedirectRules(index,builder.build());
    }
    public N endRedirectRule() {
      return and();
    }
    
  }
  
}