package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressRouterBuilder extends EgressRouterFluentImpl<EgressRouterBuilder> implements VisitableBuilder<EgressRouter,EgressRouterBuilder>{
  public EgressRouterBuilder() {
    this(false);
  }
  public EgressRouterBuilder(Boolean validationEnabled) {
    this(new EgressRouter(), validationEnabled);
  }
  public EgressRouterBuilder(EgressRouterFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressRouterBuilder(EgressRouterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressRouter(), validationEnabled);
  }
  public EgressRouterBuilder(EgressRouterFluent<?> fluent,EgressRouter instance) {
    this(fluent, instance, false);
  }
  public EgressRouterBuilder(EgressRouterFluent<?> fluent,EgressRouter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressRouterBuilder(EgressRouter instance) {
    this(instance,false);
  }
  public EgressRouterBuilder(EgressRouter instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressRouterFluent<?> fluent;
  Boolean validationEnabled;
  public EgressRouter build() {
    EgressRouter buildable = new EgressRouter(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}