package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RootDeviceHintsBuilder extends RootDeviceHintsFluentImpl<RootDeviceHintsBuilder> implements VisitableBuilder<RootDeviceHints,RootDeviceHintsBuilder>{
  public RootDeviceHintsBuilder() {
    this(false);
  }
  public RootDeviceHintsBuilder(Boolean validationEnabled) {
    this(new RootDeviceHints(), validationEnabled);
  }
  public RootDeviceHintsBuilder(RootDeviceHintsFluent<?> fluent) {
    this(fluent, false);
  }
  public RootDeviceHintsBuilder(RootDeviceHintsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RootDeviceHints(), validationEnabled);
  }
  public RootDeviceHintsBuilder(RootDeviceHintsFluent<?> fluent,RootDeviceHints instance) {
    this(fluent, instance, false);
  }
  public RootDeviceHintsBuilder(RootDeviceHintsFluent<?> fluent,RootDeviceHints instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDeviceName(instance.getDeviceName());
      fluent.withHctl(instance.getHctl());
      fluent.withMinSizeGigabytes(instance.getMinSizeGigabytes());
      fluent.withModel(instance.getModel());
      fluent.withRotational(instance.getRotational());
      fluent.withSerialNumber(instance.getSerialNumber());
      fluent.withVendor(instance.getVendor());
      fluent.withWwn(instance.getWwn());
      fluent.withWwnVendorExtension(instance.getWwnVendorExtension());
      fluent.withWwnWithExtension(instance.getWwnWithExtension());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RootDeviceHintsBuilder(RootDeviceHints instance) {
    this(instance,false);
  }
  public RootDeviceHintsBuilder(RootDeviceHints instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDeviceName(instance.getDeviceName());
      this.withHctl(instance.getHctl());
      this.withMinSizeGigabytes(instance.getMinSizeGigabytes());
      this.withModel(instance.getModel());
      this.withRotational(instance.getRotational());
      this.withSerialNumber(instance.getSerialNumber());
      this.withVendor(instance.getVendor());
      this.withWwn(instance.getWwn());
      this.withWwnVendorExtension(instance.getWwnVendorExtension());
      this.withWwnWithExtension(instance.getWwnWithExtension());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RootDeviceHintsFluent<?> fluent;
  Boolean validationEnabled;
  public RootDeviceHints build() {
    RootDeviceHints buildable = new RootDeviceHints(fluent.getDeviceName(),fluent.getHctl(),fluent.getMinSizeGigabytes(),fluent.getModel(),fluent.getRotational(),fluent.getSerialNumber(),fluent.getVendor(),fluent.getWwn(),fluent.getWwnVendorExtension(),fluent.getWwnWithExtension());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}