package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RAIDConfigBuilder extends RAIDConfigFluentImpl<RAIDConfigBuilder> implements VisitableBuilder<RAIDConfig,RAIDConfigBuilder>{
  public RAIDConfigBuilder() {
    this(false);
  }
  public RAIDConfigBuilder(Boolean validationEnabled) {
    this(new RAIDConfig(), validationEnabled);
  }
  public RAIDConfigBuilder(RAIDConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public RAIDConfigBuilder(RAIDConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RAIDConfig(), validationEnabled);
  }
  public RAIDConfigBuilder(RAIDConfigFluent<?> fluent,RAIDConfig instance) {
    this(fluent, instance, false);
  }
  public RAIDConfigBuilder(RAIDConfigFluent<?> fluent,RAIDConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHardwareRAIDVolumes(instance.getHardwareRAIDVolumes());
      fluent.withSoftwareRAIDVolumes(instance.getSoftwareRAIDVolumes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RAIDConfigBuilder(RAIDConfig instance) {
    this(instance,false);
  }
  public RAIDConfigBuilder(RAIDConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHardwareRAIDVolumes(instance.getHardwareRAIDVolumes());
      this.withSoftwareRAIDVolumes(instance.getSoftwareRAIDVolumes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RAIDConfigFluent<?> fluent;
  Boolean validationEnabled;
  public RAIDConfig build() {
    RAIDConfig buildable = new RAIDConfig(fluent.getHardwareRAIDVolumes(),fluent.getSoftwareRAIDVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}