package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HardwareDetailsFluentImpl<A extends HardwareDetailsFluent<A>> extends BaseFluent<A> implements HardwareDetailsFluent<A>{
  public HardwareDetailsFluentImpl() {
  }
  public HardwareDetailsFluentImpl(HardwareDetails instance) {
    if (instance != null) {
      this.withCpu(instance.getCpu());
      this.withFirmware(instance.getFirmware());
      this.withHostname(instance.getHostname());
      this.withNics(instance.getNics());
      this.withRamMebibytes(instance.getRamMebibytes());
      this.withStorage(instance.getStorage());
      this.withSystemVendor(instance.getSystemVendor());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private CPUBuilder cpu;
  private FirmwareBuilder firmware;
  private String hostname;
  private ArrayList<NICBuilder> nics = new ArrayList<NICBuilder>();
  private Integer ramMebibytes;
  private ArrayList<StorageBuilder> storage = new ArrayList<StorageBuilder>();
  private HardwareSystemVendorBuilder systemVendor;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCpu instead.
   * @return The buildable object.
   */
  @Deprecated
  public CPU getCpu() {
    return this.cpu!=null ?this.cpu.build():null;
  }
  public CPU buildCpu() {
    return this.cpu!=null ?this.cpu.build():null;
  }
  public A withCpu(CPU cpu) {
    _visitables.get("cpu").remove(this.cpu);
    if (cpu!=null){ this.cpu= new CPUBuilder(cpu); _visitables.get("cpu").add(this.cpu);} else { this.cpu = null; _visitables.get("cpu").remove(this.cpu); } return (A) this;
  }
  public Boolean hasCpu() {
    return this.cpu != null;
  }
  public HardwareDetailsFluentImpl.CpuNested<A> withNewCpu() {
    return new HardwareDetailsFluentImpl.CpuNestedImpl();
  }
  public HardwareDetailsFluentImpl.CpuNested<A> withNewCpuLike(CPU item) {
    return new HardwareDetailsFluentImpl.CpuNestedImpl(item);
  }
  public HardwareDetailsFluentImpl.CpuNested<A> editCpu() {
    return withNewCpuLike(getCpu());
  }
  public HardwareDetailsFluentImpl.CpuNested<A> editOrNewCpu() {
    return withNewCpuLike(getCpu() != null ? getCpu(): new CPUBuilder().build());
  }
  public HardwareDetailsFluentImpl.CpuNested<A> editOrNewCpuLike(CPU item) {
    return withNewCpuLike(getCpu() != null ? getCpu(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFirmware instead.
   * @return The buildable object.
   */
  @Deprecated
  public Firmware getFirmware() {
    return this.firmware!=null ?this.firmware.build():null;
  }
  public Firmware buildFirmware() {
    return this.firmware!=null ?this.firmware.build():null;
  }
  public A withFirmware(Firmware firmware) {
    _visitables.get("firmware").remove(this.firmware);
    if (firmware!=null){ this.firmware= new FirmwareBuilder(firmware); _visitables.get("firmware").add(this.firmware);} else { this.firmware = null; _visitables.get("firmware").remove(this.firmware); } return (A) this;
  }
  public Boolean hasFirmware() {
    return this.firmware != null;
  }
  public HardwareDetailsFluentImpl.FirmwareNested<A> withNewFirmware() {
    return new HardwareDetailsFluentImpl.FirmwareNestedImpl();
  }
  public HardwareDetailsFluentImpl.FirmwareNested<A> withNewFirmwareLike(Firmware item) {
    return new HardwareDetailsFluentImpl.FirmwareNestedImpl(item);
  }
  public HardwareDetailsFluentImpl.FirmwareNested<A> editFirmware() {
    return withNewFirmwareLike(getFirmware());
  }
  public HardwareDetailsFluentImpl.FirmwareNested<A> editOrNewFirmware() {
    return withNewFirmwareLike(getFirmware() != null ? getFirmware(): new FirmwareBuilder().build());
  }
  public HardwareDetailsFluentImpl.FirmwareNested<A> editOrNewFirmwareLike(Firmware item) {
    return withNewFirmwareLike(getFirmware() != null ? getFirmware(): item);
  }
  public String getHostname() {
    return this.hostname;
  }
  public A withHostname(String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public Boolean hasHostname() {
    return this.hostname != null;
  }
  public A addToNics(int index,NIC item) {
    if (this.nics == null) {this.nics = new ArrayList<NICBuilder>();}
    NICBuilder builder = new NICBuilder(item);
    if (index < 0 || index >= nics.size()) { _visitables.get("nics").add(builder); nics.add(builder); } else { _visitables.get("nics").add(index, builder); nics.add(index, builder);}
    return (A)this;
  }
  public A setToNics(int index,NIC item) {
    if (this.nics == null) {this.nics = new ArrayList<NICBuilder>();}
    NICBuilder builder = new NICBuilder(item);
    if (index < 0 || index >= nics.size()) { _visitables.get("nics").add(builder); nics.add(builder); } else { _visitables.get("nics").set(index, builder); nics.set(index, builder);}
    return (A)this;
  }
  public A addToNics(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NIC... items) {
    if (this.nics == null) {this.nics = new ArrayList<NICBuilder>();}
    for (NIC item : items) {NICBuilder builder = new NICBuilder(item);_visitables.get("nics").add(builder);this.nics.add(builder);} return (A)this;
  }
  public A addAllToNics(Collection<NIC> items) {
    if (this.nics == null) {this.nics = new ArrayList<NICBuilder>();}
    for (NIC item : items) {NICBuilder builder = new NICBuilder(item);_visitables.get("nics").add(builder);this.nics.add(builder);} return (A)this;
  }
  public A removeFromNics(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NIC... items) {
    for (NIC item : items) {NICBuilder builder = new NICBuilder(item);_visitables.get("nics").remove(builder);if (this.nics != null) {this.nics.remove(builder);}} return (A)this;
  }
  public A removeAllFromNics(Collection<NIC> items) {
    for (NIC item : items) {NICBuilder builder = new NICBuilder(item);_visitables.get("nics").remove(builder);if (this.nics != null) {this.nics.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNics(Predicate<NICBuilder> predicate) {
    if (nics == null) return (A) this;
    final Iterator<NICBuilder> each = nics.iterator();
    final List visitables = _visitables.get("nics");
    while (each.hasNext()) {
      NICBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildNics instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NIC> getNics() {
    return nics != null ? build(nics) : null;
  }
  public List<NIC> buildNics() {
    return nics != null ? build(nics) : null;
  }
  public NIC buildNic(int index) {
    return this.nics.get(index).build();
  }
  public NIC buildFirstNic() {
    return this.nics.get(0).build();
  }
  public NIC buildLastNic() {
    return this.nics.get(nics.size() - 1).build();
  }
  public NIC buildMatchingNic(Predicate<NICBuilder> predicate) {
    for (NICBuilder item: nics) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingNic(Predicate<NICBuilder> predicate) {
    for (NICBuilder item: nics) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNics(List<NIC> nics) {
    if (this.nics != null) { _visitables.get("nics").clear();}
    if (nics != null) {this.nics = new ArrayList(); for (NIC item : nics){this.addToNics(item);}} else { this.nics = null;} return (A) this;
  }
  public A withNics(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NIC... nics) {
    if (this.nics != null) {this.nics.clear(); _visitables.remove("nics"); }
    if (nics != null) {for (NIC item :nics){ this.addToNics(item);}} return (A) this;
  }
  public Boolean hasNics() {
    return nics != null && !nics.isEmpty();
  }
  public HardwareDetailsFluentImpl.NicsNested<A> addNewNic() {
    return new HardwareDetailsFluentImpl.NicsNestedImpl();
  }
  public HardwareDetailsFluentImpl.NicsNested<A> addNewNicLike(NIC item) {
    return new HardwareDetailsFluentImpl.NicsNestedImpl(-1, item);
  }
  public HardwareDetailsFluentImpl.NicsNested<A> setNewNicLike(int index,NIC item) {
    return new HardwareDetailsFluentImpl.NicsNestedImpl(index, item);
  }
  public HardwareDetailsFluentImpl.NicsNested<A> editNic(int index) {
    if (nics.size() <= index) throw new RuntimeException("Can't edit nics. Index exceeds size.");
    return setNewNicLike(index, buildNic(index));
  }
  public HardwareDetailsFluentImpl.NicsNested<A> editFirstNic() {
    if (nics.size() == 0) throw new RuntimeException("Can't edit first nics. The list is empty.");
    return setNewNicLike(0, buildNic(0));
  }
  public HardwareDetailsFluentImpl.NicsNested<A> editLastNic() {
    int index = nics.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last nics. The list is empty.");
    return setNewNicLike(index, buildNic(index));
  }
  public HardwareDetailsFluentImpl.NicsNested<A> editMatchingNic(Predicate<NICBuilder> predicate) {
    int index = -1;
    for (int i=0;i<nics.size();i++) { 
    if (predicate.test(nics.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching nics. No match found.");
    return setNewNicLike(index, buildNic(index));
  }
  public Integer getRamMebibytes() {
    return this.ramMebibytes;
  }
  public A withRamMebibytes(Integer ramMebibytes) {
    this.ramMebibytes=ramMebibytes; return (A) this;
  }
  public Boolean hasRamMebibytes() {
    return this.ramMebibytes != null;
  }
  public A addToStorage(int index,Storage item) {
    if (this.storage == null) {this.storage = new ArrayList<StorageBuilder>();}
    StorageBuilder builder = new StorageBuilder(item);
    if (index < 0 || index >= storage.size()) { _visitables.get("storage").add(builder); storage.add(builder); } else { _visitables.get("storage").add(index, builder); storage.add(index, builder);}
    return (A)this;
  }
  public A setToStorage(int index,Storage item) {
    if (this.storage == null) {this.storage = new ArrayList<StorageBuilder>();}
    StorageBuilder builder = new StorageBuilder(item);
    if (index < 0 || index >= storage.size()) { _visitables.get("storage").add(builder); storage.add(builder); } else { _visitables.get("storage").set(index, builder); storage.set(index, builder);}
    return (A)this;
  }
  public A addToStorage(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.Storage... items) {
    if (this.storage == null) {this.storage = new ArrayList<StorageBuilder>();}
    for (Storage item : items) {StorageBuilder builder = new StorageBuilder(item);_visitables.get("storage").add(builder);this.storage.add(builder);} return (A)this;
  }
  public A addAllToStorage(Collection<Storage> items) {
    if (this.storage == null) {this.storage = new ArrayList<StorageBuilder>();}
    for (Storage item : items) {StorageBuilder builder = new StorageBuilder(item);_visitables.get("storage").add(builder);this.storage.add(builder);} return (A)this;
  }
  public A removeFromStorage(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.Storage... items) {
    for (Storage item : items) {StorageBuilder builder = new StorageBuilder(item);_visitables.get("storage").remove(builder);if (this.storage != null) {this.storage.remove(builder);}} return (A)this;
  }
  public A removeAllFromStorage(Collection<Storage> items) {
    for (Storage item : items) {StorageBuilder builder = new StorageBuilder(item);_visitables.get("storage").remove(builder);if (this.storage != null) {this.storage.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStorage(Predicate<StorageBuilder> predicate) {
    if (storage == null) return (A) this;
    final Iterator<StorageBuilder> each = storage.iterator();
    final List visitables = _visitables.get("storage");
    while (each.hasNext()) {
      StorageBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Storage> getStorage() {
    return storage != null ? build(storage) : null;
  }
  public List<Storage> buildStorage() {
    return storage != null ? build(storage) : null;
  }
  public Storage buildStorage(int index) {
    return this.storage.get(index).build();
  }
  public Storage buildFirstStorage() {
    return this.storage.get(0).build();
  }
  public Storage buildLastStorage() {
    return this.storage.get(storage.size() - 1).build();
  }
  public Storage buildMatchingStorage(Predicate<StorageBuilder> predicate) {
    for (StorageBuilder item: storage) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingStorage(Predicate<StorageBuilder> predicate) {
    for (StorageBuilder item: storage) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withStorage(List<Storage> storage) {
    if (this.storage != null) { _visitables.get("storage").clear();}
    if (storage != null) {this.storage = new ArrayList(); for (Storage item : storage){this.addToStorage(item);}} else { this.storage = null;} return (A) this;
  }
  public A withStorage(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.Storage... storage) {
    if (this.storage != null) {this.storage.clear(); _visitables.remove("storage"); }
    if (storage != null) {for (Storage item :storage){ this.addToStorage(item);}} return (A) this;
  }
  public Boolean hasStorage() {
    return storage != null && !storage.isEmpty();
  }
  public HardwareDetailsFluentImpl.StorageNested<A> addNewStorage() {
    return new HardwareDetailsFluentImpl.StorageNestedImpl();
  }
  public HardwareDetailsFluentImpl.StorageNested<A> addNewStorageLike(Storage item) {
    return new HardwareDetailsFluentImpl.StorageNestedImpl(-1, item);
  }
  public HardwareDetailsFluentImpl.StorageNested<A> setNewStorageLike(int index,Storage item) {
    return new HardwareDetailsFluentImpl.StorageNestedImpl(index, item);
  }
  public HardwareDetailsFluentImpl.StorageNested<A> editStorage(int index) {
    if (storage.size() <= index) throw new RuntimeException("Can't edit storage. Index exceeds size.");
    return setNewStorageLike(index, buildStorage(index));
  }
  public HardwareDetailsFluentImpl.StorageNested<A> editFirstStorage() {
    if (storage.size() == 0) throw new RuntimeException("Can't edit first storage. The list is empty.");
    return setNewStorageLike(0, buildStorage(0));
  }
  public HardwareDetailsFluentImpl.StorageNested<A> editLastStorage() {
    int index = storage.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last storage. The list is empty.");
    return setNewStorageLike(index, buildStorage(index));
  }
  public HardwareDetailsFluentImpl.StorageNested<A> editMatchingStorage(Predicate<StorageBuilder> predicate) {
    int index = -1;
    for (int i=0;i<storage.size();i++) { 
    if (predicate.test(storage.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching storage. No match found.");
    return setNewStorageLike(index, buildStorage(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSystemVendor instead.
   * @return The buildable object.
   */
  @Deprecated
  public HardwareSystemVendor getSystemVendor() {
    return this.systemVendor!=null ?this.systemVendor.build():null;
  }
  public HardwareSystemVendor buildSystemVendor() {
    return this.systemVendor!=null ?this.systemVendor.build():null;
  }
  public A withSystemVendor(HardwareSystemVendor systemVendor) {
    _visitables.get("systemVendor").remove(this.systemVendor);
    if (systemVendor!=null){ this.systemVendor= new HardwareSystemVendorBuilder(systemVendor); _visitables.get("systemVendor").add(this.systemVendor);} else { this.systemVendor = null; _visitables.get("systemVendor").remove(this.systemVendor); } return (A) this;
  }
  public Boolean hasSystemVendor() {
    return this.systemVendor != null;
  }
  public A withNewSystemVendor(String manufacturer,String productName,String serialNumber) {
    return (A)withSystemVendor(new HardwareSystemVendor(manufacturer, productName, serialNumber));
  }
  public HardwareDetailsFluentImpl.SystemVendorNested<A> withNewSystemVendor() {
    return new HardwareDetailsFluentImpl.SystemVendorNestedImpl();
  }
  public HardwareDetailsFluentImpl.SystemVendorNested<A> withNewSystemVendorLike(HardwareSystemVendor item) {
    return new HardwareDetailsFluentImpl.SystemVendorNestedImpl(item);
  }
  public HardwareDetailsFluentImpl.SystemVendorNested<A> editSystemVendor() {
    return withNewSystemVendorLike(getSystemVendor());
  }
  public HardwareDetailsFluentImpl.SystemVendorNested<A> editOrNewSystemVendor() {
    return withNewSystemVendorLike(getSystemVendor() != null ? getSystemVendor(): new HardwareSystemVendorBuilder().build());
  }
  public HardwareDetailsFluentImpl.SystemVendorNested<A> editOrNewSystemVendorLike(HardwareSystemVendor item) {
    return withNewSystemVendorLike(getSystemVendor() != null ? getSystemVendor(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HardwareDetailsFluentImpl that = (HardwareDetailsFluentImpl) o;
    if (!java.util.Objects.equals(cpu, that.cpu)) return false;

    if (!java.util.Objects.equals(firmware, that.firmware)) return false;

    if (!java.util.Objects.equals(hostname, that.hostname)) return false;

    if (!java.util.Objects.equals(nics, that.nics)) return false;

    if (!java.util.Objects.equals(ramMebibytes, that.ramMebibytes)) return false;

    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(systemVendor, that.systemVendor)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cpu,  firmware,  hostname,  nics,  ramMebibytes,  storage,  systemVendor,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cpu != null) { sb.append("cpu:"); sb.append(cpu + ","); }
    if (firmware != null) { sb.append("firmware:"); sb.append(firmware + ","); }
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (nics != null) { sb.append("nics:"); sb.append(nics + ","); }
    if (ramMebibytes != null) { sb.append("ramMebibytes:"); sb.append(ramMebibytes + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (systemVendor != null) { sb.append("systemVendor:"); sb.append(systemVendor + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CpuNestedImpl<N> extends CPUFluentImpl<HardwareDetailsFluentImpl.CpuNested<N>> implements HardwareDetailsFluentImpl.CpuNested<N>,Nested<N>{
    CpuNestedImpl(CPU item) {
      this.builder = new CPUBuilder(this, item);
    }
    CpuNestedImpl() {
      this.builder = new CPUBuilder(this);
    }
    CPUBuilder builder;
    public N and() {
      return (N) HardwareDetailsFluentImpl.this.withCpu(builder.build());
    }
    public N endCpu() {
      return and();
    }
    
  }
  class FirmwareNestedImpl<N> extends FirmwareFluentImpl<HardwareDetailsFluentImpl.FirmwareNested<N>> implements HardwareDetailsFluentImpl.FirmwareNested<N>,Nested<N>{
    FirmwareNestedImpl(Firmware item) {
      this.builder = new FirmwareBuilder(this, item);
    }
    FirmwareNestedImpl() {
      this.builder = new FirmwareBuilder(this);
    }
    FirmwareBuilder builder;
    public N and() {
      return (N) HardwareDetailsFluentImpl.this.withFirmware(builder.build());
    }
    public N endFirmware() {
      return and();
    }
    
  }
  class NicsNestedImpl<N> extends NICFluentImpl<HardwareDetailsFluentImpl.NicsNested<N>> implements HardwareDetailsFluentImpl.NicsNested<N>,Nested<N>{
    NicsNestedImpl(int index,NIC item) {
      this.index = index;
      this.builder = new NICBuilder(this, item);
    }
    NicsNestedImpl() {
      this.index = -1;
      this.builder = new NICBuilder(this);
    }
    NICBuilder builder;
    int index;
    public N and() {
      return (N) HardwareDetailsFluentImpl.this.setToNics(index,builder.build());
    }
    public N endNic() {
      return and();
    }
    
  }
  class StorageNestedImpl<N> extends StorageFluentImpl<HardwareDetailsFluentImpl.StorageNested<N>> implements HardwareDetailsFluentImpl.StorageNested<N>,Nested<N>{
    StorageNestedImpl(int index,Storage item) {
      this.index = index;
      this.builder = new StorageBuilder(this, item);
    }
    StorageNestedImpl() {
      this.index = -1;
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    int index;
    public N and() {
      return (N) HardwareDetailsFluentImpl.this.setToStorage(index,builder.build());
    }
    public N endStorage() {
      return and();
    }
    
  }
  class SystemVendorNestedImpl<N> extends HardwareSystemVendorFluentImpl<HardwareDetailsFluentImpl.SystemVendorNested<N>> implements HardwareDetailsFluentImpl.SystemVendorNested<N>,Nested<N>{
    SystemVendorNestedImpl(HardwareSystemVendor item) {
      this.builder = new HardwareSystemVendorBuilder(this, item);
    }
    SystemVendorNestedImpl() {
      this.builder = new HardwareSystemVendorBuilder(this);
    }
    HardwareSystemVendorBuilder builder;
    public N and() {
      return (N) HardwareDetailsFluentImpl.this.withSystemVendor(builder.build());
    }
    public N endSystemVendor() {
      return and();
    }
    
  }
  
}