package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BareMetalHostListBuilder extends BareMetalHostListFluentImpl<BareMetalHostListBuilder> implements VisitableBuilder<BareMetalHostList,BareMetalHostListBuilder>{
  public BareMetalHostListBuilder() {
    this(false);
  }
  public BareMetalHostListBuilder(Boolean validationEnabled) {
    this(new BareMetalHostList(), validationEnabled);
  }
  public BareMetalHostListBuilder(BareMetalHostListFluent<?> fluent) {
    this(fluent, false);
  }
  public BareMetalHostListBuilder(BareMetalHostListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BareMetalHostList(), validationEnabled);
  }
  public BareMetalHostListBuilder(BareMetalHostListFluent<?> fluent,BareMetalHostList instance) {
    this(fluent, instance, false);
  }
  public BareMetalHostListBuilder(BareMetalHostListFluent<?> fluent,BareMetalHostList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BareMetalHostListBuilder(BareMetalHostList instance) {
    this(instance,false);
  }
  public BareMetalHostListBuilder(BareMetalHostList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BareMetalHostListFluent<?> fluent;
  Boolean validationEnabled;
  public BareMetalHostList build() {
    BareMetalHostList buildable = new BareMetalHostList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}