package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BIOSBuilder extends BIOSFluentImpl<BIOSBuilder> implements VisitableBuilder<BIOS,BIOSBuilder>{
  public BIOSBuilder() {
    this(false);
  }
  public BIOSBuilder(Boolean validationEnabled) {
    this(new BIOS(), validationEnabled);
  }
  public BIOSBuilder(BIOSFluent<?> fluent) {
    this(fluent, false);
  }
  public BIOSBuilder(BIOSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BIOS(), validationEnabled);
  }
  public BIOSBuilder(BIOSFluent<?> fluent,BIOS instance) {
    this(fluent, instance, false);
  }
  public BIOSBuilder(BIOSFluent<?> fluent,BIOS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDate(instance.getDate());
      fluent.withVendor(instance.getVendor());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BIOSBuilder(BIOS instance) {
    this(instance,false);
  }
  public BIOSBuilder(BIOS instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDate(instance.getDate());
      this.withVendor(instance.getVendor());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BIOSFluent<?> fluent;
  Boolean validationEnabled;
  public BIOS build() {
    BIOS buildable = new BIOS(fluent.getDate(),fluent.getVendor(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}