package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.OperatorCondition;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.operator.v1.GenerationStatus;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageRegistryStatusFluentImpl<A extends ImageRegistryStatusFluent<A>> extends BaseFluent<A> implements ImageRegistryStatusFluent<A>{
  public ImageRegistryStatusFluentImpl() {
  }
  public ImageRegistryStatusFluentImpl(ImageRegistryStatus instance) {
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withStorage(instance.getStorage());
      this.withStorageManaged(instance.getStorageManaged());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<OperatorCondition> conditions = new ArrayList<OperatorCondition>();
  private List<GenerationStatus> generations = new ArrayList<GenerationStatus>();
  private Long observedGeneration;
  private Integer readyReplicas;
  private ImageRegistryConfigStorageBuilder storage;
  private Boolean storageManaged;
  private String version;
  private Map<String,Object> additionalProperties;
  public A addToConditions(int index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorCondition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(int index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorCondition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorCondition>();}
    for (OperatorCondition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<OperatorCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorCondition>();}
    for (OperatorCondition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    for (OperatorCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<OperatorCondition> items) {
    for (OperatorCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<OperatorCondition> getConditions() {
    return this.conditions;
  }
  public OperatorCondition getCondition(int index) {
    return this.conditions.get(index);
  }
  public OperatorCondition getFirstCondition() {
    return this.conditions.get(0);
  }
  public OperatorCondition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public OperatorCondition getMatchingCondition(Predicate<OperatorCondition> predicate) {
    for (OperatorCondition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<OperatorCondition> predicate) {
    for (OperatorCondition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<OperatorCondition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (OperatorCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (OperatorCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  public A addToGenerations(int index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatus>();}
    this.generations.add(index, item);
    return (A)this;
  }
  public A setToGenerations(int index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatus>();}
    this.generations.set(index, item); return (A)this;
  }
  public A addToGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatus>();}
    for (GenerationStatus item : items) {this.generations.add(item);} return (A)this;
  }
  public A addAllToGenerations(Collection<GenerationStatus> items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatus>();}
    for (GenerationStatus item : items) {this.generations.add(item);} return (A)this;
  }
  public A removeFromGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... items) {
    for (GenerationStatus item : items) {if (this.generations!= null){ this.generations.remove(item);}} return (A)this;
  }
  public A removeAllFromGenerations(Collection<GenerationStatus> items) {
    for (GenerationStatus item : items) {if (this.generations!= null){ this.generations.remove(item);}} return (A)this;
  }
  public List<GenerationStatus> getGenerations() {
    return this.generations;
  }
  public GenerationStatus getGeneration(int index) {
    return this.generations.get(index);
  }
  public GenerationStatus getFirstGeneration() {
    return this.generations.get(0);
  }
  public GenerationStatus getLastGeneration() {
    return this.generations.get(generations.size() - 1);
  }
  public GenerationStatus getMatchingGeneration(Predicate<GenerationStatus> predicate) {
    for (GenerationStatus item: generations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGeneration(Predicate<GenerationStatus> predicate) {
    for (GenerationStatus item: generations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGenerations(List<GenerationStatus> generations) {
    if (generations != null) {this.generations = new ArrayList(); for (GenerationStatus item : generations){this.addToGenerations(item);}} else { this.generations = null;} return (A) this;
  }
  public A withGenerations(io.fabric8.openshift.api.model.operator.v1.GenerationStatus... generations) {
    if (this.generations != null) {this.generations.clear(); _visitables.remove("generations"); }
    if (generations != null) {for (GenerationStatus item :generations){ this.addToGenerations(item);}} return (A) this;
  }
  public Boolean hasGenerations() {
    return generations != null && !generations.isEmpty();
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public Integer getReadyReplicas() {
    return this.readyReplicas;
  }
  public A withReadyReplicas(Integer readyReplicas) {
    this.readyReplicas=readyReplicas; return (A) this;
  }
  public Boolean hasReadyReplicas() {
    return this.readyReplicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorage getStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public ImageRegistryConfigStorage buildStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public A withStorage(ImageRegistryConfigStorage storage) {
    _visitables.get("storage").remove(this.storage);
    if (storage!=null){ this.storage= new ImageRegistryConfigStorageBuilder(storage); _visitables.get("storage").add(this.storage);} else { this.storage = null; _visitables.get("storage").remove(this.storage); } return (A) this;
  }
  public Boolean hasStorage() {
    return this.storage != null;
  }
  public ImageRegistryStatusFluentImpl.StorageNested<A> withNewStorage() {
    return new ImageRegistryStatusFluentImpl.StorageNestedImpl();
  }
  public ImageRegistryStatusFluentImpl.StorageNested<A> withNewStorageLike(ImageRegistryConfigStorage item) {
    return new ImageRegistryStatusFluentImpl.StorageNestedImpl(item);
  }
  public ImageRegistryStatusFluentImpl.StorageNested<A> editStorage() {
    return withNewStorageLike(getStorage());
  }
  public ImageRegistryStatusFluentImpl.StorageNested<A> editOrNewStorage() {
    return withNewStorageLike(getStorage() != null ? getStorage(): new ImageRegistryConfigStorageBuilder().build());
  }
  public ImageRegistryStatusFluentImpl.StorageNested<A> editOrNewStorageLike(ImageRegistryConfigStorage item) {
    return withNewStorageLike(getStorage() != null ? getStorage(): item);
  }
  public Boolean getStorageManaged() {
    return this.storageManaged;
  }
  public A withStorageManaged(Boolean storageManaged) {
    this.storageManaged=storageManaged; return (A) this;
  }
  public Boolean hasStorageManaged() {
    return this.storageManaged != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageRegistryStatusFluentImpl that = (ImageRegistryStatusFluentImpl) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(generations, that.generations)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(readyReplicas, that.readyReplicas)) return false;

    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(storageManaged, that.storageManaged)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  generations,  observedGeneration,  readyReplicas,  storage,  storageManaged,  version,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (generations != null && !generations.isEmpty()) { sb.append("generations:"); sb.append(generations + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (readyReplicas != null) { sb.append("readyReplicas:"); sb.append(readyReplicas + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (storageManaged != null) { sb.append("storageManaged:"); sb.append(storageManaged + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withStorageManaged() {
    return withStorageManaged(true);
  }
  class StorageNestedImpl<N> extends ImageRegistryConfigStorageFluentImpl<ImageRegistryStatusFluentImpl.StorageNested<N>> implements ImageRegistryStatusFluentImpl.StorageNested<N>,Nested<N>{
    StorageNestedImpl(ImageRegistryConfigStorage item) {
      this.builder = new ImageRegistryConfigStorageBuilder(this, item);
    }
    StorageNestedImpl() {
      this.builder = new ImageRegistryConfigStorageBuilder(this);
    }
    ImageRegistryConfigStorageBuilder builder;
    public N and() {
      return (N) ImageRegistryStatusFluentImpl.this.withStorage(builder.build());
    }
    public N endStorage() {
      return and();
    }
    
  }
  
}