package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ConfigFluent<A extends ConfigFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ConfigFluent.MetadataNested<A> withNewMetadata();
  public ConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ConfigFluent.MetadataNested<A> editMetadata();
  public ConfigFluent.MetadataNested<A> editOrNewMetadata();
  public ConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistrySpec getSpec();
  public ImageRegistrySpec buildSpec();
  public A withSpec(ImageRegistrySpec spec);
  public Boolean hasSpec();
  public ConfigFluent.SpecNested<A> withNewSpec();
  public ConfigFluent.SpecNested<A> withNewSpecLike(ImageRegistrySpec item);
  public ConfigFluent.SpecNested<A> editSpec();
  public ConfigFluent.SpecNested<A> editOrNewSpec();
  public ConfigFluent.SpecNested<A> editOrNewSpecLike(ImageRegistrySpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryStatus getStatus();
  public ImageRegistryStatus buildStatus();
  public A withStatus(ImageRegistryStatus status);
  public Boolean hasStatus();
  public ConfigFluent.StatusNested<A> withNewStatus();
  public ConfigFluent.StatusNested<A> withNewStatusLike(ImageRegistryStatus item);
  public ConfigFluent.StatusNested<A> editStatus();
  public ConfigFluent.StatusNested<A> editOrNewStatus();
  public ConfigFluent.StatusNested<A> editOrNewStatusLike(ImageRegistryStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ConfigFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ImageRegistrySpecFluent<ConfigFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ImageRegistryStatusFluent<ConfigFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}