package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIRequestCountListBuilder extends APIRequestCountListFluentImpl<APIRequestCountListBuilder> implements VisitableBuilder<APIRequestCountList,APIRequestCountListBuilder>{
  public APIRequestCountListBuilder() {
    this(false);
  }
  public APIRequestCountListBuilder(Boolean validationEnabled) {
    this(new APIRequestCountList(), validationEnabled);
  }
  public APIRequestCountListBuilder(APIRequestCountListFluent<?> fluent) {
    this(fluent, false);
  }
  public APIRequestCountListBuilder(APIRequestCountListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIRequestCountList(), validationEnabled);
  }
  public APIRequestCountListBuilder(APIRequestCountListFluent<?> fluent,APIRequestCountList instance) {
    this(fluent, instance, false);
  }
  public APIRequestCountListBuilder(APIRequestCountListFluent<?> fluent,APIRequestCountList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIRequestCountListBuilder(APIRequestCountList instance) {
    this(instance,false);
  }
  public APIRequestCountListBuilder(APIRequestCountList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIRequestCountListFluent<?> fluent;
  Boolean validationEnabled;
  public APIRequestCountList build() {
    APIRequestCountList buildable = new APIRequestCountList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}