/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NIC;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NICFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.VLAN;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.VLANBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.VLANFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NICFluentImpl<A extends NICFluent<A>>
extends BaseFluent<A>
implements NICFluent<A> {
    private String ip;
    private String mac;
    private String model;
    private String name;
    private Boolean pxe;
    private Integer speedGbps;
    private Integer vlanId;
    private ArrayList<VLANBuilder> vlans = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NICFluentImpl() {
    }

    public NICFluentImpl(NIC instance) {
        this.withIp(instance.getIp());
        this.withMac(instance.getMac());
        this.withModel(instance.getModel());
        this.withName(instance.getName());
        this.withPxe(instance.getPxe());
        this.withSpeedGbps(instance.getSpeedGbps());
        this.withVlanId(instance.getVlanId());
        this.withVlans(instance.getVlans());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    public String getMac() {
        return this.mac;
    }

    @Override
    public A withMac(String mac) {
        this.mac = mac;
        return (A)this;
    }

    @Override
    public Boolean hasMac() {
        return this.mac != null;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public A withModel(String model) {
        this.model = model;
        return (A)this;
    }

    @Override
    public Boolean hasModel() {
        return this.model != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Boolean getPxe() {
        return this.pxe;
    }

    @Override
    public A withPxe(Boolean pxe) {
        this.pxe = pxe;
        return (A)this;
    }

    @Override
    public Boolean hasPxe() {
        return this.pxe != null;
    }

    @Override
    public Integer getSpeedGbps() {
        return this.speedGbps;
    }

    @Override
    public A withSpeedGbps(Integer speedGbps) {
        this.speedGbps = speedGbps;
        return (A)this;
    }

    @Override
    public Boolean hasSpeedGbps() {
        return this.speedGbps != null;
    }

    @Override
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Override
    public A withVlanId(Integer vlanId) {
        this.vlanId = vlanId;
        return (A)this;
    }

    @Override
    public Boolean hasVlanId() {
        return this.vlanId != null;
    }

    @Override
    public A addToVlans(Integer index, VLAN item) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        VLANBuilder builder = new VLANBuilder(item);
        this._visitables.get((Object)"vlans").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"vlans").size(), builder);
        this.vlans.add(index >= 0 ? index.intValue() : this.vlans.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVlans(Integer index, VLAN item) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        VLANBuilder builder = new VLANBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"vlans").size()) {
            this._visitables.get((Object)"vlans").add(builder);
        } else {
            this._visitables.get((Object)"vlans").set(index, builder);
        }
        if (index < 0 || index >= this.vlans.size()) {
            this.vlans.add(builder);
        } else {
            this.vlans.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVlans(VLAN ... items) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        for (VLAN item : items) {
            VLANBuilder builder = new VLANBuilder(item);
            this._visitables.get((Object)"vlans").add(builder);
            this.vlans.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVlans(Collection<VLAN> items) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        for (VLAN item : items) {
            VLANBuilder builder = new VLANBuilder(item);
            this._visitables.get((Object)"vlans").add(builder);
            this.vlans.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVlans(VLAN ... items) {
        for (VLAN item : items) {
            VLANBuilder builder = new VLANBuilder(item);
            this._visitables.get((Object)"vlans").remove(builder);
            if (this.vlans == null) continue;
            this.vlans.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVlans(Collection<VLAN> items) {
        for (VLAN item : items) {
            VLANBuilder builder = new VLANBuilder(item);
            this._visitables.get((Object)"vlans").remove(builder);
            if (this.vlans == null) continue;
            this.vlans.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVlans(Predicate<VLANBuilder> predicate) {
        if (this.vlans == null) {
            return (A)this;
        }
        Iterator<VLANBuilder> each = this.vlans.iterator();
        List visitables = this._visitables.get((Object)"vlans");
        while (each.hasNext()) {
            VLANBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<VLAN> getVlans() {
        return this.vlans != null ? NICFluentImpl.build(this.vlans) : null;
    }

    @Override
    public List<VLAN> buildVlans() {
        return this.vlans != null ? NICFluentImpl.build(this.vlans) : null;
    }

    @Override
    public VLAN buildVlan(Integer index) {
        return this.vlans.get(index).build();
    }

    @Override
    public VLAN buildFirstVlan() {
        return this.vlans.get(0).build();
    }

    @Override
    public VLAN buildLastVlan() {
        return this.vlans.get(this.vlans.size() - 1).build();
    }

    @Override
    public VLAN buildMatchingVlan(Predicate<VLANBuilder> predicate) {
        for (VLANBuilder item : this.vlans) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVlan(Predicate<VLANBuilder> predicate) {
        for (VLANBuilder item : this.vlans) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVlans(List<VLAN> vlans) {
        if (this.vlans != null) {
            this._visitables.get((Object)"vlans").removeAll(this.vlans);
        }
        if (vlans != null) {
            this.vlans = new ArrayList();
            for (VLAN item : vlans) {
                this.addToVlans(item);
            }
        } else {
            this.vlans = null;
        }
        return (A)this;
    }

    @Override
    public A withVlans(VLAN ... vlans) {
        if (this.vlans != null) {
            this.vlans.clear();
        }
        if (vlans != null) {
            for (VLAN item : vlans) {
                this.addToVlans(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVlans() {
        return this.vlans != null && !this.vlans.isEmpty();
    }

    @Override
    public A addNewVlan(Integer id, String name) {
        return this.addToVlans(new VLAN(id, name));
    }

    @Override
    public NICFluent.VlansNested<A> addNewVlan() {
        return new VlansNestedImpl();
    }

    @Override
    public NICFluent.VlansNested<A> addNewVlanLike(VLAN item) {
        return new VlansNestedImpl(-1, item);
    }

    @Override
    public NICFluent.VlansNested<A> setNewVlanLike(Integer index, VLAN item) {
        return new VlansNestedImpl(index, item);
    }

    @Override
    public NICFluent.VlansNested<A> editVlan(Integer index) {
        if (this.vlans.size() <= index) {
            throw new RuntimeException("Can't edit vlans. Index exceeds size.");
        }
        return this.setNewVlanLike(index, this.buildVlan(index));
    }

    @Override
    public NICFluent.VlansNested<A> editFirstVlan() {
        if (this.vlans.size() == 0) {
            throw new RuntimeException("Can't edit first vlans. The list is empty.");
        }
        return this.setNewVlanLike(0, this.buildVlan(0));
    }

    @Override
    public NICFluent.VlansNested<A> editLastVlan() {
        int index = this.vlans.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last vlans. The list is empty.");
        }
        return this.setNewVlanLike(index, this.buildVlan(index));
    }

    @Override
    public NICFluent.VlansNested<A> editMatchingVlan(Predicate<VLANBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.vlans.size(); ++i) {
            if (!predicate.test(this.vlans.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching vlans. No match found.");
        }
        return this.setNewVlanLike(index, this.buildVlan(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NICFluentImpl that = (NICFluentImpl)o;
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        if (this.mac != null ? !this.mac.equals(that.mac) : that.mac != null) {
            return false;
        }
        if (this.model != null ? !this.model.equals(that.model) : that.model != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.pxe != null ? !this.pxe.equals(that.pxe) : that.pxe != null) {
            return false;
        }
        if (this.speedGbps != null ? !this.speedGbps.equals(that.speedGbps) : that.speedGbps != null) {
            return false;
        }
        if (this.vlanId != null ? !this.vlanId.equals(that.vlanId) : that.vlanId != null) {
            return false;
        }
        if (this.vlans != null ? !this.vlans.equals(that.vlans) : that.vlans != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.mac, this.model, this.name, this.pxe, this.speedGbps, this.vlanId, this.vlans, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip + ",");
        }
        if (this.mac != null) {
            sb.append("mac:");
            sb.append(this.mac + ",");
        }
        if (this.model != null) {
            sb.append("model:");
            sb.append(this.model + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.pxe != null) {
            sb.append("pxe:");
            sb.append(this.pxe + ",");
        }
        if (this.speedGbps != null) {
            sb.append("speedGbps:");
            sb.append(this.speedGbps + ",");
        }
        if (this.vlanId != null) {
            sb.append("vlanId:");
            sb.append(this.vlanId + ",");
        }
        if (this.vlans != null && !this.vlans.isEmpty()) {
            sb.append("vlans:");
            sb.append(this.vlans + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withPxe() {
        return this.withPxe(true);
    }

    class VlansNestedImpl<N>
    extends VLANFluentImpl<NICFluent.VlansNested<N>>
    implements NICFluent.VlansNested<N>,
    Nested<N> {
        VLANBuilder builder;
        Integer index;

        VlansNestedImpl(Integer index, VLAN item) {
            this.index = index;
            this.builder = new VLANBuilder(this, item);
        }

        VlansNestedImpl() {
            this.index = -1;
            this.builder = new VLANBuilder(this);
        }

        @Override
        public N and() {
            return (N)NICFluentImpl.this.setToVlans(this.index, this.builder.build());
        }

        @Override
        public N endVlan() {
            return this.and();
        }
    }
}

