package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VLANBuilder extends VLANFluentImpl<VLANBuilder> implements VisitableBuilder<VLAN,VLANBuilder>{
  public VLANBuilder() {
    this(false);
  }
  public VLANBuilder(Boolean validationEnabled) {
    this(new VLAN(), validationEnabled);
  }
  public VLANBuilder(VLANFluent<?> fluent) {
    this(fluent, false);
  }
  public VLANBuilder(VLANFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VLAN(), validationEnabled);
  }
  public VLANBuilder(VLANFluent<?> fluent,VLAN instance) {
    this(fluent, instance, false);
  }
  public VLANBuilder(VLANFluent<?> fluent,VLAN instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withId(instance.getId()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VLANBuilder(VLAN instance) {
    this(instance,false);
  }
  public VLANBuilder(VLAN instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withId(instance.getId()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  VLANFluent<?> fluent;
  Boolean validationEnabled;
  public VLAN build() {
    VLAN buildable = new VLAN(fluent.getId(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}