package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProvisionStatusFluentImpl<A extends ProvisionStatusFluent<A>> extends BaseFluent<A> implements ProvisionStatusFluent<A>{
  public ProvisionStatusFluentImpl() {
  }
  public ProvisionStatusFluentImpl(ProvisionStatus instance) {
    this.withId(instance.getId()); 
    this.withBootMode(instance.getBootMode()); 
    this.withCustomDeploy(instance.getCustomDeploy()); 
    this.withFirmware(instance.getFirmware()); 
    this.withImage(instance.getImage()); 
    this.withRaid(instance.getRaid()); 
    this.withRootDeviceHints(instance.getRootDeviceHints()); 
    this.withState(instance.getState()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String id;
  private String bootMode;
  private CustomDeployBuilder customDeploy;
  private FirmwareConfigBuilder firmware;
  private ImageBuilder image;
  private RAIDConfigBuilder raid;
  private RootDeviceHintsBuilder rootDeviceHints;
  private String state;
  private Map<String,Object> additionalProperties;
  public String getId() {
    return this.id;
  }
  public A withId(String id) {
    this.id=id; return (A) this;
  }
  public Boolean hasId() {
    return this.id != null;
  }
  public String getBootMode() {
    return this.bootMode;
  }
  public A withBootMode(String bootMode) {
    this.bootMode=bootMode; return (A) this;
  }
  public Boolean hasBootMode() {
    return this.bootMode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCustomDeploy instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomDeploy getCustomDeploy() {
    return this.customDeploy!=null ?this.customDeploy.build():null;
  }
  public CustomDeploy buildCustomDeploy() {
    return this.customDeploy!=null ?this.customDeploy.build():null;
  }
  public A withCustomDeploy(CustomDeploy customDeploy) {
    _visitables.get("customDeploy").remove(this.customDeploy);
    if (customDeploy!=null){ this.customDeploy= new CustomDeployBuilder(customDeploy); _visitables.get("customDeploy").add(this.customDeploy);} else { this.customDeploy = null; _visitables.get("customDeploy").remove(this.customDeploy); } return (A) this;
  }
  public Boolean hasCustomDeploy() {
    return this.customDeploy != null;
  }
  public A withNewCustomDeploy(String method) {
    return (A)withCustomDeploy(new CustomDeploy(method));
  }
  public ProvisionStatusFluent.CustomDeployNested<A> withNewCustomDeploy() {
    return new ProvisionStatusFluentImpl.CustomDeployNestedImpl();
  }
  public ProvisionStatusFluent.CustomDeployNested<A> withNewCustomDeployLike(CustomDeploy item) {
    return new ProvisionStatusFluentImpl.CustomDeployNestedImpl(item);
  }
  public ProvisionStatusFluent.CustomDeployNested<A> editCustomDeploy() {
    return withNewCustomDeployLike(getCustomDeploy());
  }
  public ProvisionStatusFluent.CustomDeployNested<A> editOrNewCustomDeploy() {
    return withNewCustomDeployLike(getCustomDeploy() != null ? getCustomDeploy(): new CustomDeployBuilder().build());
  }
  public ProvisionStatusFluent.CustomDeployNested<A> editOrNewCustomDeployLike(CustomDeploy item) {
    return withNewCustomDeployLike(getCustomDeploy() != null ? getCustomDeploy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFirmware instead.
   * @return The buildable object.
   */
  @Deprecated
  public FirmwareConfig getFirmware() {
    return this.firmware!=null ?this.firmware.build():null;
  }
  public FirmwareConfig buildFirmware() {
    return this.firmware!=null ?this.firmware.build():null;
  }
  public A withFirmware(FirmwareConfig firmware) {
    _visitables.get("firmware").remove(this.firmware);
    if (firmware!=null){ this.firmware= new FirmwareConfigBuilder(firmware); _visitables.get("firmware").add(this.firmware);} else { this.firmware = null; _visitables.get("firmware").remove(this.firmware); } return (A) this;
  }
  public Boolean hasFirmware() {
    return this.firmware != null;
  }
  public A withNewFirmware(Boolean simultaneousMultithreadingEnabled,Boolean sriovEnabled,Boolean virtualizationEnabled) {
    return (A)withFirmware(new FirmwareConfig(simultaneousMultithreadingEnabled, sriovEnabled, virtualizationEnabled));
  }
  public ProvisionStatusFluent.FirmwareNested<A> withNewFirmware() {
    return new ProvisionStatusFluentImpl.FirmwareNestedImpl();
  }
  public ProvisionStatusFluent.FirmwareNested<A> withNewFirmwareLike(FirmwareConfig item) {
    return new ProvisionStatusFluentImpl.FirmwareNestedImpl(item);
  }
  public ProvisionStatusFluent.FirmwareNested<A> editFirmware() {
    return withNewFirmwareLike(getFirmware());
  }
  public ProvisionStatusFluent.FirmwareNested<A> editOrNewFirmware() {
    return withNewFirmwareLike(getFirmware() != null ? getFirmware(): new FirmwareConfigBuilder().build());
  }
  public ProvisionStatusFluent.FirmwareNested<A> editOrNewFirmwareLike(FirmwareConfig item) {
    return withNewFirmwareLike(getFirmware() != null ? getFirmware(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public Image getImage() {
    return this.image!=null ?this.image.build():null;
  }
  public Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} else { this.image = null; _visitables.get("image").remove(this.image); } return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public A withNewImage(String checksum,String checksumType,String format,String url) {
    return (A)withImage(new Image(checksum, checksumType, format, url));
  }
  public ProvisionStatusFluent.ImageNested<A> withNewImage() {
    return new ProvisionStatusFluentImpl.ImageNestedImpl();
  }
  public ProvisionStatusFluent.ImageNested<A> withNewImageLike(Image item) {
    return new ProvisionStatusFluentImpl.ImageNestedImpl(item);
  }
  public ProvisionStatusFluent.ImageNested<A> editImage() {
    return withNewImageLike(getImage());
  }
  public ProvisionStatusFluent.ImageNested<A> editOrNewImage() {
    return withNewImageLike(getImage() != null ? getImage(): new ImageBuilder().build());
  }
  public ProvisionStatusFluent.ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(getImage() != null ? getImage(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRaid instead.
   * @return The buildable object.
   */
  @Deprecated
  public RAIDConfig getRaid() {
    return this.raid!=null ?this.raid.build():null;
  }
  public RAIDConfig buildRaid() {
    return this.raid!=null ?this.raid.build():null;
  }
  public A withRaid(RAIDConfig raid) {
    _visitables.get("raid").remove(this.raid);
    if (raid!=null){ this.raid= new RAIDConfigBuilder(raid); _visitables.get("raid").add(this.raid);} else { this.raid = null; _visitables.get("raid").remove(this.raid); } return (A) this;
  }
  public Boolean hasRaid() {
    return this.raid != null;
  }
  public ProvisionStatusFluent.RaidNested<A> withNewRaid() {
    return new ProvisionStatusFluentImpl.RaidNestedImpl();
  }
  public ProvisionStatusFluent.RaidNested<A> withNewRaidLike(RAIDConfig item) {
    return new ProvisionStatusFluentImpl.RaidNestedImpl(item);
  }
  public ProvisionStatusFluent.RaidNested<A> editRaid() {
    return withNewRaidLike(getRaid());
  }
  public ProvisionStatusFluent.RaidNested<A> editOrNewRaid() {
    return withNewRaidLike(getRaid() != null ? getRaid(): new RAIDConfigBuilder().build());
  }
  public ProvisionStatusFluent.RaidNested<A> editOrNewRaidLike(RAIDConfig item) {
    return withNewRaidLike(getRaid() != null ? getRaid(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRootDeviceHints instead.
   * @return The buildable object.
   */
  @Deprecated
  public RootDeviceHints getRootDeviceHints() {
    return this.rootDeviceHints!=null ?this.rootDeviceHints.build():null;
  }
  public RootDeviceHints buildRootDeviceHints() {
    return this.rootDeviceHints!=null ?this.rootDeviceHints.build():null;
  }
  public A withRootDeviceHints(RootDeviceHints rootDeviceHints) {
    _visitables.get("rootDeviceHints").remove(this.rootDeviceHints);
    if (rootDeviceHints!=null){ this.rootDeviceHints= new RootDeviceHintsBuilder(rootDeviceHints); _visitables.get("rootDeviceHints").add(this.rootDeviceHints);} else { this.rootDeviceHints = null; _visitables.get("rootDeviceHints").remove(this.rootDeviceHints); } return (A) this;
  }
  public Boolean hasRootDeviceHints() {
    return this.rootDeviceHints != null;
  }
  public ProvisionStatusFluent.RootDeviceHintsNested<A> withNewRootDeviceHints() {
    return new ProvisionStatusFluentImpl.RootDeviceHintsNestedImpl();
  }
  public ProvisionStatusFluent.RootDeviceHintsNested<A> withNewRootDeviceHintsLike(RootDeviceHints item) {
    return new ProvisionStatusFluentImpl.RootDeviceHintsNestedImpl(item);
  }
  public ProvisionStatusFluent.RootDeviceHintsNested<A> editRootDeviceHints() {
    return withNewRootDeviceHintsLike(getRootDeviceHints());
  }
  public ProvisionStatusFluent.RootDeviceHintsNested<A> editOrNewRootDeviceHints() {
    return withNewRootDeviceHintsLike(getRootDeviceHints() != null ? getRootDeviceHints(): new RootDeviceHintsBuilder().build());
  }
  public ProvisionStatusFluent.RootDeviceHintsNested<A> editOrNewRootDeviceHintsLike(RootDeviceHints item) {
    return withNewRootDeviceHintsLike(getRootDeviceHints() != null ? getRootDeviceHints(): item);
  }
  public String getState() {
    return this.state;
  }
  public A withState(String state) {
    this.state=state; return (A) this;
  }
  public Boolean hasState() {
    return this.state != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProvisionStatusFluentImpl that = (ProvisionStatusFluentImpl) o;
    if (id != null ? !id.equals(that.id) :that.id != null) return false;
    if (bootMode != null ? !bootMode.equals(that.bootMode) :that.bootMode != null) return false;
    if (customDeploy != null ? !customDeploy.equals(that.customDeploy) :that.customDeploy != null) return false;
    if (firmware != null ? !firmware.equals(that.firmware) :that.firmware != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (raid != null ? !raid.equals(that.raid) :that.raid != null) return false;
    if (rootDeviceHints != null ? !rootDeviceHints.equals(that.rootDeviceHints) :that.rootDeviceHints != null) return false;
    if (state != null ? !state.equals(that.state) :that.state != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(id,  bootMode,  customDeploy,  firmware,  image,  raid,  rootDeviceHints,  state,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (bootMode != null) { sb.append("bootMode:"); sb.append(bootMode + ","); }
    if (customDeploy != null) { sb.append("customDeploy:"); sb.append(customDeploy + ","); }
    if (firmware != null) { sb.append("firmware:"); sb.append(firmware + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (raid != null) { sb.append("raid:"); sb.append(raid + ","); }
    if (rootDeviceHints != null) { sb.append("rootDeviceHints:"); sb.append(rootDeviceHints + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CustomDeployNestedImpl<N> extends CustomDeployFluentImpl<ProvisionStatusFluent.CustomDeployNested<N>> implements ProvisionStatusFluent.CustomDeployNested<N>,Nested<N>{
    CustomDeployNestedImpl(CustomDeploy item) {
      this.builder = new CustomDeployBuilder(this, item);
    }
    CustomDeployNestedImpl() {
      this.builder = new CustomDeployBuilder(this);
    }
    CustomDeployBuilder builder;
    public N and() {
      return (N) ProvisionStatusFluentImpl.this.withCustomDeploy(builder.build());
    }
    public N endCustomDeploy() {
      return and();
    }
    
  }
  class FirmwareNestedImpl<N> extends FirmwareConfigFluentImpl<ProvisionStatusFluent.FirmwareNested<N>> implements ProvisionStatusFluent.FirmwareNested<N>,Nested<N>{
    FirmwareNestedImpl(FirmwareConfig item) {
      this.builder = new FirmwareConfigBuilder(this, item);
    }
    FirmwareNestedImpl() {
      this.builder = new FirmwareConfigBuilder(this);
    }
    FirmwareConfigBuilder builder;
    public N and() {
      return (N) ProvisionStatusFluentImpl.this.withFirmware(builder.build());
    }
    public N endFirmware() {
      return and();
    }
    
  }
  class ImageNestedImpl<N> extends ImageFluentImpl<ProvisionStatusFluent.ImageNested<N>> implements ProvisionStatusFluent.ImageNested<N>,Nested<N>{
    ImageNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) ProvisionStatusFluentImpl.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class RaidNestedImpl<N> extends RAIDConfigFluentImpl<ProvisionStatusFluent.RaidNested<N>> implements ProvisionStatusFluent.RaidNested<N>,Nested<N>{
    RaidNestedImpl(RAIDConfig item) {
      this.builder = new RAIDConfigBuilder(this, item);
    }
    RaidNestedImpl() {
      this.builder = new RAIDConfigBuilder(this);
    }
    RAIDConfigBuilder builder;
    public N and() {
      return (N) ProvisionStatusFluentImpl.this.withRaid(builder.build());
    }
    public N endRaid() {
      return and();
    }
    
  }
  class RootDeviceHintsNestedImpl<N> extends RootDeviceHintsFluentImpl<ProvisionStatusFluent.RootDeviceHintsNested<N>> implements ProvisionStatusFluent.RootDeviceHintsNested<N>,Nested<N>{
    RootDeviceHintsNestedImpl(RootDeviceHints item) {
      this.builder = new RootDeviceHintsBuilder(this, item);
    }
    RootDeviceHintsNestedImpl() {
      this.builder = new RootDeviceHintsBuilder(this);
    }
    RootDeviceHintsBuilder builder;
    public N and() {
      return (N) ProvisionStatusFluentImpl.this.withRootDeviceHints(builder.build());
    }
    public N endRootDeviceHints() {
      return and();
    }
    
  }
  
}