package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FirmwareConfigBuilder extends FirmwareConfigFluentImpl<FirmwareConfigBuilder> implements VisitableBuilder<FirmwareConfig,FirmwareConfigBuilder>{
  public FirmwareConfigBuilder() {
    this(false);
  }
  public FirmwareConfigBuilder(Boolean validationEnabled) {
    this(new FirmwareConfig(), validationEnabled);
  }
  public FirmwareConfigBuilder(FirmwareConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public FirmwareConfigBuilder(FirmwareConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FirmwareConfig(), validationEnabled);
  }
  public FirmwareConfigBuilder(FirmwareConfigFluent<?> fluent,FirmwareConfig instance) {
    this(fluent, instance, false);
  }
  public FirmwareConfigBuilder(FirmwareConfigFluent<?> fluent,FirmwareConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSimultaneousMultithreadingEnabled(instance.getSimultaneousMultithreadingEnabled()); 
    fluent.withSriovEnabled(instance.getSriovEnabled()); 
    fluent.withVirtualizationEnabled(instance.getVirtualizationEnabled()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FirmwareConfigBuilder(FirmwareConfig instance) {
    this(instance,false);
  }
  public FirmwareConfigBuilder(FirmwareConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSimultaneousMultithreadingEnabled(instance.getSimultaneousMultithreadingEnabled()); 
    this.withSriovEnabled(instance.getSriovEnabled()); 
    this.withVirtualizationEnabled(instance.getVirtualizationEnabled()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  FirmwareConfigFluent<?> fluent;
  Boolean validationEnabled;
  public FirmwareConfig build() {
    FirmwareConfig buildable = new FirmwareConfig(fluent.getSimultaneousMultithreadingEnabled(),fluent.getSriovEnabled(),fluent.getVirtualizationEnabled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}