package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigBuilder extends ConfigFluentImpl<ConfigBuilder> implements VisitableBuilder<Config,ConfigBuilder>{
  public ConfigBuilder() {
    this(false);
  }
  public ConfigBuilder(Boolean validationEnabled) {
    this(new Config(), validationEnabled);
  }
  public ConfigBuilder(ConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Config(), validationEnabled);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Config instance) {
    this(fluent, instance, false);
  }
  public ConfigBuilder(ConfigFluent<?> fluent,Config instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigBuilder(Config instance) {
    this(instance,false);
  }
  public ConfigBuilder(Config instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConfigFluent<?> fluent;
  Boolean validationEnabled;
  public Config build() {
    Config buildable = new Config(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}