package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PerResourceAPIRequestLogBuilder extends PerResourceAPIRequestLogFluentImpl<PerResourceAPIRequestLogBuilder> implements VisitableBuilder<PerResourceAPIRequestLog,PerResourceAPIRequestLogBuilder>{
  public PerResourceAPIRequestLogBuilder() {
    this(false);
  }
  public PerResourceAPIRequestLogBuilder(Boolean validationEnabled) {
    this(new PerResourceAPIRequestLog(), validationEnabled);
  }
  public PerResourceAPIRequestLogBuilder(PerResourceAPIRequestLogFluent<?> fluent) {
    this(fluent, false);
  }
  public PerResourceAPIRequestLogBuilder(PerResourceAPIRequestLogFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PerResourceAPIRequestLog(), validationEnabled);
  }
  public PerResourceAPIRequestLogBuilder(PerResourceAPIRequestLogFluent<?> fluent,PerResourceAPIRequestLog instance) {
    this(fluent, instance, false);
  }
  public PerResourceAPIRequestLogBuilder(PerResourceAPIRequestLogFluent<?> fluent,PerResourceAPIRequestLog instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withByNode(instance.getByNode()); 
    fluent.withRequestCount(instance.getRequestCount()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PerResourceAPIRequestLogBuilder(PerResourceAPIRequestLog instance) {
    this(instance,false);
  }
  public PerResourceAPIRequestLogBuilder(PerResourceAPIRequestLog instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withByNode(instance.getByNode()); 
    this.withRequestCount(instance.getRequestCount()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PerResourceAPIRequestLogFluent<?> fluent;
  Boolean validationEnabled;
  public PerResourceAPIRequestLog build() {
    PerResourceAPIRequestLog buildable = new PerResourceAPIRequestLog(fluent.getByNode(),fluent.getRequestCount());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}