package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageRegistryConfigStorageAlibabaOSSFluent<A extends ImageRegistryConfigStorageAlibabaOSSFluent<A>> extends BaseFluent<A>{
  public ImageRegistryConfigStorageAlibabaOSSFluent() {
  }
  
  public ImageRegistryConfigStorageAlibabaOSSFluent(ImageRegistryConfigStorageAlibabaOSS instance) {
    this.copyInstance(instance);
  }
  private String bucket;
  private EncryptionAlibabaBuilder encryption;
  private String endpointAccessibility;
  private String region;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageRegistryConfigStorageAlibabaOSS instance) {
    instance = (instance != null ? instance : new ImageRegistryConfigStorageAlibabaOSS());
    if (instance != null) {
          this.withBucket(instance.getBucket());
          this.withEncryption(instance.getEncryption());
          this.withEndpointAccessibility(instance.getEndpointAccessibility());
          this.withRegion(instance.getRegion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBucket() {
    return this.bucket;
  }
  
  public A withBucket(String bucket) {
    this.bucket = bucket;
    return (A) this;
  }
  
  public boolean hasBucket() {
    return this.bucket != null;
  }
  
  public EncryptionAlibaba buildEncryption() {
    return this.encryption != null ? this.encryption.build() : null;
  }
  
  public A withEncryption(EncryptionAlibaba encryption) {
    this._visitables.remove("encryption");
    if (encryption != null) {
        this.encryption = new EncryptionAlibabaBuilder(encryption);
        this._visitables.get("encryption").add(this.encryption);
    } else {
        this.encryption = null;
        this._visitables.get("encryption").remove(this.encryption);
    }
    return (A) this;
  }
  
  public boolean hasEncryption() {
    return this.encryption != null;
  }
  
  public EncryptionNested<A> withNewEncryption() {
    return new EncryptionNested(null);
  }
  
  public EncryptionNested<A> withNewEncryptionLike(EncryptionAlibaba item) {
    return new EncryptionNested(item);
  }
  
  public EncryptionNested<A> editEncryption() {
    return withNewEncryptionLike(java.util.Optional.ofNullable(buildEncryption()).orElse(null));
  }
  
  public EncryptionNested<A> editOrNewEncryption() {
    return withNewEncryptionLike(java.util.Optional.ofNullable(buildEncryption()).orElse(new EncryptionAlibabaBuilder().build()));
  }
  
  public EncryptionNested<A> editOrNewEncryptionLike(EncryptionAlibaba item) {
    return withNewEncryptionLike(java.util.Optional.ofNullable(buildEncryption()).orElse(item));
  }
  
  public String getEndpointAccessibility() {
    return this.endpointAccessibility;
  }
  
  public A withEndpointAccessibility(String endpointAccessibility) {
    this.endpointAccessibility = endpointAccessibility;
    return (A) this;
  }
  
  public boolean hasEndpointAccessibility() {
    return this.endpointAccessibility != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageRegistryConfigStorageAlibabaOSSFluent that = (ImageRegistryConfigStorageAlibabaOSSFluent) o;
    if (!java.util.Objects.equals(bucket, that.bucket)) return false;
    if (!java.util.Objects.equals(encryption, that.encryption)) return false;
    if (!java.util.Objects.equals(endpointAccessibility, that.endpointAccessibility)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bucket,  encryption,  endpointAccessibility,  region,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bucket != null) { sb.append("bucket:"); sb.append(bucket + ","); }
    if (encryption != null) { sb.append("encryption:"); sb.append(encryption + ","); }
    if (endpointAccessibility != null) { sb.append("endpointAccessibility:"); sb.append(endpointAccessibility + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EncryptionNested<N> extends EncryptionAlibabaFluent<EncryptionNested<N>> implements Nested<N>{
    EncryptionNested(EncryptionAlibaba item) {
      this.builder = new EncryptionAlibabaBuilder(this, item);
    }
    EncryptionAlibabaBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageAlibabaOSSFluent.this.withEncryption(builder.build());
    }
    
    public N endEncryption() {
      return and();
    }
    
  
  }

}