package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CertExpiryFluent<A extends io.fabric8.openshift.api.model.machineconfiguration.v1.CertExpiryFluent<A>> extends BaseFluent<A>{

  private Map<String,Object> additionalProperties;
  private String bundle;
  private String expiry;
  private String subject;

  public CertExpiryFluent() {
  }
  
  public CertExpiryFluent(CertExpiry instance) {
    this.copyInstance(instance);
  }

  public A addToAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null && map != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (map != null) {
      this.additionalProperties.putAll(map);
    }
    return (A) this;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if (this.additionalProperties == null && key != null && value != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (key != null && value != null) {
      this.additionalProperties.put(key, value);
    }
    return (A) this;
  }
  
  protected void copyInstance(CertExpiry instance) {
    instance = instance != null ? instance : new CertExpiry();
    if (instance != null) {
        this.withBundle(instance.getBundle());
        this.withExpiry(instance.getExpiry());
        this.withSubject(instance.getSubject());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }
    if (!(super.equals(o))) {
      return false;
    }
    CertExpiryFluent that = (CertExpiryFluent) o;
    if (!(Objects.equals(bundle, that.bundle))) {
      return false;
    }
    if (!(Objects.equals(expiry, that.expiry))) {
      return false;
    }
    if (!(Objects.equals(subject, that.subject))) {
      return false;
    }
    if (!(Objects.equals(additionalProperties, that.additionalProperties))) {
      return false;
    }
    return true;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public String getBundle() {
    return this.bundle;
  }
  
  public String getExpiry() {
    return this.expiry;
  }
  
  public String getSubject() {
    return this.subject;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean hasBundle() {
    return this.bundle != null;
  }
  
  public boolean hasExpiry() {
    return this.expiry != null;
  }
  
  public boolean hasSubject() {
    return this.subject != null;
  }
  
  public int hashCode() {
    return Objects.hash(bundle, expiry, subject, additionalProperties);
  }
  
  public A removeFromAdditionalProperties(String key) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (key != null && this.additionalProperties != null) {
      this.additionalProperties.remove(key);
    }
    return (A) this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (map != null) {
      for (Object key : map.keySet()) {
        if (this.additionalProperties != null) {
          this.additionalProperties.remove(key);
        }
      }
    }
    return (A) this;
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (!(bundle == null)) {
        sb.append("bundle:");
        sb.append(bundle);
        sb.append(",");
    }
    if (!(expiry == null)) {
        sb.append("expiry:");
        sb.append(expiry);
        sb.append(",");
    }
    if (!(subject == null)) {
        sb.append("subject:");
        sb.append(subject);
        sb.append(",");
    }
    if (!(additionalProperties == null) && !(additionalProperties.isEmpty())) {
        sb.append("additionalProperties:");
        sb.append(additionalProperties);
    }
    sb.append("}");
    return sb.toString();
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public A withBundle(String bundle) {
    this.bundle = bundle;
    return (A) this;
  }
  
  public A withExpiry(String expiry) {
    this.expiry = expiry;
    return (A) this;
  }
  
  public A withSubject(String subject) {
    this.subject = subject;
    return (A) this;
  }
  
}