/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachineConfigSpecFluent<A extends MachineConfigSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String baseOSExtensionsContainerImage;
    private Object config;
    private List<String> extensions = new ArrayList<String>();
    private Boolean fips;
    private List<String> kernelArguments = new ArrayList<String>();
    private String kernelType;
    private String osImageURL;

    public MachineConfigSpecFluent() {
    }

    public MachineConfigSpecFluent(MachineConfigSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToExtensions(Collection<String> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        for (String item : items) {
            this.extensions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToKernelArguments(Collection<String> items) {
        if (this.kernelArguments == null) {
            this.kernelArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.kernelArguments.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToExtensions(String ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        for (String item : items) {
            this.extensions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToExtensions(int index, String item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        this.extensions.add(index, item);
        return (A)((Object)this);
    }

    public A addToKernelArguments(String ... items) {
        if (this.kernelArguments == null) {
            this.kernelArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.kernelArguments.add(item);
        }
        return (A)((Object)this);
    }

    public A addToKernelArguments(int index, String item) {
        if (this.kernelArguments == null) {
            this.kernelArguments = new ArrayList<String>();
        }
        this.kernelArguments.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(MachineConfigSpec instance) {
        MachineConfigSpec machineConfigSpec = instance = instance != null ? instance : new MachineConfigSpec();
        if (instance != null) {
            this.withBaseOSExtensionsContainerImage(instance.getBaseOSExtensionsContainerImage());
            this.withConfig(instance.getConfig());
            this.withExtensions(instance.getExtensions());
            this.withFips(instance.getFips());
            this.withKernelArguments(instance.getKernelArguments());
            this.withKernelType(instance.getKernelType());
            this.withOsImageURL(instance.getOsImageURL());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigSpecFluent that = (MachineConfigSpecFluent)((Object)o);
        if (!Objects.equals(this.baseOSExtensionsContainerImage, that.baseOSExtensionsContainerImage)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.extensions, that.extensions)) {
            return false;
        }
        if (!Objects.equals(this.fips, that.fips)) {
            return false;
        }
        if (!Objects.equals(this.kernelArguments, that.kernelArguments)) {
            return false;
        }
        if (!Objects.equals(this.kernelType, that.kernelType)) {
            return false;
        }
        if (!Objects.equals(this.osImageURL, that.osImageURL)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBaseOSExtensionsContainerImage() {
        return this.baseOSExtensionsContainerImage;
    }

    public Object getConfig() {
        return this.config;
    }

    public String getExtension(int index) {
        return this.extensions.get(index);
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public Boolean getFips() {
        return this.fips;
    }

    public String getFirstExtension() {
        return this.extensions.get(0);
    }

    public String getFirstKernelArgument() {
        return this.kernelArguments.get(0);
    }

    public String getKernelArgument(int index) {
        return this.kernelArguments.get(index);
    }

    public List<String> getKernelArguments() {
        return this.kernelArguments;
    }

    public String getKernelType() {
        return this.kernelType;
    }

    public String getLastExtension() {
        return this.extensions.get(this.extensions.size() - 1);
    }

    public String getLastKernelArgument() {
        return this.kernelArguments.get(this.kernelArguments.size() - 1);
    }

    public String getMatchingExtension(Predicate<String> predicate) {
        for (String item : this.extensions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingKernelArgument(Predicate<String> predicate) {
        for (String item : this.kernelArguments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getOsImageURL() {
        return this.osImageURL;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBaseOSExtensionsContainerImage() {
        return this.baseOSExtensionsContainerImage != null;
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public boolean hasFips() {
        return this.fips != null;
    }

    public boolean hasKernelArguments() {
        return this.kernelArguments != null && !this.kernelArguments.isEmpty();
    }

    public boolean hasKernelType() {
        return this.kernelType != null;
    }

    public boolean hasMatchingExtension(Predicate<String> predicate) {
        for (String item : this.extensions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingKernelArgument(Predicate<String> predicate) {
        for (String item : this.kernelArguments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOsImageURL() {
        return this.osImageURL != null;
    }

    public int hashCode() {
        return Objects.hash(this.baseOSExtensionsContainerImage, this.config, this.extensions, this.fips, this.kernelArguments, this.kernelType, this.osImageURL, this.additionalProperties);
    }

    public A removeAllFromExtensions(Collection<String> items) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.extensions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKernelArguments(Collection<String> items) {
        if (this.kernelArguments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.kernelArguments.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromExtensions(String ... items) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.extensions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromKernelArguments(String ... items) {
        if (this.kernelArguments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.kernelArguments.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToExtensions(int index, String item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        this.extensions.set(index, item);
        return (A)((Object)this);
    }

    public A setToKernelArguments(int index, String item) {
        if (this.kernelArguments == null) {
            this.kernelArguments = new ArrayList<String>();
        }
        this.kernelArguments.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseOSExtensionsContainerImage != null) {
            sb.append("baseOSExtensionsContainerImage:");
            sb.append(this.baseOSExtensionsContainerImage);
            sb.append(",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append(this.config);
            sb.append(",");
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            sb.append("extensions:");
            sb.append(this.extensions);
            sb.append(",");
        }
        if (this.fips != null) {
            sb.append("fips:");
            sb.append(this.fips);
            sb.append(",");
        }
        if (this.kernelArguments != null && !this.kernelArguments.isEmpty()) {
            sb.append("kernelArguments:");
            sb.append(this.kernelArguments);
            sb.append(",");
        }
        if (this.kernelType != null) {
            sb.append("kernelType:");
            sb.append(this.kernelType);
            sb.append(",");
        }
        if (this.osImageURL != null) {
            sb.append("osImageURL:");
            sb.append(this.osImageURL);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBaseOSExtensionsContainerImage(String baseOSExtensionsContainerImage) {
        this.baseOSExtensionsContainerImage = baseOSExtensionsContainerImage;
        return (A)((Object)this);
    }

    public A withConfig(Object config) {
        this.config = config;
        return (A)((Object)this);
    }

    public A withExtensions(List<String> extensions) {
        if (extensions != null) {
            this.extensions = new ArrayList<String>();
            for (String item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)((Object)this);
    }

    public A withExtensions(String ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
            this._visitables.remove((Object)"extensions");
        }
        if (extensions != null) {
            for (String item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withFips() {
        return this.withFips(true);
    }

    public A withFips(Boolean fips) {
        this.fips = fips;
        return (A)((Object)this);
    }

    public A withKernelArguments(List<String> kernelArguments) {
        if (kernelArguments != null) {
            this.kernelArguments = new ArrayList<String>();
            for (String item : kernelArguments) {
                this.addToKernelArguments(item);
            }
        } else {
            this.kernelArguments = null;
        }
        return (A)((Object)this);
    }

    public A withKernelArguments(String ... kernelArguments) {
        if (this.kernelArguments != null) {
            this.kernelArguments.clear();
            this._visitables.remove((Object)"kernelArguments");
        }
        if (kernelArguments != null) {
            for (String item : kernelArguments) {
                this.addToKernelArguments(item);
            }
        }
        return (A)((Object)this);
    }

    public A withKernelType(String kernelType) {
        this.kernelType = kernelType;
        return (A)((Object)this);
    }

    public A withOsImageURL(String osImageURL) {
        this.osImageURL = osImageURL;
        return (A)((Object)this);
    }
}

