/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageRef;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageRefBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageRefFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageSetSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PinnedImageSetSpecFluent<A extends PinnedImageSetSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<PinnedImageRefBuilder> pinnedImages = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PinnedImageSetSpecFluent() {
    }

    public PinnedImageSetSpecFluent(PinnedImageSetSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PinnedImageSetSpec instance) {
        PinnedImageSetSpec pinnedImageSetSpec = instance = instance != null ? instance : new PinnedImageSetSpec();
        if (instance != null) {
            this.withPinnedImages(instance.getPinnedImages());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToPinnedImages(int index, PinnedImageRef item) {
        if (this.pinnedImages == null) {
            this.pinnedImages = new ArrayList();
        }
        PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
        if (index < 0 || index >= this.pinnedImages.size()) {
            this._visitables.get((Object)"pinnedImages").add(builder);
            this.pinnedImages.add(builder);
        } else {
            this._visitables.get((Object)"pinnedImages").add(index, builder);
            this.pinnedImages.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPinnedImages(int index, PinnedImageRef item) {
        if (this.pinnedImages == null) {
            this.pinnedImages = new ArrayList();
        }
        PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
        if (index < 0 || index >= this.pinnedImages.size()) {
            this._visitables.get((Object)"pinnedImages").add(builder);
            this.pinnedImages.add(builder);
        } else {
            this._visitables.get((Object)"pinnedImages").set(index, builder);
            this.pinnedImages.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPinnedImages(PinnedImageRef ... items) {
        if (this.pinnedImages == null) {
            this.pinnedImages = new ArrayList();
        }
        for (PinnedImageRef item : items) {
            PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
            this._visitables.get((Object)"pinnedImages").add(builder);
            this.pinnedImages.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPinnedImages(Collection<PinnedImageRef> items) {
        if (this.pinnedImages == null) {
            this.pinnedImages = new ArrayList();
        }
        for (PinnedImageRef item : items) {
            PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
            this._visitables.get((Object)"pinnedImages").add(builder);
            this.pinnedImages.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPinnedImages(PinnedImageRef ... items) {
        if (this.pinnedImages == null) {
            return (A)((Object)this);
        }
        for (PinnedImageRef item : items) {
            PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
            this._visitables.get((Object)"pinnedImages").remove((Object)builder);
            this.pinnedImages.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPinnedImages(Collection<PinnedImageRef> items) {
        if (this.pinnedImages == null) {
            return (A)((Object)this);
        }
        for (PinnedImageRef item : items) {
            PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
            this._visitables.get((Object)"pinnedImages").remove((Object)builder);
            this.pinnedImages.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPinnedImages(Predicate<PinnedImageRefBuilder> predicate) {
        if (this.pinnedImages == null) {
            return (A)((Object)this);
        }
        Iterator<PinnedImageRefBuilder> each = this.pinnedImages.iterator();
        List visitables = this._visitables.get((Object)"pinnedImages");
        while (each.hasNext()) {
            PinnedImageRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PinnedImageRef> buildPinnedImages() {
        return this.pinnedImages != null ? PinnedImageSetSpecFluent.build(this.pinnedImages) : null;
    }

    public PinnedImageRef buildPinnedImage(int index) {
        return this.pinnedImages.get(index).build();
    }

    public PinnedImageRef buildFirstPinnedImage() {
        return this.pinnedImages.get(0).build();
    }

    public PinnedImageRef buildLastPinnedImage() {
        return this.pinnedImages.get(this.pinnedImages.size() - 1).build();
    }

    public PinnedImageRef buildMatchingPinnedImage(Predicate<PinnedImageRefBuilder> predicate) {
        for (PinnedImageRefBuilder item : this.pinnedImages) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPinnedImage(Predicate<PinnedImageRefBuilder> predicate) {
        for (PinnedImageRefBuilder item : this.pinnedImages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPinnedImages(List<PinnedImageRef> pinnedImages) {
        if (this.pinnedImages != null) {
            this._visitables.get((Object)"pinnedImages").clear();
        }
        if (pinnedImages != null) {
            this.pinnedImages = new ArrayList();
            for (PinnedImageRef item : pinnedImages) {
                this.addToPinnedImages(item);
            }
        } else {
            this.pinnedImages = null;
        }
        return (A)((Object)this);
    }

    public A withPinnedImages(PinnedImageRef ... pinnedImages) {
        if (this.pinnedImages != null) {
            this.pinnedImages.clear();
            this._visitables.remove((Object)"pinnedImages");
        }
        if (pinnedImages != null) {
            for (PinnedImageRef item : pinnedImages) {
                this.addToPinnedImages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPinnedImages() {
        return this.pinnedImages != null && !this.pinnedImages.isEmpty();
    }

    public A addNewPinnedImage(String name) {
        return this.addToPinnedImages(new PinnedImageRef(name));
    }

    public PinnedImagesNested<A> addNewPinnedImage() {
        return new PinnedImagesNested(-1, null);
    }

    public PinnedImagesNested<A> addNewPinnedImageLike(PinnedImageRef item) {
        return new PinnedImagesNested(-1, item);
    }

    public PinnedImagesNested<A> setNewPinnedImageLike(int index, PinnedImageRef item) {
        return new PinnedImagesNested(index, item);
    }

    public PinnedImagesNested<A> editPinnedImage(int index) {
        if (this.pinnedImages.size() <= index) {
            throw new RuntimeException("Can't edit pinnedImages. Index exceeds size.");
        }
        return this.setNewPinnedImageLike(index, this.buildPinnedImage(index));
    }

    public PinnedImagesNested<A> editFirstPinnedImage() {
        if (this.pinnedImages.size() == 0) {
            throw new RuntimeException("Can't edit first pinnedImages. The list is empty.");
        }
        return this.setNewPinnedImageLike(0, this.buildPinnedImage(0));
    }

    public PinnedImagesNested<A> editLastPinnedImage() {
        int index = this.pinnedImages.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pinnedImages. The list is empty.");
        }
        return this.setNewPinnedImageLike(index, this.buildPinnedImage(index));
    }

    public PinnedImagesNested<A> editMatchingPinnedImage(Predicate<PinnedImageRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pinnedImages.size(); ++i) {
            if (!predicate.test(this.pinnedImages.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pinnedImages. No match found.");
        }
        return this.setNewPinnedImageLike(index, this.buildPinnedImage(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PinnedImageSetSpecFluent that = (PinnedImageSetSpecFluent)((Object)o);
        if (!Objects.equals(this.pinnedImages, that.pinnedImages)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.pinnedImages, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pinnedImages != null && !this.pinnedImages.isEmpty()) {
            sb.append("pinnedImages:");
            sb.append(this.pinnedImages + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PinnedImagesNested<N>
    extends PinnedImageRefFluent<PinnedImagesNested<N>>
    implements Nested<N> {
        PinnedImageRefBuilder builder;
        int index;

        PinnedImagesNested(int index, PinnedImageRef item) {
            this.index = index;
            this.builder = new PinnedImageRefBuilder(this, item);
        }

        public N and() {
            return (N)PinnedImageSetSpecFluent.this.setToPinnedImages(this.index, this.builder.build());
        }

        public N endPinnedImage() {
            return this.and();
        }
    }
}

